/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Streams;

public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    protected StandardComparisonStrategy() {
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>((o1, o2) -> {
            if (this.areEqual(o1, o2)) {
                return 0;
            }
            return Objects.hashCodeFor(o1) < Objects.hashCodeFor(o2) ? -1 : 1;
        });
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        Class<?> otherClass;
        if (actual == null) {
            return other == null;
        }
        Class<?> actualClass = actual.getClass();
        if (actualClass.isArray() && other != null && (otherClass = other.getClass()).isArray()) {
            if (actualClass.getComponentType().isPrimitive() && otherClass.getComponentType().isPrimitive()) {
                if (actual instanceof byte[] && other instanceof byte[]) {
                    return Arrays.equals((byte[])actual, (byte[])other);
                }
                if (actual instanceof short[] && other instanceof short[]) {
                    return Arrays.equals((short[])actual, (short[])other);
                }
                if (actual instanceof int[] && other instanceof int[]) {
                    return Arrays.equals((int[])actual, (int[])other);
                }
                if (actual instanceof long[] && other instanceof long[]) {
                    return Arrays.equals((long[])actual, (long[])other);
                }
                if (actual instanceof char[] && other instanceof char[]) {
                    return Arrays.equals((char[])actual, (char[])other);
                }
                if (actual instanceof float[] && other instanceof float[]) {
                    return Arrays.equals((float[])actual, (float[])other);
                }
                if (actual instanceof double[] && other instanceof double[]) {
                    return Arrays.equals((double[])actual, (double[])other);
                }
                if (actual instanceof boolean[] && other instanceof boolean[]) {
                    return Arrays.equals((boolean[])actual, (boolean[])other);
                }
            }
            if (actual instanceof Object[] && other instanceof Object[]) {
                return Arrays.deepEquals((Object[])actual, (Object[])other);
            }
        }
        return actual.equals(other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value2) {
        if (iterable == null) {
            return false;
        }
        return Streams.stream(iterable).anyMatch(object -> this.areEqual(object, value2));
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value2) {
        if (iterable == null) {
            return;
        }
        if (iterable instanceof Collection) {
            ((Collection)iterable).removeIf(o -> this.areEqual(o, value2));
        } else {
            Iterator<?> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                if (!this.areEqual(iterator2.next(), value2)) continue;
                iterator2.remove();
            }
        }
    }

    @Override
    public void iterablesRemoveFirst(Iterable<?> iterable, Object value2) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            if (!this.areEqual(iterator2.next(), value2)) continue;
            iterator2.remove();
            return;
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        return string.contains(sequence);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        this.checkArgumentIsComparable(actual);
        return ((Comparable)actual).compareTo(other) > 0;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        this.checkArgumentIsComparable(actual);
        return ((Comparable)actual).compareTo(other) < 0;
    }

    private void checkArgumentIsComparable(Object actual) {
        Preconditions.checkArgument(actual instanceof Comparable, "argument '%s' should be Comparable but is not", actual);
    }

    @Override
    public boolean isStandard() {
        return true;
    }
}

