/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldAccept;
import org.assertj.core.error.ShouldNotAccept;
import org.assertj.core.internal.Iterables;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.util.VisibleForTesting;

abstract class AbstractPredicateLikeAssert<SELF extends AbstractPredicateLikeAssert<SELF, PRIMITIVE_PREDICATE, PRIMITIVE>, PRIMITIVE_PREDICATE, PRIMITIVE>
extends AbstractAssert<SELF, PRIMITIVE_PREDICATE> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();
    @VisibleForTesting
    Predicate<PRIMITIVE> primitivePredicate;

    protected AbstractPredicateLikeAssert(PRIMITIVE_PREDICATE actual, Predicate<PRIMITIVE> wrappedPredicate, Class<?> selfType) {
        super(actual, selfType);
        this.primitivePredicate = wrappedPredicate;
    }

    protected SELF acceptsInternal(PRIMITIVE value2) {
        this.isNotNull();
        if (!this.primitivePredicate.test(value2)) {
            this.throwAssertionError(ShouldAccept.shouldAccept(this.primitivePredicate, value2, PredicateDescription.GIVEN));
        }
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF rejectsInternal(PRIMITIVE value2) {
        this.isNotNull();
        if (this.primitivePredicate.test(value2)) {
            this.throwAssertionError(ShouldNotAccept.shouldNotAccept(this.primitivePredicate, value2, PredicateDescription.GIVEN));
        }
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF acceptsAllInternal(Iterable<? extends PRIMITIVE> values) {
        this.isNotNull();
        this.iterables.assertAllMatch(this.info, values, this.primitivePredicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF rejectsAllInternal(Iterable<? extends PRIMITIVE> values) {
        this.isNotNull();
        this.iterables.assertNoneMatch(this.info, values, this.primitivePredicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }
}

