/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.nullability.MaybeNull;

public interface ConstantValue {
    public TypeDescription getTypeDescription();

    public StackManipulation toStackManipulation();

    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    implements ConstantValue {
        private final StackManipulation stackManipulation;
        private final TypeDescription typeDescription;

        protected Simple(StackManipulation stackManipulation, TypeDescription typeDescription) {
            this.stackManipulation = stackManipulation;
            this.typeDescription = typeDescription;
        }

        public static ConstantValue wrap(Object value2) {
            ConstantValue constant = Simple.wrapOrNull(value2);
            if (constant == null) {
                throw new IllegalArgumentException("Not a constant value: " + value2);
            }
            return constant;
        }

        @MaybeNull
        public static ConstantValue wrapOrNull(Object value2) {
            if (value2 instanceof ConstantValue) {
                return (ConstantValue)value2;
            }
            if (value2 instanceof TypeDescription) {
                return ((TypeDescription)value2).isPrimitive() ? new Simple(ClassConstant.of((TypeDescription)value2), TypeDescription.ForLoadedType.of(Class.class)) : JavaConstant.Simple.of((TypeDescription)value2);
            }
            if (value2 instanceof EnumerationDescription) {
                return new Simple(FieldAccess.forEnumeration((EnumerationDescription)value2), ((EnumerationDescription)value2).getEnumerationType());
            }
            if (value2 instanceof Boolean) {
                return new Simple(IntegerConstant.forValue((Boolean)value2), TypeDescription.ForLoadedType.of(Boolean.TYPE));
            }
            if (value2 instanceof Byte) {
                return new Simple(IntegerConstant.forValue(((Byte)value2).byteValue()), TypeDescription.ForLoadedType.of(Byte.TYPE));
            }
            if (value2 instanceof Short) {
                return new Simple(IntegerConstant.forValue(((Short)value2).shortValue()), TypeDescription.ForLoadedType.of(Short.TYPE));
            }
            if (value2 instanceof Character) {
                return new Simple(IntegerConstant.forValue(((Character)value2).charValue()), TypeDescription.ForLoadedType.of(Character.TYPE));
            }
            if (value2 instanceof Class) {
                return ((Class)value2).isPrimitive() ? new Simple(ClassConstant.of(TypeDescription.ForLoadedType.of((Class)value2)), TypeDescription.ForLoadedType.of(Class.class)) : JavaConstant.Simple.of(TypeDescription.ForLoadedType.of((Class)value2));
            }
            if (value2 instanceof Enum) {
                return new Simple(FieldAccess.forEnumeration(new EnumerationDescription.ForLoadedEnumeration((Enum)value2)), TypeDescription.ForLoadedType.of(((Enum)value2).getDeclaringClass()));
            }
            return JavaConstant.Simple.ofLoadedOrNull(value2);
        }

        public TypeDescription getTypeDescription() {
            return this.typeDescription;
        }

        public StackManipulation toStackManipulation() {
            return this.stackManipulation;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.stackManipulation.equals(((Simple)object).stackManipulation)) {
                return false;
            }
            return this.typeDescription.equals(((Simple)object).typeDescription);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.stackManipulation.hashCode()) * 31 + this.typeDescription.hashCode();
        }
    }
}

