/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolving;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class OCSymbolReferenceResolveTestCase
extends OCCodeInsightTestCase {
    protected void checkReferences(OCFile file, OCSymbolReference reference, String ... expected) {
        List symbols = reference.resolveToSymbols(false, false, true, OCResolveContext.forPsi((PsiElement)file.getLastChild()));
        LinkedHashSet set = new LinkedHashSet(symbols);
        symbols.forEach(s -> {
            OCSymbol definitionSymbol;
            if (s instanceof OCFunctionSymbol && (definitionSymbol = s.getDefinitionSymbol(this.getProject())) != null) {
                set.add(definitionSymbol);
            }
        });
        Set texts = ContainerUtil.map2SetNotNull(set, symbol -> {
            PsiElement element = symbol.locateDefinition(this.getProject());
            if (element instanceof OCDeclarator) {
                element = element.getParent();
            }
            return element != null ? element.getText() : null;
        });
        if (expected.length != texts.size()) {
            this.fail(texts, expected);
        }
        for (String anExpected : expected) {
            if (texts.contains(anExpected)) continue;
            this.fail(texts, expected);
        }
    }

    protected void fail(Set<String> symbols, String[] expected) {
        StringBuilder expectedMessage = new StringBuilder();
        for (String expect : expected) {
            expectedMessage.append("'" + expect + "', ");
        }
        StringBuilder foundMessage = new StringBuilder();
        for (String found : symbols) {
            foundMessage.append("'" + found + "', ");
        }
        OCSymbolReferenceResolveTestCase.fail((String)("Expected: " + String.valueOf(expectedMessage) + "\n Actual: " + String.valueOf(foundMessage)));
    }
}

