/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class CidrFileBasedChangeTestFixture<T> {
    @NotNull
    private final CidrCodeInsightFixture myCodeInsightFixture;
    @NotNull
    private final Project myProject;
    protected final String myAssertionBlockPrefix;
    private final Pattern myExpectationBlockStart;
    private final Pattern myExpectationBlockEnd;
    private final Pattern myAssertionStart;
    private static final Map<String, Boolean> REQUIREMENTS_MAP;

    public CidrFileBasedChangeTestFixture(@NotNull CidrCodeInsightFixture codeInsightFixture, @NotNull CidrProjectFixture projectFixture2, @NotNull String assertionBlockPrefix) {
        if (codeInsightFixture == null) {
            CidrFileBasedChangeTestFixture.$$$reportNull$$$0(0);
        }
        if (projectFixture2 == null) {
            CidrFileBasedChangeTestFixture.$$$reportNull$$$0(1);
        }
        if (assertionBlockPrefix == null) {
            CidrFileBasedChangeTestFixture.$$$reportNull$$$0(2);
        }
        this.myCodeInsightFixture = codeInsightFixture;
        this.myProject = projectFixture2.getProject();
        this.myAssertionBlockPrefix = assertionBlockPrefix;
        this.myExpectationBlockStart = Pattern.compile(Pattern.quote(this.myAssertionBlockPrefix) + ">>");
        this.myExpectationBlockEnd = Pattern.compile(Pattern.quote(assertionBlockPrefix) + "<<");
        this.myAssertionStart = Pattern.compile("\n" + Pattern.quote(assertionBlockPrefix) + "(.*)");
    }

    public void doTest(String fileName) throws Exception {
        String fileText = this.myCodeInsightFixture.loadFile(fileName);
        List<ExpectationBlock<T>> expectationBlocks = this.readExpectationBlocks(fileText);
        for (int i2 = 0; i2 < expectationBlocks.size(); ++i2) {
            this.assertBlock(fileName, fileText, expectationBlocks, i2);
        }
    }

    protected String textForBlock(String sourceText, List<ExpectationBlock<T>> blocks, int blockIndex, String replacementText) {
        for (int i2 = blocks.size() - 1; i2 >= 0; --i2) {
            String replacement = i2 == blockIndex ? replacementText : "";
            sourceText = StringUtil.replaceSubstring((String)sourceText, (TextRange)blocks.get((int)i2).myRange, (String)replacement);
        }
        int eofIndex = sourceText.indexOf("<EOF>");
        if (eofIndex >= 0) {
            sourceText = sourceText.substring(0, eofIndex);
        }
        return sourceText;
    }

    private List<ExpectationBlock<T>> readExpectationBlocks(String fileText) {
        ExpectationBlock<T> block;
        int from = 0;
        ArrayList<ExpectationBlock<T>> result = new ArrayList<ExpectationBlock<T>>();
        while ((block = this.readExpectationBlock(fileText, from)) != null) {
            from = block.myRange.getEndOffset();
            result.add(block);
        }
        return result;
    }

    private ExpectationBlock<T> readExpectationBlock(String text, int from) {
        Matcher blockStartMatcher = this.myExpectationBlockStart.matcher(text).region(from, text.length());
        Matcher blockEndMatcher = this.myExpectationBlockEnd.matcher(text).region(from, text.length());
        DocumentImpl doc = new DocumentImpl(text);
        if (!blockStartMatcher.find()) {
            return null;
        }
        Assert.assertTrue((boolean)blockEndMatcher.find());
        String comment = doc.getText(TextRange.create((int)from, (int)blockStartMatcher.start())).trim();
        int blockFirstLine = doc.getLineNumber(blockStartMatcher.start());
        int blockStart = doc.getLineStartOffset(blockFirstLine);
        int blockEnd = doc.getLineNumber(blockEndMatcher.end()) + 1 < doc.getLineCount() ? doc.getLineStartOffset(doc.getLineNumber(blockEndMatcher.end()) + 1) : doc.getLineStartOffset(doc.getLineNumber(blockEndMatcher.end()));
        TextRange blockRange = new TextRange(blockStart, blockEnd);
        Assert.assertTrue((blockRange.getStartOffset() < blockRange.getEndOffset() ? 1 : 0) != 0);
        String header = doc.getText(TextRange.create((int)blockStartMatcher.end(), (int)doc.getLineEndOffset(blockFirstLine)));
        List requirements = ContainerUtil.mapNotNull((Object[])header.split("\\s"), it -> StringUtil.nullize((String)StringUtil.trim((String)it)));
        int baseTextLine = blockFirstLine + 1;
        Pair<Integer, List<ResultVariant<T>>> assertionsInfo = this.readAssertions(text, new TextRange(doc.getLineStartOffset(baseTextLine), blockEndMatcher.start()));
        int baseStart = doc.getLineStartOffset(baseTextLine);
        int baseEnd = (Integer)assertionsInfo.first;
        return new ExpectationBlock(comment, blockRange, baseTextLine, doc.getText(new TextRange(baseStart, baseEnd)), requirements, (Collection)assertionsInfo.second);
    }

    private Pair<Integer, List<ResultVariant<T>>> readAssertions(String assertionsText, TextRange scanRange) {
        Matcher startMatcher = this.myAssertionStart.matcher(assertionsText).region(scanRange.getStartOffset(), scanRange.getEndOffset());
        ArrayList<Pair> entries = new ArrayList<Pair>();
        while (startMatcher.find()) {
            String assertionContents = startMatcher.group(1);
            T data = this.readAssertionData(assertionContents);
            entries.add(Pair.create(data, (Object)(startMatcher.start() + 1)));
        }
        Assert.assertTrue((!entries.isEmpty() ? 1 : 0) != 0);
        DocumentImpl doc = new DocumentImpl(assertionsText);
        Assert.assertNotNull((Object)doc);
        int blockStart = doc.getLineStartOffset(doc.getLineNumber(((Integer)((Pair)entries.get((int)0)).second).intValue()));
        HashMap<Object, ResultVariant<Object>> variantMap = new HashMap<Object, ResultVariant<Object>>();
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            Pair start = (Pair)entries.get(i2);
            int endOffset = i2 == entries.size() - 1 ? scanRange.getEndOffset() : ((Integer)((Pair)entries.get((int)(i2 + 1))).second).intValue();
            Object data = start.first;
            Assert.assertNotNull((Object)data);
            Assert.assertNotNull((Object)start.second);
            int startLine = doc.getLineNumber(((Integer)start.second).intValue()) + 1;
            int variantStart = doc.getLineStartOffset(startLine);
            int variantEnd = doc.getLineStartOffset(doc.getLineNumber(endOffset));
            String variantText = doc.getText(new TextRange(variantStart, variantEnd)).replace(this.myAssertionBlockPrefix + "\n", "\n");
            Assert.assertFalse((String)("duplicate test: " + String.valueOf(data)), (boolean)variantMap.containsKey(data));
            variantMap.put(data, new ResultVariant<Object>(startLine, data, variantText));
        }
        ArrayList variants = new ArrayList(variantMap.values());
        variants.sort(Comparator.comparingInt(o -> o.myLine));
        return Pair.create((Object)blockStart, variants);
    }

    protected void assertBlock(String fileName, String fileText, List<ExpectationBlock<T>> expectationBlocks, int blockIndex) {
        ExpectationBlock<T> block = expectationBlocks.get(blockIndex);
        for (String eachRequirement : block.myRequirements) {
            boolean not = eachRequirement.startsWith("!");
            String key = StringUtil.trimLeading((String)eachRequirement, (char)'!');
            Boolean value2 = REQUIREMENTS_MAP.get(key);
            if (value2 == null) {
                Assert.fail((String)("Unknown test requirement " + key + " in block: " + blockIndex + " source line " + (block.myBaseTextLine + 1)));
            }
            if (value2 != not) continue;
            System.out.println("Skipping test block " + blockIndex + " requiring " + StringUtil.join(block.myRequirements, (String)" "));
            return;
        }
        String beforeText = this.textForBlock(fileText, expectationBlocks, blockIndex, block.myBaseText);
        for (ResultVariant variant : block.myVariants) {
            Object data = variant.myData;
            String errorPrefix = "\nTest block: " + blockIndex + " " + (String)(!StringUtil.isEmptyOrSpaces((String)block.myHeader) ? "\n" + block.myHeader : "") + "\nSource line " + (block.myBaseTextLine + 1) + ":\n\n" + block.myBaseText + "\nCompletion at line " + (variant.myLine + 1) + ": '" + data.toString() + "'\n\nError: ";
            this.myCodeInsightFixture.configureByText(beforeText, CidrFileBasedChangeTestFixture.getFileName(fileName));
            this.performInWriteAction(this.myCodeInsightFixture.getFixture(), data, errorPrefix);
            try {
                this.myCodeInsightFixture.checkResult(this.textForBlock(fileText, expectationBlocks, blockIndex, variant.myText));
            }
            catch (Error e) {
                System.err.println("\n" + errorPrefix);
                throw e;
            }
        }
    }

    @NotNull
    private static String getFileName(String fileName) {
        String string = "test." + FileUtilRt.getExtension((String)fileName);
        if (string == null) {
            CidrFileBasedChangeTestFixture.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setUp() {
        CommonCodeStyleSettings settings = this.myCodeInsightFixture.getOCCommonSettings();
        settings.KEEP_BLANK_LINES_IN_CODE = 1000;
        settings.KEEP_BLANK_LINES_BEFORE_RBRACE = 1000;
    }

    public void tearDown() throws Exception {
    }

    public CodeInsightSettings getCodeInsightSettings() {
        return CodeInsightSettings.getInstance();
    }

    protected abstract void performInWriteAction(CodeInsightTestFixture var1, T var2, String var3);

    @NotNull
    protected abstract T readAssertionData(String var1);

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CidrFileBasedChangeTestFixture.$$$reportNull$$$0(4);
        }
        return project;
    }

    static {
        Map map = CollectionFactory.createCaseInsensitiveStringMap();
        map.put("windows", SystemInfo.isWindows);
        map.put("unix", SystemInfo.isUnix);
        map.put("linux", SystemInfo.isLinux);
        map.put("mac", SystemInfo.isMac);
        REQUIREMENTS_MAP = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionBlockPrefix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CidrFileBasedChangeTestFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CidrFileBasedChangeTestFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class ExpectationBlock<T> {
        public final String myHeader;
        public final TextRange myRange;
        public final int myBaseTextLine;
        public final String myBaseText;
        public final List<String> myRequirements;
        public final Collection<ResultVariant<T>> myVariants;

        public ExpectationBlock(String comment, TextRange range, int baseTextLine, String baseText, List<String> requirements, Collection<ResultVariant<T>> variants) {
            this.myHeader = comment;
            this.myRange = range;
            this.myBaseTextLine = baseTextLine;
            this.myBaseText = baseText;
            this.myVariants = variants;
            this.myRequirements = requirements;
        }
    }

    public static class ResultVariant<T> {
        public final int myLine;
        public final T myData;
        public final String myText;

        public ResultVariant(int line, T data, String text) {
            this.myLine = line;
            this.myData = data;
            this.myText = text;
        }
    }
}

