/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XTestCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectMarkup;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggingTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, PROJECT_MARKUP extends CidrProjectMarkup>
extends CidrDebuggerTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, PROJECT_MARKUP> {
    public CidrDebuggingTestCase(DebuggerDriverKind backend, String targetName, String fixtureProjectFileRelativePath, String fixtureProjectRelativeFilesToCopyPath) {
        super(backend, targetName, new CidrTestProjectDescription(fixtureProjectFileRelativePath, fixtureProjectRelativeFilesToCopyPath));
    }

    public CidrDebuggingTestCase(DebuggerDriverKind backend, String targetName, String fixtureProjectFileRelativePath) {
        super(backend, targetName, new CidrTestProjectDescription(fixtureProjectFileRelativePath));
    }

    @Override
    protected Duration getCoroutineTimeout() {
        return Duration.ofMinutes(20L);
    }

    @Override
    protected void collectThreadsForInvestigation() throws Exception {
        XDebugSession session = this.getSession();
        if (session == null) {
            return;
        }
        BlockingQueue<CidrDebuggingFixture.DebuggerState> events = ((CidrDebuggingFixture)this.myDebuggingFixture).spyOnSessionEvents();
        if (session.isStopped()) {
            return;
        }
        if (!session.isSuspended()) {
            session.pause();
            CidrDebuggingFixture.DebuggerState state = CidrExecutionFixture.waitFor(events, 3000L);
            if (state == null || !CidrDebuggingFixture.isEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED)) {
                return;
            }
        }
        List<XExecutionStack> stacks = XDebuggerTestUtil.collectThreads(session, 3000);
        for (XExecutionStack stack : stacks) {
            XDebuggerTestUtil.collectFrames(stack, 3000L);
        }
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrDebuggingTestCase.$$$reportNull$$$0(0);
        }
        return symbolsKind;
    }

    @Override
    public void afterProjectOpened() throws Exception {
        super.afterProjectOpened();
        this.setDefaultSettings();
    }

    private void setDefaultSettings() {
        CidrDebuggerSettings.getInstance().setRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setCocoaRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setStlRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(true);
        CidrDebuggerSettings.getInstance().setHexFormattingEnabled(false);
        CidrDebuggerSettings.getInstance().setHexAsSecondaryFormattingEnabled(true);
        CidrDebuggerSettings.getInstance().setLLDBNatvisRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().getNtSymbolSettings().setUseNtSymbolServers(false);
        CidrDebuggerSettings.getInstance().setFollowChildOnFork(false);
        CidrDebuggerSettings.getInstance().setDetachOnFork(true);
        this.getProject().putUserData(CidrValue.DO_NOT_SHOW_ADDRESSES, (Object)true);
    }

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause() throws Exception {
        return this.startDebugSessionAndWaitForPause(null);
    }

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause(@Nullable String parameters) throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> stateQueue = ((CidrDebuggingFixture)this.myDebuggingFixture).startDebugSessionWithListener(parameters);
        CidrDebuggingFixture.waitForEvent(stateQueue, this.PAUSED, this.getStartupTimeout());
        XDebuggerTestUtil.waitForSwing();
        return stateQueue;
    }

    public long getStartupTimeout() {
        return 50000L;
    }

    protected CidrDebugProcess getDebugProcess() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getDebugProcess();
    }

    public XDebugSession getSession() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getSession();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myDebuggingFixture != null) {
                ((CidrDebuggingFixture)this.myDebuggingFixture).tearDown();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    public List<XValue> collectVars(int frame) {
        XStackFrame frame1 = XDebuggerTestUtil.getFrameAt(((CidrDebuggingFixture)this.myDebuggingFixture).getSession(), frame);
        return XDebuggerTestUtil.collectChildren((XValueContainer)frame1);
    }

    public List<XValue> collectVars(int frame, long timeout) {
        XStackFrame frame1 = XDebuggerTestUtil.getFrameAt(((CidrDebuggingFixture)this.myDebuggingFixture).getSession(), frame);
        return new XTestCompositeNode((XValueContainer)frame1).collectChildren(timeout);
    }

    protected long getCurrentThreadId() {
        return ((CidrDebuggingFixture)this.myDebuggingFixture).getDebugProcess().getCurrentThreadId();
    }

    public Pair<XValue, String> evaluate(String expression) {
        return XDebuggerTestUtil.evaluate(this.getSession(), expression, 25000L);
    }

    @Contract(value="!null, _, !null -> !null")
    @Nullable
    protected <TYPE> TYPE selectGdbVersion(@Nullable TYPE oldGdbValue, int gdbMajorVersion, @Nullable TYPE newGdbValue) {
        Version version;
        DebuggerDriver driver = this.getDebugProcess().getDriverInTests();
        if (driver instanceof GDBDriver) {
            GDBDriver gdbDriver = (GDBDriver)driver;
            version = gdbDriver.getGdbVersion();
        } else {
            version = null;
        }
        Version gdbVersion = version;
        int major = gdbVersion != null ? gdbVersion.major : 0;
        return major < gdbMajorVersion ? oldGdbValue : newGdbValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggingTestCase", "shouldBuildSymbolTables"));
    }
}

