/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrContextConfigurationProducerFixture;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationTestCase;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrTestFixtureDelegate;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import org.jetbrains.annotations.NotNull;

public abstract class CidrTargetRunConfigurationTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture, PRODUCER extends CidrContextRunConfigurationProducer<?, ?, ?>, DELEGATE extends CidrTestFixtureDelegate<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE> & CidrContextConfigurationProducerFixture<?, PRODUCER>>
extends CidrContextRunConfigurationTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE, PRODUCER, DELEGATE> {
    public static final String MAIN = "Main";
    public static final String WMAIN = "wMain";
    public static final String MACRO_MAIN = "MacroMain";
    public static final String CONFIG_DEBUG = "Debug";
    public static final String[] TEST_CONFIGURATIONS = new String[]{"Debug"};

    protected CidrTargetRunConfigurationTestCase(@NotNull DELEGATE delegate) {
        if (delegate == null) {
            CidrTargetRunConfigurationTestCase.$$$reportNull$$$0(0);
        }
        super(delegate);
    }

    public void testCreatingFromMainBody() {
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("Main.cpp", "fromMainBody"), MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolationWhileConfigurationCreation() {
        PsiElement element = this.myFrameworkFixture.getFindElement("Main.cpp", "fromMain");
        RunnerAndConfigurationSettings settings = this.createContextConfiguration(element);
        RunConfiguration fromMain = settings.getConfiguration();
        CidrTargetRunConfigurationTestCase.assertNotNull((Object)fromMain);
        CidrTargetRunConfigurationTestCase.assertInstanceOf(fromMain, CidrExecutableDataHolder.class);
        ExecutableData data = ((CidrExecutableDataHolder)fromMain).getExecutableData();
        CidrTargetRunConfigurationTestCase.assertNotNull((Object)data);
        RunManagerImpl.getInstanceImpl((Project)this.getProject()).addConfiguration(settings);
        try {
            this.myFrameworkFixture.createConfigurationForContext("wMain.cpp", "fromWMain");
            CidrTargetRunConfigurationTestCase.assertSame((Object)data, (Object)((CidrExecutableDataHolder)fromMain).getExecutableData());
        }
        finally {
            RunManagerImpl.getInstanceImpl((Project)this.getProject()).removeConfiguration(settings);
        }
    }

    public void testCreatingFromMainSignature() {
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("Main.cpp", "fromMain"), MAIN);
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("wMain.cpp", "fromWMain"), WMAIN);
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("MacroMain.cpp", "fromMacroTMain"), MACRO_MAIN);
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("MacroMain.cpp", "fromMacroTMain"), MACRO_MAIN);
    }

    public void testCreatingFromMainSignatureInHeader() {
        CidrTargetRunConfigurationTestCase.assertTargetForRunConfiguration(this.myFrameworkFixture.createConfigurationForContext("MainInHeader.h", "fromWinMainInHeader"), MAIN);
    }

    public void testNoExeTargetNoRunForMain() {
        this.myFrameworkFixture.assertNoConfigurationForContext("NotInProject.cpp", "fromMain");
    }

    public void testReusingExistingConfiguration() {
        PsiElement testContext = this.myFrameworkFixture.getFindElement("Main.cpp", "fromMain");
        CidrTargetRunConfigurationTestCase.assertNotNull((Object)testContext);
        this.assertReusingExistingConfiguration(testContext);
    }

    public void testBadMainLikeSymbolsWithoutContextRun() {
        this.myFrameworkFixture.assertNoConfigurationForContext("Main.cpp", "fromForward");
        this.myFrameworkFixture.assertNoConfigurationForContext("Main.cpp", "fromCtor");
        this.myFrameworkFixture.assertNoConfigurationForContext("Main.cpp", "fromMethod");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/cidr/execution/CidrTargetRunConfigurationTestCase", "<init>"));
    }
}

