/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.CustomAccessibilityAction;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.test.Actions_desktopKt;
import androidx.compose.ui.test.Actions_skikoKt;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.FiltersKt;
import androidx.compose.ui.test.GestureScope;
import androidx.compose.ui.test.KeyInjectionScope;
import androidx.compose.ui.test.MouseInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScopeImpl;
import androidx.compose.ui.test.RotaryInjectionScope;
import androidx.compose.ui.test.SelectorsKt;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.SemanticsNodeInteractionCollection;
import androidx.compose.ui.test.TestOwner;
import androidx.compose.ui.test.TouchInjectionScope;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0005*\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u0005*\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002\u001a%\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001cH\u0007\u001a#\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001c\u001a#\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001c\u001a%\u0010!\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001cH\u0007\u001a#\u0010#\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001c\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0001\u001aI\u0010&\u001a\u00020\f\"\u000e\b\u0000\u0010'*\b\u0012\u0004\u0012\u00020\u00040(*\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0*0)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\f0\u001aH\u0007\u00a2\u0006\u0002\b,\u001aB\u0010,\u001a\u00020\u0001\"\u000e\b\u0000\u0010'*\b\u0012\u0004\u0012\u00020\u00040(*\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0*0)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\f0\u001a\u001a+\u0010&\u001a\u00020\f*\u00020\u00012\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040-0*0)H\u0007\u00a2\u0006\u0002\b,\u001a$\u0010,\u001a\u00020\u0001*\u00020\u00012\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040-0*0)\u001a%\u0010.\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\f0\u001a\u00a2\u0006\u0002\b\u001cH\u0007\u001a\u0014\u00100\u001a\u00020\u0001*\u00020\u00012\u0006\u00101\u001a\u000202H\u0007\u001a;\u00103\u001a\u00020\u0001*\u00020\u00012\n\b\u0002\u00104\u001a\u0004\u0018\u0001022!\u00105\u001a\u001d\u0012\u0013\u0012\u001102\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u00040\u001aH\u0007\u001a&\u00108\u001a\u00020\u0001*\u00020\u00012\u001a\b\u0002\u00109\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:\u0012\u0004\u0012\u00020\u00040\u001a\u001a\n\u0010<\u001a\u00020=*\u00020=\u001a\f\u0010>\u001a\u00020\u0004*\u00020\u0005H\u0002\u001aC\u0010M\u001a\u00020\f*\u00020\u00012\u0006\u0010N\u001a\u00020\u00052\u001a\u0010O\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030)0P\"\u0006\u0012\u0002\b\u00030)2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002020-H\u0002\u00a2\u0006\u0002\u0010R\"\u0018\u0010?\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\"\u001a\u0010A\u001a\u0004\u0018\u00010B*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\"\u001a\u0010E\u001a\u0004\u0018\u00010B*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010D\"\u0018\u0010G\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010@\"\u0018\u0010H\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010@\"\u001a\u0010I\u001a\u00020\u0004*\u0004\u0018\u00010B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\"\u001a\u0010K\u001a\u00020\u0004*\u0004\u0018\u00010B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010J\"\u0018\u0010L\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010@\u00a8\u0006S"}, d2={"performClick", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "performScrollTo", "scrollToNode", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "testOwner", "Landroidx/compose/ui/test/TestOwner;", "performScrollToIndex", "index", "", "scrollToIndex", "", "nodeInteraction", "performScrollToKey", "key", "", "performScrollToNode", "matcher", "Landroidx/compose/ui/test/SemanticsMatcher;", "scrollToMatchingDescendantOrReturnScrollable", "matchDescendant", "root", "matchNodeOrDescendant", "performGesture", "block", "Lkotlin/Function1;", "Landroidx/compose/ui/test/GestureScope;", "Lkotlin/ExtensionFunctionType;", "performTouchInput", "Landroidx/compose/ui/test/TouchInjectionScope;", "performMouseInput", "Landroidx/compose/ui/test/MouseInjectionScope;", "performKeyInput", "Landroidx/compose/ui/test/KeyInjectionScope;", "performMultiModalInput", "Landroidx/compose/ui/test/MultiModalInjectionScope;", "requestFocus", "performSemanticsActionUnit", "T", "Lkotlin/Function;", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "Landroidx/compose/ui/semantics/AccessibilityAction;", "invocation", "performSemanticsAction", "Lkotlin/Function0;", "performRotaryScrollInput", "Landroidx/compose/ui/test/RotaryInjectionScope;", "performCustomAccessibilityActionWithLabel", "label", "", "performCustomAccessibilityActionWithLabelMatching", "predicateDescription", "labelPredicate", "Lkotlin/ParameterName;", "name", "performFirstLinkClick", "predicate", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/LinkAnnotation;", "tryPerformAccessibilityChecks", "Landroidx/compose/ui/test/SemanticsNodeInteractionCollection;", "isLink", "isLazyList", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "horizontalScrollAxis", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScrollAxis", "(Landroidx/compose/ui/semantics/SemanticsNode;)Landroidx/compose/ui/semantics/ScrollAxisRange;", "verticalScrollAxis", "getVerticalScrollAxis", "isReversedHorizontally", "isReversedVertically", "isAtStart", "(Landroidx/compose/ui/semantics/ScrollAxisRange;)Z", "isAtEnd", "isRtl", "requireSemantics", "node", "properties", "", "errorMessage", "(Landroidx/compose/ui/test/SemanticsNodeInteraction;Landroidx/compose/ui/semantics/SemanticsNode;[Landroidx/compose/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)V", "ui-test"})
@SourceDebugExtension(value={"SMAP\nActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Actions.kt\nandroidx/compose/ui/test/ActionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,807:1\n1#2:808\n57#3:809\n61#3:812\n60#4:810\n70#4:813\n22#5:811\n22#5:814\n1869#6,2:815\n1869#6,2:817\n774#6:819\n865#6,2:820\n360#6,7:840\n530#7,2:822\n35#7,3:824\n532#7,3:827\n39#7:830\n535#7:831\n231#7,2:832\n35#7,5:834\n233#7:839\n3829#8:847\n4344#8,2:848\n*S KotlinDebug\n*F\n+ 1 Actions.kt\nandroidx/compose/ui/test/ActionsKt\n*L\n261#1:809\n262#1:812\n261#1:810\n262#1:813\n261#1:811\n262#1:814\n290#1:815,2\n300#1:817,2\n686#1:819\n686#1:820,2\n731#1:840,7\n729#1:822,2\n729#1:824,3\n729#1:827,3\n729#1:830\n729#1:831\n730#1:832,2\n730#1:834,5\n730#1:839\n798#1:847\n798#1:848,2\n*E\n"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction performClick(@NotNull SemanticsNodeInteraction $this$performClick) {
        Intrinsics.checkNotNullParameter((Object)$this$performClick, (String)"<this>");
        return Actions_desktopKt.performClickImpl($this$performClick);
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollTo(@NotNull SemanticsNodeInteraction $this$performScrollTo) {
        boolean shouldContinueScroll;
        Intrinsics.checkNotNullParameter((Object)$this$performScrollTo, (String)"<this>");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performScrollTo);
        while (shouldContinueScroll = ActionsKt.scrollToNode($this$performScrollTo.fetchSemanticsNode("Action performScrollTo() failed."), $this$performScrollTo.getTestContext$ui_test().getTestOwner$ui_test())) {
        }
        return $this$performScrollTo;
    }

    private static final boolean scrollToNode(SemanticsNode $this$scrollToNode, TestOwner testOwner) {
        SemanticsNode semanticsNode = UtilsKt.findClosestParentNode$default($this$scrollToNode, false, ActionsKt::scrollToNode$lambda$0, 1, null);
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableNode = semanticsNode;
        Rect viewportInParent = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)scrollableNode.getLayoutInfo().getCoordinates());
        LayoutCoordinates layoutCoordinates = scrollableNode.getLayoutInfo().getCoordinates().getParentLayoutCoordinates();
        long parentInRoot = layoutCoordinates != null ? LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)layoutCoordinates) : Offset.Companion.getZero-F1C5BW0();
        Rect viewport = viewportInParent.translate-k-4lQ0M(parentInRoot);
        Rect target = RectKt.Rect-tz77jQw((long)$this$scrollToNode.getPositionInRoot-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)$this$scrollToNode.getSize-YbymL2g()));
        Ref.FloatRef dx = new Ref.FloatRef();
        dx.element = ActionsKt.scrollToNode$scrollDelta(target.getLeft() - viewport.getLeft(), target.getRight() - viewport.getRight());
        if (ActionsKt.isReversedHorizontally(scrollableNode)) {
            dx.element = -dx.element;
        }
        if (ActionsKt.isRtl(scrollableNode)) {
            dx.element = -dx.element;
        }
        Ref.FloatRef dy = new Ref.FloatRef();
        dy.element = ActionsKt.scrollToNode$scrollDelta(target.getTop() - viewport.getTop(), target.getBottom() - viewport.getBottom());
        if (ActionsKt.isReversedVertically(scrollableNode)) {
            dy.element = -dy.element;
        }
        if (!(dx.element == 0.0f) && ActionsKt.getHorizontalScrollAxis(scrollableNode) != null || !(dy.element == 0.0f) && ActionsKt.getVerticalScrollAxis(scrollableNode) != null) {
            testOwner.runOnUiThread(() -> ActionsKt.scrollToNode$lambda$1(scrollableNode, dx, dy));
            return true;
        }
        return false;
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToIndex(@NotNull SemanticsNodeInteraction $this$performScrollToIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToIndex, (String)"<this>");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performScrollToIndex);
        ActionsKt.scrollToIndex($this$performScrollToIndex.fetchSemanticsNode("Failed: performScrollToIndex(" + index + ")"), index, $this$performScrollToIndex);
        return $this$performScrollToIndex;
    }

    private static final void scrollToIndex(SemanticsNode $this$scrollToIndex, int index, SemanticsNodeInteraction nodeInteraction) {
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics(nodeInteraction, $this$scrollToIndex, semanticsPropertyKeyArray, (Function0<String>)((Function0)() -> ActionsKt.scrollToIndex$lambda$2(index)));
        nodeInteraction.getTestContext$ui_test().getTestOwner$ui_test().runOnUiThread(() -> ActionsKt.scrollToIndex$lambda$3($this$scrollToIndex, index));
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToKey(@NotNull SemanticsNodeInteraction $this$performScrollToKey, @NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performScrollToKey);
        SemanticsNode node = $this$performScrollToKey.fetchSemanticsNode("Failed: performScrollToKey(\"" + key + "\")");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsProperties.INSTANCE.getIndexForKey(), SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics($this$performScrollToKey, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)() -> ActionsKt.performScrollToKey$lambda$4(key)));
        int index = ((Number)((Function1)node.getConfig().get(SemanticsProperties.INSTANCE.getIndexForKey())).invoke(key)).intValue();
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Failed to scroll to the item identified by \"" + key + "\", couldn't find the key.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$performScrollToKey.getTestContext$ui_test().getTestOwner$ui_test().runOnUiThread(() -> ActionsKt.performScrollToKey$lambda$6(node, index));
        return $this$performScrollToKey;
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToNode(@NotNull SemanticsNodeInteraction $this$performScrollToNode, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$performScrollToNode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performScrollToNode);
        SemanticsNode semanticsNode = ActionsKt.scrollToMatchingDescendantOrReturnScrollable($this$performScrollToNode, matcher);
        if (semanticsNode == null) {
            return $this$performScrollToNode;
        }
        SemanticsNode node = semanticsNode;
        if (!ActionsKt.isLazyList(node)) {
            String msg = "No node found that matches " + matcher.getDescription() + " in scrollable container";
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$performScrollToNode.getSelector$ui_test(), node));
        }
        if (!ActionsKt.isAtStart(ActionsKt.getHorizontalScrollAxis(node)) || !ActionsKt.isAtStart(ActionsKt.getVerticalScrollAxis(node))) {
            ActionsKt.scrollToIndex(node, 0, $this$performScrollToNode);
        }
        while (ActionsKt.scrollToMatchingDescendantOrReturnScrollable($this$performScrollToNode, matcher) != null) {
            float f;
            float dx;
            float f2;
            SemanticsNode newNode;
            if (ActionsKt.isAtEnd(ActionsKt.getHorizontalScrollAxis(newNode)) && ActionsKt.isAtEnd(ActionsKt.getVerticalScrollAxis(newNode))) {
                String msg = "No node found that matches " + matcher.getDescription() + " in scrollable container";
                throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$performScrollToNode.getSelector$ui_test(), newNode));
            }
            long viewPortSize = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)newNode.getLayoutInfo().getCoordinates()).getSize-NH-jbRc();
            if (ActionsKt.getHorizontalScrollAxis(newNode) != null) {
                boolean bl = false;
                boolean bl2 = false;
                long value$iv$iv = viewPortSize;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                f2 = Float.intBitsToFloat(bits$iv$iv$iv);
            } else {
                f2 = dx = 0.0f;
            }
            if (ActionsKt.getVerticalScrollAxis(newNode) != null) {
                boolean bl = false;
                boolean bl3 = false;
                long value$iv$iv = viewPortSize;
                boolean $i$f$unpackFloat2 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                boolean $i$f$floatFromBits = false;
                f = Float.intBitsToFloat(bits$iv$iv$iv);
            } else {
                f = 0.0f;
            }
            float dy = f;
            $this$performScrollToNode.getTestContext$ui_test().getTestOwner$ui_test().runOnUiThread(() -> ActionsKt.performScrollToNode$lambda$9(newNode, dx, dy));
        }
        return $this$performScrollToNode;
    }

    private static final SemanticsNode scrollToMatchingDescendantOrReturnScrollable(SemanticsNodeInteraction $this$scrollToMatchingDescendantOrReturnScrollable, SemanticsMatcher matcher) {
        SemanticsNode node = $this$scrollToMatchingDescendantOrReturnScrollable.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ")");
        SemanticsNode matchedNode = ActionsKt.matchDescendant(matcher, node);
        while (matchedNode != null) {
            boolean shouldContinueScroll = ActionsKt.scrollToNode(matchedNode, $this$scrollToMatchingDescendantOrReturnScrollable.getTestContext$ui_test().getTestOwner$ui_test());
            if (!shouldContinueScroll) {
                return null;
            }
            node = $this$scrollToMatchingDescendantOrReturnScrollable.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ")");
            matchedNode = ActionsKt.matchDescendant(matcher, node);
        }
        return node;
    }

    private static final SemanticsNode matchDescendant(SemanticsMatcher $this$matchDescendant, SemanticsNode root) {
        Iterable $this$forEach$iv = root.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode matchedNode;
            SemanticsNode child = (SemanticsNode)element$iv;
            boolean bl = false;
            SemanticsNode semanticsNode = matchedNode = ActionsKt.matchNodeOrDescendant($this$matchDescendant, child);
            if (semanticsNode == null) continue;
            return semanticsNode;
        }
        return null;
    }

    private static final SemanticsNode matchNodeOrDescendant(SemanticsMatcher $this$matchNodeOrDescendant, SemanticsNode root) {
        if (root == null || !root.getLayoutInfo().isPlaced()) {
            return null;
        }
        if ($this$matchNodeOrDescendant.matches(root)) {
            return root;
        }
        Iterable $this$forEach$iv = root.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode matchedNode;
            SemanticsNode child = (SemanticsNode)element$iv;
            boolean bl = false;
            SemanticsNode semanticsNode = matchedNode = ActionsKt.matchNodeOrDescendant($this$matchNodeOrDescendant, child);
            if (semanticsNode == null) continue;
            return semanticsNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Replaced by performTouchInput", replaceWith=@ReplaceWith(expression="performTouchInput(block)", imports={"import androidx.compose.ui.test.performGesture"}))
    @NotNull
    public static final SemanticsNodeInteraction performGesture(@NotNull SemanticsNodeInteraction $this$performGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performGesture.fetchSemanticsNode("Failed to perform a gesture.");
        GestureScope $this$performGesture_u24lambda_u2412 = new GestureScope(node, $this$performGesture.getTestContext$ui_test());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performGesture_u24lambda_u2412);
        }
        finally {
            $this$performGesture_u24lambda_u2412.dispose$ui_test();
        }
        return $this$performGesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performTouchInput(@NotNull SemanticsNodeInteraction $this$performTouchInput, @NotNull Function1<? super TouchInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performTouchInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performTouchInput);
        SemanticsNode node = $this$performTouchInput.fetchSemanticsNode("Failed to inject touch input.");
        MultiModalInjectionScopeImpl $this$performTouchInput_u24lambda_u2413 = new MultiModalInjectionScopeImpl(node, $this$performTouchInput.getTestContext$ui_test());
        boolean bl = false;
        try {
            $this$performTouchInput_u24lambda_u2413.touch(block);
        }
        finally {
            $this$performTouchInput_u24lambda_u2413.dispose$ui_test();
        }
        return $this$performTouchInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performMouseInput(@NotNull SemanticsNodeInteraction $this$performMouseInput, @NotNull Function1<? super MouseInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performMouseInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performMouseInput);
        SemanticsNode node = $this$performMouseInput.fetchSemanticsNode("Failed to inject mouse input.");
        MultiModalInjectionScopeImpl $this$performMouseInput_u24lambda_u2414 = new MultiModalInjectionScopeImpl(node, $this$performMouseInput.getTestContext$ui_test());
        boolean bl = false;
        try {
            $this$performMouseInput_u24lambda_u2414.mouse(block);
        }
        finally {
            $this$performMouseInput_u24lambda_u2414.dispose$ui_test();
        }
        return $this$performMouseInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performKeyInput(@NotNull SemanticsNodeInteraction $this$performKeyInput, @NotNull Function1<? super KeyInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performKeyInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performKeyInput);
        SemanticsNode node = $this$performKeyInput.fetchSemanticsNode("Failed to inject key input.");
        MultiModalInjectionScopeImpl $this$performKeyInput_u24lambda_u2415 = new MultiModalInjectionScopeImpl(node, $this$performKeyInput.getTestContext$ui_test());
        boolean bl = false;
        try {
            $this$performKeyInput_u24lambda_u2415.key(block);
        }
        finally {
            $this$performKeyInput_u24lambda_u2415.dispose$ui_test();
        }
        return $this$performKeyInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performMultiModalInput(@NotNull SemanticsNodeInteraction $this$performMultiModalInput, @NotNull Function1<? super MultiModalInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performMultiModalInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performMultiModalInput.fetchSemanticsNode("Failed to inject multi-modal input.");
        MultiModalInjectionScopeImpl $this$performMultiModalInput_u24lambda_u2416 = new MultiModalInjectionScopeImpl(node, $this$performMultiModalInput.getTestContext$ui_test());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performMultiModalInput_u24lambda_u2416);
        }
        finally {
            $this$performMultiModalInput_u24lambda_u2416.dispose$ui_test();
        }
        return $this$performMultiModalInput;
    }

    @NotNull
    public static final SemanticsNodeInteraction requestFocus(@NotNull SemanticsNodeInteraction $this$requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$requestFocus, (String)"<this>");
        return ActionsKt.performSemanticsAction($this$requestFocus, (SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>)SemanticsActions.INSTANCE.getRequestFocus());
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key, Function1 invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsActionUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, key, invocation);
    }

    @NotNull
    public static final <T extends Function<? extends Boolean>> SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        SemanticsNode node = $this$performSemanticsAction.fetchSemanticsNode("Failed to perform " + key.getName() + " action.");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{key};
        ActionsKt.requireSemantics($this$performSemanticsAction, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)() -> ActionsKt.performSemanticsAction$lambda$17(key)));
        $this$performSemanticsAction.getTestContext$ui_test().getTestOwner$ui_test().runOnUiThread(() -> ActionsKt.performSemanticsAction$lambda$18(node, key, invocation));
        return $this$performSemanticsAction;
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsActionUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, (SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>)key);
    }

    @NotNull
    public static final SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return ActionsKt.performSemanticsAction($this$performSemanticsAction, key, ActionsKt::performSemanticsAction$lambda$19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performRotaryScrollInput(@NotNull SemanticsNodeInteraction $this$performRotaryScrollInput, @NotNull Function1<? super RotaryInjectionScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performRotaryScrollInput, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Actions_skikoKt.tryPerformAccessibilityChecks($this$performRotaryScrollInput);
        SemanticsNode node = $this$performRotaryScrollInput.fetchSemanticsNode("Failed to send rotary Event");
        MultiModalInjectionScopeImpl $this$performRotaryScrollInput_u24lambda_u2420 = new MultiModalInjectionScopeImpl(node, $this$performRotaryScrollInput.getTestContext$ui_test());
        boolean bl = false;
        try {
            $this$performRotaryScrollInput_u24lambda_u2420.rotary(block);
        }
        finally {
            $this$performRotaryScrollInput_u24lambda_u2420.dispose$ui_test();
        }
        return $this$performRotaryScrollInput;
    }

    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performCustomAccessibilityActionWithLabel(@NotNull SemanticsNodeInteraction $this$performCustomAccessibilityActionWithLabel, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)$this$performCustomAccessibilityActionWithLabel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return ActionsKt.performCustomAccessibilityActionWithLabelMatching($this$performCustomAccessibilityActionWithLabel, "label is \"" + label + "\"", (Function1<? super String, Boolean>)((Function1)arg_0 -> ActionsKt.performCustomAccessibilityActionWithLabel$lambda$21(label, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performCustomAccessibilityActionWithLabelMatching(@NotNull SemanticsNodeInteraction $this$performCustomAccessibilityActionWithLabelMatching, @Nullable String predicateDescription, @NotNull Function1<? super String, Boolean> labelPredicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$performCustomAccessibilityActionWithLabelMatching, (String)"<this>");
        Intrinsics.checkNotNullParameter(labelPredicate, (String)"labelPredicate");
        SemanticsNode node = SemanticsNodeInteraction.fetchSemanticsNode$default($this$performCustomAccessibilityActionWithLabelMatching, null, 1, null);
        List actions = (List)node.getConfig().get(SemanticsActions.INSTANCE.getCustomActions());
        Iterable $this$filter$iv = actions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CustomAccessibilityAction it = (CustomAccessibilityAction)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)labelPredicate.invoke((Object)it.getLabel())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingActions = (List)destination$iv$iv;
        if (matchingActions.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("No custom accessibility actions matched [" + predicateDescription + "].", $this$performCustomAccessibilityActionWithLabelMatching.getSelector$ui_test(), node));
        }
        if (matchingActions.size() > 1) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Expected exactly one custom accessibility action to match [" + predicateDescription + "], but found " + matchingActions.size() + ".", $this$performCustomAccessibilityActionWithLabelMatching.getSelector$ui_test(), node));
        }
        ((CustomAccessibilityAction)matchingActions.get(0)).getAction().invoke();
        return $this$performCustomAccessibilityActionWithLabelMatching;
    }

    public static /* synthetic */ SemanticsNodeInteraction performCustomAccessibilityActionWithLabelMatching$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ActionsKt.performCustomAccessibilityActionWithLabelMatching(semanticsNodeInteraction, string, (Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public static final SemanticsNodeInteraction performFirstLinkClick(@NotNull SemanticsNodeInteraction $this$performFirstLinkClick, @NotNull Function1<? super AnnotatedString.Range<LinkAnnotation>, Boolean> predicate) {
        int matchedLinkIndex;
        List linkChildren;
        String errorMessage;
        block8: {
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$performFirstLinkClick, (String)"<this>");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Actions_skikoKt.tryPerformAccessibilityChecks($this$performFirstLinkClick);
            errorMessage = "Failed to click the link.";
            SemanticsNode node = $this$performFirstLinkClick.fetchSemanticsNode(errorMessage);
            List texts = (List)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getText());
            Collection collection = texts;
            if (collection == null || collection.isEmpty()) {
                throw new AssertionError((Object)(errorMessage + "\n Reason: No text found on node."));
            }
            List $this$fastFlatMap$iv = texts;
            boolean $i$f$fastFlatMap = false;
            ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
            List $this$fastForEach$iv$iv = $this$fastFlatMap$iv;
            boolean $i$f$fastForEach = false;
            int n2 = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                Object item$iv$iv;
                Object e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                AnnotatedString text = (AnnotatedString)e$iv;
                boolean bl2 = false;
                Iterable list$iv = text.getLinkAnnotations(0, text.length());
                CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
            }
            List linksInTexts = target$iv;
            List $this$fastFilter$iv = node.getChildren();
            boolean $i$f$fastFilter = false;
            ArrayList target$iv2 = new ArrayList($this$fastFilter$iv.size());
            List $this$fastForEach$iv$iv2 = $this$fastFilter$iv;
            boolean $i$f$fastForEach2 = false;
            int n3 = ((Collection)$this$fastForEach$iv$iv2).size();
            for (int index$iv$iv = 0; index$iv$iv < n3; ++index$iv$iv) {
                Object item$iv$iv;
                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv2.get(index$iv$iv);
                boolean bl = false;
                SemanticsNode it = (SemanticsNode)it$iv;
                boolean bl3 = false;
                if (!ActionsKt.isLink(it)) continue;
                ((Collection)target$iv2).add(it$iv);
            }
            linkChildren = target$iv2;
            List $this$indexOfFirst$iv = linksInTexts;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (((Boolean)predicate.invoke(item$iv)).booleanValue()) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = matchedLinkIndex = -1;
        }
        if (matchedLinkIndex != -1) {
            AccessibilityAction accessibilityAction = (AccessibilityAction)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)((SemanticsNode)linkChildren.get(matchedLinkIndex)).getConfig(), (SemanticsPropertyKey)SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null && (accessibilityAction = (Function0)accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke();
            }
        } else {
            throw new AssertionError((Object)(errorMessage + "\n Reason: No link found that matches the predicate."));
        }
        return $this$performFirstLinkClick;
    }

    public static /* synthetic */ SemanticsNodeInteraction performFirstLinkClick$default(SemanticsNodeInteraction semanticsNodeInteraction, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = ActionsKt::performFirstLinkClick$lambda$23;
        }
        return ActionsKt.performFirstLinkClick(semanticsNodeInteraction, (Function1<? super AnnotatedString.Range<LinkAnnotation>, Boolean>)function1);
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection tryPerformAccessibilityChecks(@NotNull SemanticsNodeInteractionCollection $this$tryPerformAccessibilityChecks) {
        Intrinsics.checkNotNullParameter((Object)$this$tryPerformAccessibilityChecks, (String)"<this>");
        Actions_skikoKt.tryPerformAccessibilityChecks(SelectorsKt.onFirst($this$tryPerformAccessibilityChecks));
        return $this$tryPerformAccessibilityChecks;
    }

    private static final boolean isLink(SemanticsNode $this$isLink) {
        return $this$isLink.getConfig().contains(SemanticsProperties.INSTANCE.getLinkTestMarker());
    }

    private static final boolean isLazyList(SemanticsNode $this$isLazyList) {
        return $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollBy()) && $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollToIndex());
    }

    private static final ScrollAxisRange getHorizontalScrollAxis(SemanticsNode $this$horizontalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$horizontalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
    }

    private static final ScrollAxisRange getVerticalScrollAxis(SemanticsNode $this$verticalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$verticalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
    }

    private static final boolean isReversedHorizontally(SemanticsNode $this$isReversedHorizontally) {
        ScrollAxisRange scrollAxisRange = ActionsKt.getHorizontalScrollAxis($this$isReversedHorizontally);
        return scrollAxisRange != null ? scrollAxisRange.getReverseScrolling() : false;
    }

    private static final boolean isReversedVertically(SemanticsNode $this$isReversedVertically) {
        ScrollAxisRange scrollAxisRange = ActionsKt.getVerticalScrollAxis($this$isReversedVertically);
        return scrollAxisRange != null ? scrollAxisRange.getReverseScrolling() : false;
    }

    private static final boolean isAtStart(ScrollAxisRange $this$isAtStart) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtStart;
        if (scrollAxisRange != null) {
            ScrollAxisRange it = scrollAxisRange;
            boolean bl2 = false;
            bl = ((Number)$this$isAtStart.getValue().invoke()).floatValue() == 0.0f;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean isAtEnd(ScrollAxisRange $this$isAtEnd) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtEnd;
        if (scrollAxisRange != null) {
            ScrollAxisRange it = scrollAxisRange;
            boolean bl2 = false;
            bl = ((Number)$this$isAtEnd.getValue().invoke()).floatValue() == ((Number)$this$isAtEnd.getMaxValue().invoke()).floatValue();
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void requireSemantics(SemanticsNodeInteraction $this$requireSemantics, SemanticsNode node, SemanticsPropertyKey<?>[] properties, Function0<String> errorMessage) {
        void $this$filterTo$iv$iv;
        SemanticsPropertyKey<?>[] $this$filter$iv = properties;
        boolean $i$f$filter = false;
        SemanticsPropertyKey<?>[] semanticsPropertyKeyArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!node.getConfig().contains((SemanticsPropertyKey)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingProperties = (List)destination$iv$iv;
        if (!((Collection)missingProperties).isEmpty()) {
            String msg = errorMessage.invoke() + ", the node is missing [" + CollectionsKt.joinToString$default((Iterable)missingProperties, null, null, null, (int)0, null, ActionsKt::requireSemantics$lambda$29, (int)31, null) + "]";
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg, $this$requireSemantics.getSelector$ui_test(), node));
        }
    }

    private static final boolean scrollToNode$lambda$0(SemanticsNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FiltersKt.hasScrollAction().matches(it);
    }

    private static final float scrollToNode$scrollDelta(float a, float b) {
        return Math.signum(a) == Math.signum(b) ? (Math.abs(a) < Math.abs(b) ? a : b) : 0.0f;
    }

    private static final Boolean scrollToNode$lambda$1(SemanticsNode $scrollableNode, Ref.FloatRef $dx, Ref.FloatRef $dy) {
        Function2 function2 = (Function2)((AccessibilityAction)$scrollableNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
        return function2 != null ? (Boolean)function2.invoke((Object)Float.valueOf($dx.element), (Object)Float.valueOf($dy.element)) : null;
    }

    private static final String scrollToIndex$lambda$2(int $index) {
        return "Failed to scroll to index " + $index;
    }

    private static final boolean scrollToIndex$lambda$3(SemanticsNode $this_scrollToIndex, int $index) {
        Function function = ((AccessibilityAction)$this_scrollToIndex.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
        Intrinsics.checkNotNull((Object)function);
        return (Boolean)((Function1)function).invoke((Object)$index);
    }

    private static final String performScrollToKey$lambda$4(Object $key) {
        return "Failed to scroll to the item identified by \"" + $key + "\"";
    }

    private static final boolean performScrollToKey$lambda$6(SemanticsNode $node, int $index) {
        Function function = ((AccessibilityAction)$node.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
        Intrinsics.checkNotNull((Object)function);
        return (Boolean)((Function1)function).invoke((Object)$index);
    }

    private static final Boolean performScrollToNode$lambda$9(SemanticsNode $newNode, float $dx, float $dy) {
        Function2 function2 = (Function2)((AccessibilityAction)$newNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
        return function2 != null ? (Boolean)function2.invoke((Object)Float.valueOf($dx), (Object)Float.valueOf($dy)) : null;
    }

    private static final String performSemanticsAction$lambda$17(SemanticsPropertyKey $key) {
        return "Failed to perform action " + $key.getName();
    }

    private static final Unit performSemanticsAction$lambda$18(SemanticsNode $node, SemanticsPropertyKey $key, Function1 $invocation) {
        Unit unit;
        Function function = ((AccessibilityAction)$node.getConfig().get($key)).getAction();
        if (function != null) {
            $invocation.invoke((Object)function);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit performSemanticsAction$lambda$19(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.invoke();
        return Unit.INSTANCE;
    }

    private static final boolean performCustomAccessibilityActionWithLabel$lambda$21(String $label, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$label);
    }

    private static final boolean performFirstLinkClick$lambda$23(AnnotatedString.Range it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final CharSequence requireSemantics$lambda$29(SemanticsPropertyKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

