/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.usages;

import com.intellij.execution.ExecutionException;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangVirtualPsiElementStubForUsages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler;", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "psiElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "processElementUsages", "", "element", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/usageView/UsageInfo;", "options", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "Companion", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangFindUsagesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangFindUsagesHandler.kt\ncom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n13472#2,2:87\n*S KotlinDebug\n*F\n+ 1 ClangFindUsagesHandler.kt\ncom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler\n*L\n25#1:87,2\n*E\n"})
public final class ClangFindUsagesHandler
extends FindUsagesHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex operatorRegex = new Regex("operator\\W+.*");

    public ClangFindUsagesHandler(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(psiElement);
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ReadAction.nonBlocking(() -> ClangFindUsagesHandler.processElementUsages$lambda$1(element, processor)).executeSynchronously();
        return true;
    }

    private static final void processElementUsages$lambda$1(PsiElement $element, Processor $processor) {
        UsageInfo[] $this$forEach$iv = Companion.findUsages($element);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $processor.process((Object)it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler$Companion;", "", "<init>", "()V", "operatorRegex", "Lkotlin/text/Regex;", "findClangUsages", "", "Lcom/jetbrains/cidr/lang/daemon/clang/usages/ClangFoundUsage;", "element", "Lcom/intellij/psi/PsiElement;", "usageAsVirtualPsiElement", "presentation", "Lcom/intellij/navigation/ItemPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "u", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/usageView/UsageInfo;", "intellij.cidr.clangd"})
    @SourceDebugExtension(value={"SMAP\nClangFindUsagesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangFindUsagesHandler.kt\ncom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,86:1\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n1563#2:100\n1634#2,3:101\n1#3:97\n37#4:104\n36#4,3:105\n*S KotlinDebug\n*F\n+ 1 ClangFindUsagesHandler.kt\ncom/jetbrains/cidr/lang/daemon/clang/usages/ClangFindUsagesHandler$Companion\n*L\n81#1:87,9\n81#1:96\n81#1:98\n81#1:99\n81#1:100\n81#1:101,3\n81#1:97\n83#1:104\n83#1:105,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<ClangFoundUsage> findClangUsages(PsiElement element) {
            int offset = element.getTextOffset();
            if (element.getText() != null) {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence charSequence = string;
                if (operatorRegex.matches(charSequence)) {
                    offset = element.getTextRange().getStartOffset();
                }
            }
            VirtualFile vFile = element.getContainingFile().getVirtualFile();
            Ref usages = Ref.create((Object)CollectionsKt.emptyList());
            ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted(element.getProject());
            if (clangLanguageService != null) {
                clangLanguageService.findUsages(vFile, offset, arg_0 -> Companion.findClangUsages$lambda$0(usages, arg_0));
            }
            Object object = usages.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (List)object;
        }

        private final PsiElement usageAsVirtualPsiElement(ItemPresentation presentation, Project project, ClangFoundUsage u) {
            ItemPresentation itemPresentation = presentation;
            if (itemPresentation == null) {
                return null;
            }
            ItemPresentation searchElemPresentation = itemPresentation;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(new URI(u.getLocation().getUri()).getPath());
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (!virtualFile2.isValid()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            if (u.getLocation().getRange().getEnd().getLine() >= document2.getLineCount() || document2.getLineStartOffset(u.getLocation().getRange().getEnd().getLine()) + u.getLocation().getRange().getEnd().getCharacter() >= document2.getTextLength()) {
                return null;
            }
            return (PsiElement)new ClangVirtualPsiElementStubForUsages(u, file, document2, searchElemPresentation.getPresentableText());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UsageInfo[] findUsages(@NotNull PsiElement element) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List<ClangFoundUsage> usages = this.findClangUsages(element);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ItemPresentation presentation = ((NavigatablePsiElement)element).getPresentation();
            Iterable $this$mapNotNull$iv = usages;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            PsiElement psiElement = $this$forEach$iv$iv$iv.iterator();
            while (psiElement.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = psiElement.next();
                boolean bl = false;
                ClangFoundUsage it = (ClangFoundUsage)element$iv$iv;
                boolean bl2 = false;
                if (Companion.usageAsVirtualPsiElement(presentation, project2, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new UsageInfo((PsiElement)it, -1, -1, false));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new UsageInfo[0]);
        }

        private static final void findClangUsages$lambda$0(Ref $usages, ClangResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            try {
                List list = (List)it.waitForResult();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                $usages.set((Object)list);
            }
            catch (ExecutionException e) {
                CidrLogService.LOG.warn((Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

