/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangScanLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangTidyUpdateStartupActivity;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyInspectionDescriptionProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionChecksDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ@\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u001b\u0010\u0016\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "TIMEOUT", "Lkotlin/time/Duration;", "J", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showNotificationOnUpdate", "actualClangTidyVersion", "Lcom/intellij/openapi/util/Version;", "previousClangTidyVersion", "actualClangTidyChecks", "", "", "previousClangTidyChecks", "showInspectionChecksDialog", "newChecks", "getNotificationMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "isVersionUpdated", "", "getActualClangTidyVersion", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getActualClangTidyChecks", "Lkotlin/Pair;", "intellij.cidr.clangd"})
public final class ClangTidyUpdateStartupActivity
implements ProjectActivity {
    private final long TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationKt.getApplication().isUnitTestMode() || !CommonClangTidyUtil.getBuiltinClangTidyPath().exists()) {
            return Unit.INSTANCE;
        }
        String string = ClangdBundle.message("clang.tidy.check.for.update.task", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object object = TasksKt.withBackgroundProgress((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            int label;
            final /* synthetic */ ClangTidyUpdateStartupActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> execute.2.invokeSuspend$lambda$0(this.this$0, this.$project, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ClangTidyUpdateStartupActivity this$0, Project $project, ProgressIndicator it) {
                ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
                ClangTidySettings settings = ClangTidySettings.getInstance();
                Intrinsics.checkNotNull((Object)indicator);
                Version version = ClangTidyUpdateStartupActivity.access$getActualClangTidyVersion(this$0, indicator);
                if (version == null) {
                    return Unit.INSTANCE;
                }
                Version actualClangTidyVersion = version;
                String string = settings.getPreviousClangTidyVersion();
                if (string == null) {
                    string = "";
                }
                Pattern[] patternArray = new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN};
                Version previousClangTidyVersion = VersionUtil.parseVersion((String)string, (Pattern[])patternArray);
                Pattern[] patternArray2 = ClangTidyUpdateStartupActivity.access$getActualClangTidyChecks(this$0, indicator);
                if (patternArray2 == null) {
                    return Unit.INSTANCE;
                }
                patternArray = patternArray2;
                Set actualClangTidyChecks = (Set)patternArray.component1();
                Set availableMisraChecks = (Set)patternArray.component2();
                Set<String> previousClangTidyChecks = settings.getPreviousClangTidyChecks();
                ClangTidyUpdateStartupActivity.access$showNotificationOnUpdate(this$0, actualClangTidyVersion, previousClangTidyVersion, actualClangTidyChecks, previousClangTidyChecks, $project);
                settings.setPreviousClangTidyVersion(actualClangTidyVersion.toString());
                settings.setPreviousClangTidyChecks(actualClangTidyChecks);
                settings.setAvailableMisraChecks(availableMisraChecks);
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void showNotificationOnUpdate(Version actualClangTidyVersion, Version previousClangTidyVersion, Set<String> actualClangTidyChecks, Set<String> previousClangTidyChecks, Project project) {
        if (previousClangTidyVersion == null || previousClangTidyChecks == null) {
            return;
        }
        if (!this.isVersionUpdated(actualClangTidyVersion, previousClangTidyVersion)) {
            return;
        }
        Set newChecks = CollectionsKt.toMutableSet((Iterable)actualClangTidyChecks);
        newChecks.removeAll((Collection)previousClangTidyChecks);
        if (newChecks.isEmpty()) {
            return;
        }
        if (CommonClangTidyUtil.getClangTidyInspection(null, project) == null) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Clang-Tidy Updated");
        String string = ClangdBundle.message("clang.tidy.update.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, this.getNotificationMessage(newChecks), NotificationType.INFORMATION);
        String string2 = ClangdBundle.message("clang.tidy.update.review.new.checks.link", new Object[0]);
        notification.addAction((AnAction)new DumbAwareAction(this, newChecks, project, string2){
            final /* synthetic */ ClangTidyUpdateStartupActivity this$0;
            final /* synthetic */ Set<String> $newChecks;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$newChecks = $newChecks;
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ClangTidyUpdateStartupActivity.access$showInspectionChecksDialog(this.this$0, this.$newChecks, this.$project);
            }
        });
        notification.notify(project);
    }

    private final void showInspectionChecksDialog(Set<String> newChecks, Project project) {
        ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(null, project);
        ClangScanLog.LOG.assertTrue(inspection != null);
        Collection collection = newChecks;
        ClangTidyInspection clangTidyInspection = inspection;
        Intrinsics.checkNotNull((Object)((Object)clangTidyInspection));
        InspectionChecksDialog dialog = new InspectionChecksDialog(collection, clangTidyInspection.getClangTidyChecks(), ClangdBundle.message("clang.tidy.update.new.checks.dialog.title", new Object[0]), inspection, new ClangTidyInspectionDescriptionProvider(), project);
        dialog.showAndGet();
    }

    private final String getNotificationMessage(Set<String> newChecks) {
        int howManyChecks = newChecks.size() == 1 ? 1 : 2;
        Object[] objectArray = new Object[]{newChecks.size(), howManyChecks};
        String string = ClangdBundle.message("clang.tidy.update.notification.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean isVersionUpdated(Version actualClangTidyVersion, Version previousClangTidyVersion) {
        return previousClangTidyVersion.compareTo(actualClangTidyVersion) <= 0;
    }

    private final Version getActualClangTidyVersion(ProgressIndicator indicator) {
        try {
            String[] stringArray = new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--version"};
            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput processOutput2 = handler.runProcessWithProgressIndicator(indicator, (int)Duration.getInWholeMilliseconds-impl((long)this.TIMEOUT));
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
            ProcessOutput output = processOutput2;
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            Pattern[] patternArray = new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN};
            return VersionUtil.parseVersion((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (Pattern[])patternArray);
        }
        catch (Exception e) {
            ClangScanLog.LOG.warn("Cannot get Clang-Tidy version", (Throwable)e);
            return null;
        }
    }

    private final Pair<Set<String>, Set<String>> getActualClangTidyChecks(ProgressIndicator indicator) {
        try {
            String[] stringArray = new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--checks=*", "--list-checks"};
            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput processOutput2 = handler.runProcessWithProgressIndicator(indicator, (int)Duration.getInWholeMilliseconds-impl((long)this.TIMEOUT));
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
            ProcessOutput output = processOutput2;
            String[] stringArray2 = StringUtil.splitByLines((String)output.getStdout());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"splitByLines(...)");
            String[] outputLines = stringArray2;
            Set checks = new LinkedHashSet();
            Set misraChecks = new LinkedHashSet();
            for (String line : outputLines) {
                Intrinsics.checkNotNull((Object)line);
                String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (StringsKt.isBlank((CharSequence)trimmedLine)) continue;
                if (StringsKt.startsWith((String)trimmedLine, (String)"clion-", (boolean)true)) {
                    if (!StringsKt.startsWith((String)trimmedLine, (String)"clion-misra-", (boolean)true)) continue;
                    misraChecks.add(trimmedLine);
                    continue;
                }
                if (StringsKt.startsWith((String)trimmedLine, (String)"Enabled checks:", (boolean)true)) continue;
                checks.add(trimmedLine);
            }
            return new Pair((Object)checks, (Object)misraChecks);
        }
        catch (Exception e) {
            ClangScanLog.LOG.warn("Cannot get Clang-Tidy checks", (Throwable)e);
            return null;
        }
    }

    public static final /* synthetic */ Version access$getActualClangTidyVersion(ClangTidyUpdateStartupActivity $this, ProgressIndicator indicator) {
        return $this.getActualClangTidyVersion(indicator);
    }

    public static final /* synthetic */ Pair access$getActualClangTidyChecks(ClangTidyUpdateStartupActivity $this, ProgressIndicator indicator) {
        return $this.getActualClangTidyChecks(indicator);
    }

    public static final /* synthetic */ void access$showNotificationOnUpdate(ClangTidyUpdateStartupActivity $this, Version actualClangTidyVersion, Version previousClangTidyVersion, Set actualClangTidyChecks, Set previousClangTidyChecks, Project project) {
        $this.showNotificationOnUpdate(actualClangTidyVersion, previousClangTidyVersion, actualClangTidyChecks, previousClangTidyChecks, project);
    }

    public static final /* synthetic */ void access$showInspectionChecksDialog(ClangTidyUpdateStartupActivity $this, Set newChecks, Project project) {
        $this.showInspectionChecksDialog(newChecks, project);
    }
}

