/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.dfa.OCDFAInspectionConfigUtil;
import com.jetbrains.cidr.lang.settings.DfaMemoryLeakSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangIdeFacadeImpl
implements ClangIdeFacade {
    @NotNull
    private final ExecutorService myMessagingService;

    public ClangIdeFacadeImpl(@NotNull @NonNls String descriptor) {
        if (descriptor == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myMessagingService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdMessagingThread [" + descriptor + "]"));
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull @NonNls String url) {
        if (url == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(1);
        }
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(2);
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public List<OpenRequestId> getOpenRequests(@NotNull Project project, @NotNull VirtualFile file) {
        Document document;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(4);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            List<OpenRequestId> list = EditorFactory.getInstance().editors(document).filter(editor -> editor.getProject() == project).map(EditorOpenRequestId::new).collect(Collectors.toList());
            if (list == null) {
                ClangIdeFacadeImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<OpenRequestId> list = Collections.emptyList();
        if (list == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean isModified(@NotNull VirtualFile file) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(7);
        }
        FileDocumentManager fileDocManager = FileDocumentManager.getInstance();
        return fileDocManager.isFileModified(file);
    }

    @Override
    @Nullable
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(8);
        }
        if ((document = this.getDocument(file)) == null) {
            return null;
        }
        return this.getFileFacade(file, document);
    }

    @Override
    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(9);
        }
        if (document == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(10);
        }
        return new ClangFileFacadeImpl(document);
    }

    protected @NotNull Pair<@Nullable OCResolveConfiguration, @Nullable OCLanguageKind> getResolveConfigurationAndKindForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(11);
        }
        if (vf == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(12);
        }
        List configs = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(vf);
        OCResolveConfiguration resolveConfig = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
        OCLanguageKind kind = OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)project, (String)vf.getName());
        Pair pair = Pair.create((Object)resolveConfig, (Object)kind);
        if (pair == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @Override
    public @NotNull CompletableFuture<@Nullable ClangUtils.ResolveInfo> getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(14);
        }
        if (vf == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(15);
        }
        Pair<OCResolveConfiguration, OCLanguageKind> configAndKind = this.getResolveConfigurationAndKindForFile(project, vf);
        OCResolveConfiguration config = (OCResolveConfiguration)configAndKind.first;
        OCLanguageKind kind = (OCLanguageKind)configAndKind.second;
        ClangUtils.ResolveInfo resolveInfo = null;
        if (config != null && kind != null) {
            resolveInfo = new ClangUtils.ResolveInfo(config, vf, kind, false);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(resolveInfo);
        if (completableFuture == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<@Nullable ClangdCompilationCommand> getCompilationCommandAsync(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull String pathToMacrosFile, @NotNull Cpp20ModulesContext cpp20ModulesContext) {
        if (converter == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(18);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(19);
        }
        if (pathToMacrosFile == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(20);
        }
        if (cpp20ModulesContext == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(21);
        }
        return this.getResolveInfoForFile(project, file).thenApply(ri -> ClangUtils.getCompilationCommand(converter, project, file, pathToMacrosFile, cpp20ModulesContext, ri));
    }

    @Override
    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(22);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(23);
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    @Override
    @Nullable
    public CLionClazyConfigParams getClazyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(24);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(25);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get OCPsiFile for file " + file.getPath());
            return null;
        }
        ClazyInspection inspection = CommonClangTidyUtil.getClazyInspection(psiFile, project);
        return inspection != null && CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)inspection, psiFile, project) ? new CLionClazyConfigParams(inspection.getClazyChecks()) : null;
    }

    @Override
    public ClionClangDFAConfigParams getDFAOptions(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(26);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(27);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        Optional dfaConfigParams = (Optional)project.getUserData(CLANG_DFA_CONFIG);
        if (dfaConfigParams != null) {
            return dfaConfigParams.orElse(null);
        }
        if (psiFile != null && OCDFAInspectionConfigUtil.isClangdDFAEnabled((PsiFile)psiFile)) {
            return new ClionClangDFAConfigParams(OCDFAInspectionConfigUtil.isInspectHeaderFunctionsMode((PsiFile)psiFile), OCDFAInspectionConfigUtil.getStatementsCntLimit((PsiFile)psiFile), DfaMemoryLeakSettings.INSTANCE.getAllocatingFunctions(), DfaMemoryLeakSettings.INSTANCE.getDeallocatingFunctions());
        }
        return null;
    }

    @Override
    @Nullable
    public ClionClangTidyConfigParams getClangTidyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(28);
        }
        if (file == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(29);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get OCPsiFile for file " + file.getPath());
            return null;
        }
        ClangTidyInspection inspection = CommonClangTidyUtil.getClangTidyInspection(psiFile, project);
        if (inspection == null) {
            ClangUtils.warnClangd(CidrLogService.LOG, "Failed to get 'preferClangTidyFilesOverIDESettings' option, default one will be used");
        }
        boolean preferClangTidyFiles = inspection != null && inspection.isPreferClangTidyFilesOverIDESettings();
        String clangTidyConfig = ClangIdeFacadeImpl.getClangTidyConfig(project, psiFile, false);
        String ourClangTidyConfig = ClangIdeFacadeImpl.getClangTidyConfig(project, psiFile, true);
        return StringUtil.isEmpty((String)clangTidyConfig) && StringUtil.isEmpty((String)ourClangTidyConfig) ? null : new ClionClangTidyConfigParams(ourClangTidyConfig, clangTidyConfig, preferClangTidyFiles);
    }

    @Nullable
    private static String getClangTidyConfig(Project project, PsiFile file, Boolean takeOurClangTidyConfig) {
        List forcedOptions;
        String forcedConfig = takeOurClangTidyConfig != false ? (String)project.getUserData(CLION_CLANG_TIDY_CONFIG) : (String)project.getUserData(CLANG_TIDY_CONFIG);
        List list = forcedOptions = takeOurClangTidyConfig != false ? (List)project.getUserData(CLION_CLANG_TIDY_OPTIONS) : null;
        if (forcedConfig != null) {
            return CommonClangTidyUtil.getClangTidyConfig(forcedConfig, forcedOptions != null ? forcedOptions : ContainerUtil.emptyList());
        }
        if (!ClangUtils.isClangTidyViaClangdOn(project) || CommonClangTidyUtil.getCustomClangTidyPath() != null) {
            return null;
        }
        if (takeOurClangTidyConfig.booleanValue()) {
            List<OurClangTidyInspection> ourClangTidyInspections = CommonClangTidyUtil.getOurInspections(true, file, project);
            SmartList checks = new SmartList((Object)"-*");
            checks.addAll(ContainerUtil.map(ourClangTidyInspections, OurClangTidyInspection::getCheckName));
            ArrayList<ClangTidyCheckOption> checkOptions = new ArrayList<ClangTidyCheckOption>();
            for (OurClangTidyInspection inspection : ourClangTidyInspections) {
                checkOptions.addAll(inspection.getClangTidyCheckOptions());
            }
            MisraInspection misraInspection = CommonClangTidyUtil.getMisraInspection(file, project);
            if (misraInspection != null && CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)misraInspection, file, project)) {
                checks.add(misraInspection.getAllMisraChecks());
            }
            return CommonClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), checkOptions);
        }
        ClangTidyInspection clangTidyInspection = CommonClangTidyUtil.getClangTidyInspection(file, project);
        if (clangTidyInspection != null) {
            if (!CommonClangTidyUtil.isToolEnabled((LocalInspectionTool)clangTidyInspection, file, project)) {
                return null;
            }
            String checks = CommonClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*");
            return CommonClangTidyUtil.getClangTidyConfig(checks, clangTidyInspection.getClangTidyCheckOptions());
        }
        return CommonClangTidyUtil.getClangTidyConfig("-clion-*", ContainerUtil.emptyList());
    }

    @Override
    @Nullable
    public Long getPsiModificationCounter(@NotNull Project project) {
        PsiModificationTracker psiModificationTracker;
        if (project == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(30);
        }
        return (psiModificationTracker = PsiModificationTracker.getInstance((Project)project)) != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @Override
    public void sendMessageLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            ClangIdeFacadeImpl.$$$reportNull$$$0(31);
        }
        if (!this.myMessagingService.isShutdown()) {
            this.myMessagingService.execute(() -> {
                while (!this.myMessagingService.isShutdown()) {
                    if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                        return;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
                return;
            });
        }
    }

    @Override
    public void stop() {
        this.myMessagingService.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToMacrosFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20ModulesContext";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenRequests";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveConfigurationAndKindForFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveInfoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOpenRequests";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileFacade";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfigurationAndKindForFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getResolveInfoForFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationCommandAsync";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedIncludesInspectionMode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClazyConfig";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDFAOptions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPsiModificationCounter";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sendMessageLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13, 16 -> new IllegalStateException(string);
        };
    }
}

