/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangPreprocessedReport {
    @NotNull
    private final List<PreprocessedFile> myPreprocessedFiles;

    public ClangPreprocessedReport(@NotNull List<PreprocessedFile> preprocessedFiles) {
        if (preprocessedFiles == null) {
            ClangPreprocessedReport.$$$reportNull$$$0(0);
        }
        this.myPreprocessedFiles = preprocessedFiles;
    }

    @NotNull
    public List<PreprocessedFile> getPreprocessedFiles() {
        List<PreprocessedFile> list = Collections.unmodifiableList(this.myPreprocessedFiles);
        if (list == null) {
            ClangPreprocessedReport.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class PreprocessedFile {
        @NotNull
        public final String targetPath;
        @Nullable
        public final String lastDiagnostics;
        @NotNull
        public final List<String> commandLine;
        @NotNull
        public final String clangTidyConfig;
        @NotNull
        public final String clionClangTidyConfig;
        @NotNull
        public final String clazyConfig;
        @Nullable
        public final ClionClangDFAConfigParams dfaConfigParams;
        @NotNull
        public final UnusedIncludesInspectionMode unusedIncludesMode;
        @NotNull
        public final String diags;
        @Nullable
        public final String content;
        @NotNull
        public final String macros;
        @NotNull
        public final String cpp20ModuleMap;
        @NotNull
        public final String stdModuleMap;

        public PreprocessedFile(@NotNull String path, @Nullable String lastDiagnostics, @NotNull List<String> commandLine, @NotNull String clangTidyConfig, @NotNull String clionClangTidyConfig, @NotNull String clazyConfig, @Nullable ClionClangDFAConfigParams dfaConfigParams, @NotNull UnusedIncludesInspectionMode unusedIncludesMode, @NotNull String diags, @Nullable String content, @NotNull String macros, @NotNull String cpp20ModuleMap, @NotNull String stdModuleMap) {
            if (path == null) {
                PreprocessedFile.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                PreprocessedFile.$$$reportNull$$$0(1);
            }
            if (clangTidyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(2);
            }
            if (clionClangTidyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(3);
            }
            if (clazyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(4);
            }
            if (unusedIncludesMode == null) {
                PreprocessedFile.$$$reportNull$$$0(5);
            }
            if (diags == null) {
                PreprocessedFile.$$$reportNull$$$0(6);
            }
            if (macros == null) {
                PreprocessedFile.$$$reportNull$$$0(7);
            }
            if (cpp20ModuleMap == null) {
                PreprocessedFile.$$$reportNull$$$0(8);
            }
            if (stdModuleMap == null) {
                PreprocessedFile.$$$reportNull$$$0(9);
            }
            this.targetPath = path;
            this.commandLine = commandLine;
            this.clangTidyConfig = clangTidyConfig;
            this.clionClangTidyConfig = clionClangTidyConfig;
            this.clazyConfig = clazyConfig;
            this.dfaConfigParams = dfaConfigParams;
            this.unusedIncludesMode = unusedIncludesMode;
            this.diags = diags;
            this.content = content;
            this.macros = macros;
            this.lastDiagnostics = lastDiagnostics;
            this.cpp20ModuleMap = cpp20ModuleMap;
            this.stdModuleMap = stdModuleMap;
        }

        @NotNull
        public String getCompilationInfoAsString(@Nullable Obfuscator obfuscator) {
            List preparedCommandLine;
            String preparedTargetPath;
            if (obfuscator != null) {
                preparedTargetPath = obfuscator.obfuscatePath(this.targetPath);
                preparedCommandLine = obfuscator.obfuscateCommandLine(this.commandLine);
            } else {
                preparedTargetPath = this.targetPath;
                preparedCommandLine = this.commandLine;
            }
            preparedCommandLine = ContainerUtil.map(preparedCommandLine, opt -> opt.indexOf(32) >= 0 ? "\"" + opt + "\"" : opt);
            String string = "Target file: " + preparedTargetPath + "\nCompilation command: " + StringUtil.join((Collection)preparedCommandLine, (String)" ") + "\nClang-tidy config: " + this.clangTidyConfig + "\nCLion clang-tidy config: " + this.clionClangTidyConfig + "\nClazy config: " + this.clazyConfig + "\nDFA Input: " + this.getDfaConfigAsString() + "\nUnusedIncludesInspection: " + String.valueOf((Object)this.unusedIncludesMode) + "\nPP Diagnostics: " + this.diags + "\n";
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String getContent(@Nullable Obfuscator obfuscator) {
            if (this.content == null) {
                return "<failed to preprocess>";
            }
            if (obfuscator != null) {
                String string = obfuscator.obfuscate(this.content);
                if (string == null) {
                    PreprocessedFile.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = this.content;
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        public String getTargetPath(@Nullable Obfuscator obfuscator) {
            String string = obfuscator != null ? obfuscator.obfuscatePath(this.targetPath) : this.targetPath;
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(13);
            }
            return string;
        }

        @NotNull
        private String getDfaConfigAsString() {
            if (this.dfaConfigParams == null) {
                return "disabled";
            }
            String string = "inspectHeaderFunctionsMode: " + (this.dfaConfigParams.isInspectHeaderFunctionsMode() ? "true" : "false") + "\nstatementsCntLimit: " + this.dfaConfigParams.getStatementsCntLimit();
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(14);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 11, 12, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangTidyConfig";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clionClangTidyConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazyConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unusedIncludesMode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diags";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "macros";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpp20ModuleMap";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stdModuleMap";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport$PreprocessedFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport$PreprocessedFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilationInfoAsString";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfaConfigAsString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 11, 12, 13, 14 -> new IllegalStateException(string);
            };
        }
    }
}

