/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.FullCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ParsingParamsTransformer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTypehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangVisibility;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdFatalError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdInlayHintData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightSymbolInfoResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.lang.highlighting.ClangBracketMatchResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public interface ClangLanguageService {
    @NotNull
    public String printStats(@NotNull String var1);

    @NotNull
    public ClangDaemonContext getContext();

    @NotNull
    public Disposable getAssociatedDisposable();

    @NotNull
    public String getDescriptor();

    @NotNull
    public String getWslMsId();

    @NotNull
    public MessageBus getMessageBus();

    @NotNull
    public ClangIdeFacade getClangIdeFacade();

    @NotNull
    public ClangUrlConverter getUrlConverter();

    public boolean isActive();

    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog();

    @Nullable
    public ClangTelemetry getTelemetry();

    public <E extends Throwable> void gotoDefinition(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<List<ClangSym>, E> var3) throws E;

    public <E extends Throwable> void gotoTypeDeclaration(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<List<ClangSym>, E> var3) throws E;

    public <E extends Throwable> void getCLionHoverInfo(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<ClionHoverInfo, E> var3) throws E;

    public <E extends Throwable> void getHover(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<Hover, E> var3) throws E;

    public <E extends Throwable> void findUsages(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<List<ClangFoundUsage>, E> var3) throws E;

    public <E extends Throwable> void getLocalVariables(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<List<String>, E> var3) throws E;

    public <E extends Throwable> void matchAngleBracket(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<ClangBracketMatchResult, E> var3) throws E;

    public <E extends Throwable> void matchPP(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<List<Range>, E> var3) throws E;

    public <E extends Throwable> void findEntryPoint(@NotNull VirtualFile var1, @NotNull ClangResultConsumer<ClangSym, E> var2) throws E;

    public <E extends Throwable> void complete(@NotNull VirtualFile var1, int var2, int var3, @NotNull String var4, @NotNull CompletionTriggerKind var5, @NotNull int var6, Pair<Integer, ArrayList<String>> var7, @NotNull ClangResultConsumer<Either<List<CLionCompletionItem>, CLionCompletionList>, E> var8) throws E;

    public <E extends Throwable> void getFastLineMarkers(@NotNull VirtualFile var1, int var2, int var3, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> var4) throws E;

    public <E extends Throwable> void getSlowLineMarkers(@NotNull VirtualFile var1, int var2, int var3, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> var4) throws E;

    public <E extends Throwable> void getTestLineMarkers(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull ClangResultConsumer<List<ClionTestRunLineMarker>, E> var3) throws E;

    public <E extends Throwable> void getInlayHints(@NotNull VirtualFile var1, @Nullable ClionClangNamehintConfigParams var2, @Nullable ClionClangTypehintConfigParams var3, @NotNull ClangResultConsumer<CachingSupplier<ClangdInlayHintData>, E> var4) throws E;

    public <E extends Throwable> void getSignatureHelp(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<SignatureHelp, E> var3) throws E;

    public <E extends Throwable> void dumpAST(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<String, E> var3) throws E;

    public <E extends Throwable> void dumpTokens(@NotNull VirtualFile var1, int var2, @NotNull ClangResultConsumer<String, E> var3) throws E;

    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile var1, @NotNull TextRange var2, @Nullable String var3, int var4);

    @NotNull
    public @NotNull CompletableFuture<@NotNull List<@NotNull ClangLightSymbolInfoResponse>> clionLightIndex(@NotNull VirtualFile var1);

    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> indentLine(@NotNull VirtualFile var1, int var2, @Nullable String var3);

    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile var1);

    @NotNull
    public CompletableFuture<ClionFileStats> requestTimingStats(@NotNull VirtualFile var1);

    public <E extends Throwable> void preprocess(@NotNull VirtualFile var1, @NotNull ClangResultConsumer<CLionClangPreprocessResult, E> var2) throws E;

    public <E extends Throwable> void preprocessSubstitution(@NotNull VirtualFile var1, int var2, int var3, @NotNull ClangResultConsumer<CLionClangPreprocessResult, E> var4) throws E;

    public <T, E extends Throwable> T computeWithParsed(@NotNull VirtualFile var1, @NotNull ThrowableFunction<ClangParseResponse, T, E> var2) throws E;

    public <T, E extends Throwable> T computeWithCustomParsed(@NotNull VirtualFile var1, @Nullable ParsingParamsTransformer var2, @NotNull ThrowableFunction<ClangParseResponse, T, E> var3) throws E;

    public <T, E extends Throwable> T computeWithOpenedAndCustomParsed(@NotNull VirtualFile var1, @Nullable ParsingParamsTransformer var2, @NotNull ThrowableFunction<ClangParseResponse, T, E> var3) throws E;

    public <E extends Throwable> void runWithParsed(@NotNull VirtualFile var1, @NotNull ThrowableConsumer<ClangParseResponse, E> var2) throws E;

    public <T, E extends Throwable> T computeWithOpenedAndParsed(@NotNull VirtualFile var1, @NotNull ThrowableFunction<ClangParseResponse, T, E> var2) throws E;

    public <E extends Throwable> void runWithOpenedAndParsed(@NotNull VirtualFile var1, @NotNull ThrowableConsumer<ClangParseResponse, E> var2) throws E;

    @Nullable
    public ClangParseResponse getParsed(@NotNull VirtualFile var1);

    @NotNull
    public CompletableFuture<List<CLionSymbolInformation>> getSymbols(@NotNull String var1, boolean var2);

    @NotNull
    public CompletableFuture<List<ClangFoundUsage>> getReferences(@NotNull String var1, boolean var2);

    public boolean notifyDocumentOpened(@NotNull VirtualFile var1, @NotNull OpenRequestId var2);

    public void notifyDocumentClosed(@NotNull VirtualFile var1, @NotNull OpenRequestId var2);

    public void notifyDocumentChanged(@NotNull VirtualFile var1, @NotNull DocumentEvent var2);

    public void notifyDocumentChanged(@NotNull String var1, @NotNull String var2);

    public void notifyFolderChanged(@NotNull String var1, @NotNull String var2);

    public void notifyReparseRequired(@NotNull VirtualFile var1);

    public void notifyDocumentSaved(@NotNull VirtualFile var1);

    public void notifyDocumentMoved(@NotNull VirtualFile var1, @NotNull String var2, @NotNull String var3);

    public void notifySetCDB(@NotNull Collection<VirtualFile> var1);

    public void notifyLoadIndex(@NotNull List<String> var1, @NotNull String var2);

    public void notifyLoadGraph(@NotNull String var1);

    public void notifyIndexPartFinished(@NotNull String var1);

    public void notifyModuleMappingChanged(@NotNull List<String> var1, @NotNull List<ClionCompileCommandParams> var2, @NotNull List<String> var3);

    @NotNull
    public CompletableFuture<List<? extends ClangCommandLineArgument>> parseCommandLine(@NotNull List<String> var1, @Nullable EnumSet<ClangOptionsFlags> var2, @Nullable EnumSet<ClangOptionsFlags> var3, @NotNull EnumSet<ClangVisibility> var4);

    @NotNull
    public CompletableFuture<Boolean> startUpServer();

    @NotNull
    public ClangStopData shutDownServer();

    public boolean isFileBanned(@NotNull String var1);

    @NotNull
    public ClangStopData stop();

    @NotNull
    public String getClangdModulesPath();

    @NotNull
    public String getCpp20ModulesPath();

    public boolean isIndexer();

    @NotNull
    public CompletableFuture<ClangPreprocessedReport> generatePreprocessedReport(@NotNull List<String> var1, boolean var2);

    public int getServerPid();

    @NonNls
    @NotNull
    public String getNativeStacktrace();

    public void printServerState();

    @NotNull
    public CompletableFuture<ClangMemoryUsageInfo> getMemoryStat();

    @Nullable
    public ClangdFatalError getFatalError();

    public int getVersion(@NotNull VirtualFile var1);

    @TestOnly
    @NotNull
    public CompletableFuture<ClionPublishDiagnosticsParams> checkPreprocessedCase(@NotNull File var1, @NotNull FullCompilationInfo var2);

    @TestOnly
    public boolean hadCrashes();

    public String debugDumpUsages(@NotNull String var1);

    public void debugCrashServer();

    public void waitUntilTasksFinished();

    public static enum Kind {
        Clangd,
        Indexer,
        StatelessIndexer;


        public boolean isIndexer() {
            return this == Indexer || this == StatelessIndexer;
        }
    }
}

