/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build.runners;

import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.build.runners.BuildSystemScope;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JH\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\n2'\u0010\u0010\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/CidrBuildSessionsQueueManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "queues", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Lcom/jetbrains/cidr/execution/build/runners/BuildSystemScope;", "launch", "Lkotlinx/coroutines/Job;", "T", "clazz", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/Job;", "Companion", "intellij.cidr.execution"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCidrBuildSessionsQueueManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrBuildSessionsQueueManager.kt\ncom/jetbrains/cidr/execution/build/runners/CidrBuildSessionsQueueManager\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n19#2:67\n14#3:68\n*S KotlinDebug\n*F\n+ 1 CidrBuildSessionsQueueManager.kt\ncom/jetbrains/cidr/execution/build/runners/CidrBuildSessionsQueueManager\n*L\n32#1:67\n25#1:68\n*E\n"})
public final class CidrBuildSessionsQueueManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<Class<?>, BuildSystemScope> queues;
    @NotNull
    private static final Logger LOG;

    public CidrBuildSessionsQueueManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.queues = new ConcurrentHashMap();
    }

    @NotNull
    public final <T> Job launch(@NotNull Class<T> clazz, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.queues.computeIfAbsent(clazz, arg_0 -> CidrBuildSessionsQueueManager.launch$lambda$2(arg_0 -> CidrBuildSessionsQueueManager.launch$lambda$1(this, arg_0), arg_0)).launchBuild(block);
    }

    private static final Unit launch$lambda$1$lambda$0(CidrBuildSessionsQueueManager this$0, Class $clazz, Throwable it) {
        this$0.queues.remove($clazz);
        return Unit.INSTANCE;
    }

    private static final BuildSystemScope launch$lambda$1(CidrBuildSessionsQueueManager this$0, Class clazz) {
        CoroutineScope targetScope;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Project $this$asSafely$iv = this$0.project;
        boolean $i$f$asSafely = false;
        Project project = $this$asSafely$iv;
        if (!(project instanceof ComponentManagerEx)) {
            project = null;
        }
        ComponentManagerEx componentManagerEx = (ComponentManagerEx)project;
        Object object = targetScope = componentManagerEx != null ? componentManagerEx.instanceCoroutineScope(clazz) : null;
        if (targetScope != null) {
            JobKt.getJob((CoroutineContext)targetScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> CidrBuildSessionsQueueManager.launch$lambda$1$lambda$0(this$0, clazz, arg_0));
        } else {
            LOG.warn("Cannot create proper scope for " + clazz + ", falling back to project scope");
        }
        Project project2 = this$0.project;
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        CoroutineScope coroutineScope = targetScope;
        if (coroutineScope == null) {
            coroutineScope = this$0.scope;
        }
        return new BuildSystemScope(project2, string, coroutineScope);
    }

    private static final BuildSystemScope launch$lambda$2(Function1 $tmp0, Object p0) {
        return (BuildSystemScope)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrBuildSessionsQueueManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/CidrBuildSessionsQueueManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cidr.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

