/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001*B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\u0017R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010'\u001a\u00020\u0003X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000b\"\u0004\b)\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthLocalServerReceiver;", "Lcom/google/api/client/extensions/java6/auth/oauth2/VerificationCodeReceiver;", "host", "", "port", "", "successLandingPageUrl", "failureLandingPageUrl", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "()I", "setPort", "(I)V", "getSuccessLandingPageUrl", "getFailureLandingPageUrl", "server", "Lcom/sun/net/httpserver/HttpServer;", "state", "getState", "setState", "(Ljava/lang/String;)V", "code", "getCode", "setCode", "error", "getError", "setError", "waitUnlessSignaled", "Ljava/util/concurrent/Semaphore;", "getWaitUnlessSignaled", "()Ljava/util/concurrent/Semaphore;", "getRedirectUri", "waitForCode", "stop", "", "findOpenPort", "callbackPath", "getCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "setCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "CallbackHandler", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
public class OAuthLocalServerReceiver
implements VerificationCodeReceiver {
    @NotNull
    private final String host;
    private int port;
    @NotNull
    private final String successLandingPageUrl;
    @NotNull
    private final String failureLandingPageUrl;
    @Nullable
    private HttpServer server;
    @Nullable
    private String state;
    @Nullable
    private String code;
    @Nullable
    private String error;
    @NotNull
    private final Semaphore waitUnlessSignaled;
    @NotNull
    private String callbackPath;

    public OAuthLocalServerReceiver(@NotNull String host, int port, @NotNull String successLandingPageUrl, @NotNull String failureLandingPageUrl) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)successLandingPageUrl, (String)"successLandingPageUrl");
        Intrinsics.checkNotNullParameter((Object)failureLandingPageUrl, (String)"failureLandingPageUrl");
        this.host = host;
        this.port = port;
        this.successLandingPageUrl = successLandingPageUrl;
        this.failureLandingPageUrl = failureLandingPageUrl;
        this.waitUnlessSignaled = new Semaphore(0);
        this.callbackPath = "/Callback";
    }

    public /* synthetic */ OAuthLocalServerReceiver(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        this(string, n, string2, string3);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getSuccessLandingPageUrl() {
        return this.successLandingPageUrl;
    }

    @NotNull
    public final String getFailureLandingPageUrl() {
        return this.failureLandingPageUrl;
    }

    @Nullable
    public final String getState() {
        return this.state;
    }

    public final void setState(@Nullable String string) {
        this.state = string;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public final void setCode(@Nullable String string) {
        this.code = string;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final void setError(@Nullable String string) {
        this.error = string;
    }

    @NotNull
    public final Semaphore getWaitUnlessSignaled() {
        return this.waitUnlessSignaled;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getRedirectUri() {
        block2: {
            int n;
            int resolvedPort = this.port != -1 ? this.port : this.findOpenPort();
            HttpServer httpServer = this.server = HttpServer.create(new InetSocketAddress(resolvedPort), 0);
            if (httpServer == null) break block2;
            HttpServer it = httpServer;
            boolean bl = false;
            it.createContext(this.getCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(), new CallbackHandler());
            it.setExecutor(null);
            OAuthLocalServerReceiver oAuthLocalServerReceiver = this;
            try {
                OAuthLocalServerReceiver oAuthLocalServerReceiver2 = oAuthLocalServerReceiver;
                it.start();
                n = it.getAddress().getPort();
            }
            catch (Exception exception) {
                void e;
                OAuthLocalServerReceiver oAuthLocalServerReceiver3 = oAuthLocalServerReceiver;
                throw new IOException((Throwable)e);
            }
            oAuthLocalServerReceiver2.port = n;
        }
        return "http://" + this.host + ":" + this.port + this.getCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
    }

    @NotNull
    public String waitForCode() {
        this.waitUnlessSignaled.acquireUninterruptibly();
        if (this.error != null) {
            this.code = null;
            throw new IOException("User authorization failed with error: " + this.error);
        }
        String string = this.code;
        if (string == null) {
            throw new IOException("Failed to retrieve authorization code.");
        }
        return string;
    }

    public void stop() {
        this.waitUnlessSignaled.release();
        HttpServer httpServer = this.server;
        if (httpServer != null) {
            HttpServer it = httpServer;
            boolean bl = false;
            try {
                it.stop(0);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new IOException(e);
            }
        }
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int findOpenPort() {
        try {
            Closeable closeable = new ServerSocket(0);
            Throwable throwable = null;
            try {
                ServerSocket socket = (ServerSocket)closeable;
                boolean bl = false;
                socket.setReuseAddress(true);
                int n = socket.getLocalPort();
                return n;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("No free TCP/IP port to start embedded HTTP Server on", e);
        }
    }

    @NotNull
    public String getCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        return this.callbackPath;
    }

    public void setCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.callbackPath = string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthLocalServerReceiver$CallbackHandler;", "Lcom/sun/net/httpserver/HttpHandler;", "<init>", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthLocalServerReceiver;)V", "handle", "", "httpExchange", "Lcom/sun/net/httpserver/HttpExchange;", "queryToMap", "", "", "query", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
    public final class CallbackHandler
    implements HttpHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(@NotNull HttpExchange httpExchange) {
            Intrinsics.checkNotNullParameter((Object)httpExchange, (String)"httpExchange");
            if (!Intrinsics.areEqual((Object)OAuthLocalServerReceiver.this.getCallbackPath$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(), (Object)httpExchange.getRequestURI().getPath())) {
                return;
            }
            try {
                Map<String, String> params = this.queryToMap(httpExchange.getRequestURI().getQuery());
                OAuthLocalServerReceiver.this.setError(params.get("error"));
                OAuthLocalServerReceiver.this.setCode(params.get("code"));
                String stateParam = params.get("state");
                Headers respHeaders = httpExchange.getResponseHeaders();
                if (OAuthLocalServerReceiver.this.getState() == null || !Intrinsics.areEqual((Object)OAuthLocalServerReceiver.this.getState(), (Object)stateParam)) {
                    OAuthLocalServerReceiver.this.setError("Failed to validate state parameter.");
                    respHeaders.add("Location", OAuthLocalServerReceiver.this.getFailureLandingPageUrl());
                    httpExchange.sendResponseHeaders(302, -1L);
                } else if (OAuthLocalServerReceiver.this.getError() == null) {
                    respHeaders.add("Location", OAuthLocalServerReceiver.this.getSuccessLandingPageUrl());
                    httpExchange.sendResponseHeaders(302, -1L);
                } else {
                    respHeaders.add("Location", OAuthLocalServerReceiver.this.getFailureLandingPageUrl());
                    httpExchange.sendResponseHeaders(302, -1L);
                }
                httpExchange.close();
            }
            finally {
                OAuthLocalServerReceiver.this.getWaitUnlessSignaled().release();
            }
        }

        private final Map<String, String> queryToMap(String query) {
            if (query == null) {
                return MapsKt.emptyMap();
            }
            Map result = new LinkedHashMap();
            String[] stringArray = new String[]{"&"};
            List parts = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String part : parts) {
                String[] stringArray2 = new String[]{"="};
                List pair = StringsKt.split$default((CharSequence)part, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                if (pair.size() > 1) {
                    result.put(pair.get(0), pair.get(1));
                    continue;
                }
                result.put(pair.get(0), "");
            }
            return result;
        }
    }
}

