/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols.ui;

import com.google.common.collect.Lists;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TrimLeftFilePathSplittingPolicy
extends FilePathSplittingPolicy {
    TrimLeftFilePathSplittingPolicy() {
    }

    public String getPresentableName(@NotNull File filePath, int length) {
        String current;
        String path = filePath.getPath();
        if (path.length() <= length) {
            return path;
        }
        String name = filePath.getName();
        int nameLength = name.length();
        String ellipsis = "...";
        if (length < nameLength) {
            return ellipsis;
        }
        if (length == nameLength) {
            return name;
        }
        List<String> partsInReverse = TrimLeftFilePathSplittingPolicy.getPartsInReverse(filePath);
        int partsCount = partsInReverse.size();
        String last = partsInReverse.get(partsCount - 1);
        List<String> parts = new ArrayList(partsCount);
        int currentLength = last.length() + ellipsis.length();
        if (currentLength + nameLength > length) {
            return name;
        }
        for (int i = 0; i < partsCount - 1 && (currentLength += (current = partsInReverse.get(i)).length()) < length; ++i) {
            parts.add(current);
        }
        if (parts.size() > 1) {
            parts = Lists.reverse(parts);
        }
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(last);
        buffer.append(ellipsis);
        for (String part : parts) {
            buffer.append(part);
        }
        return buffer.toString();
    }

    @NotNull
    private static List<String> getPartsInReverse(@NotNull File filePath) {
        ArrayList<String> result = new ArrayList<String>();
        File current = filePath;
        while (current != null) {
            String fileName = TrimLeftFilePathSplittingPolicy.getFileName(current);
            if (!fileName.isEmpty()) {
                result.add(fileName);
            }
            if ((current = current.getParentFile()) == null) continue;
            result.add(File.separator);
        }
        return result;
    }

    @NotNull
    private static String getFileName(@NotNull File filePath) {
        String result = filePath.getName();
        if (!result.isEmpty()) {
            return result;
        }
        String path = filePath.getPath();
        return path.substring(0, path.length() - 1);
    }
}

