/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.annotations.NotNull;

public class AndroidManifestSetupStep
extends ApkModuleSetupStep {
    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) throws Exception {
        VirtualFile apkRoot = ApkFileSystem.getInstance().getRootByLocal(context.getApkFile());
        if (apkRoot == null) {
            throw new IOException(String.format("Failed to read APK file '%1$s'", AndroidManifestSetupStep.getApkFilePath(context)));
        }
        VirtualFile manifestFile = apkRoot.findChild("AndroidManifest.xml");
        if (manifestFile == null) {
            throw new FileNotFoundException(String.format("Failed to find manifest from APK file '%1$s'", AndroidManifestSetupStep.getApkFilePath(context)));
        }
        File rootFolderPath = context.getProjectRootFolderPath();
        File manifestPath = new File(rootFolderPath, "AndroidManifest.xml");
        FileUtil.writeToFile((File)manifestPath, (byte[])manifestFile.contentsToByteArray());
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)ImmutableList.of((Object)manifestPath));
        this.setApplicationPackage(context);
    }

    @VisibleForTesting
    void setApplicationPackage(@NotNull ApkSetupContext context) {
        ApkFacet apkFacet = context.getApkFacet();
        assert (apkFacet != null);
        Manifest manifest = this.getManifest(context);
        ((ApkFacetConfiguration)apkFacet.getConfiguration()).APP_PACKAGE = (String)manifest.getPackage().getValue();
        ((ApkFacetConfiguration)apkFacet.getConfiguration()).DEBUGGABLE = (String)manifest.getApplication().getDebuggable().getValue();
    }

    @NotNull
    private static String getApkFilePath(@NotNull ApkSetupContext context) {
        return VfsUtilCore.virtualToIoFile((VirtualFile)context.getApkFile()).getPath();
    }
}

