/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkImportPathProperty;
import com.android.tools.idea.apk.reload.ApkReloader;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkReloadNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project myProject, @NotNull VirtualFile file) {
        if (!((Boolean)StudioFlags.APK_DEBUG_RELOAD.get()).booleanValue()) {
            return null;
        }
        if (!"apk".equals(file.getExtension()) || !Util.isApkProject(myProject)) {
            return null;
        }
        VirtualFile projectBaseDir = myProject.getBaseDir();
        if (projectBaseDir == null || !Util.isFileInDir(projectBaseDir, file)) {
            return null;
        }
        String prevImportPath = ApkImportPathProperty.getPath(myProject);
        Long prevImportTimestamp = ApkImportPathProperty.getTimestamp(myProject);
        if (prevImportPath == null || prevImportTimestamp == null) {
            return null;
        }
        VirtualFile apkFile = LocalFileSystem.getInstance().findFileByPath(prevImportPath);
        if (apkFile == null || apkFile.getTimeStamp() == prevImportTimestamp.longValue()) {
            return null;
        }
        ReloadApkInEditorAction action = new ReloadApkInEditorAction(file, myProject);
        return editor -> {
            MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
            panel.setText("The APK you imported has changed");
            panel.addToLinksPanel((Component)((Object)new ReloadApkHyperlinkLabel(action, panel.getBackground())));
            return panel;
        };
    }

    public static class ReloadApkInEditorAction
    extends AnAction
    implements NotificationListener,
    HyperlinkListener {
        @NotNull
        private final VirtualFile myApkFile;
        private final Project myProject;
        private final EditorNotifications myEditorNotifications;

        public ReloadApkInEditorAction(@NotNull VirtualFile apkFile, Project project) {
            this.myApkFile = apkFile;
            this.myProject = project;
            this.myEditorNotifications = EditorNotifications.getInstance((Project)this.myProject);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.reloadApk();
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            this.hyperlinkUpdate(event);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.reloadApk();
            }
        }

        public void reloadApk() {
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Import New APK", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    assert (this.myProject != null);
                    ApkReloader reloader = new ApkReloader(this.myProject, indicator);
                    reloader.reloadSameFile(myApkFile);
                    myEditorNotifications.updateNotifications(myApkFile);
                }
            });
        }
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final List<Component> myLinkComponents = new ArrayList<Component>();

        MyEditorNotificationPanel() {
        }

        void addToLinksPanel(@NotNull Component component) {
            this.myLinksPanel.add(component);
            this.myLinkComponents.add(component);
        }

        @VisibleForTesting
        @NotNull
        List<Component> getLinkComponents() {
            return this.myLinkComponents;
        }
    }

    @VisibleForTesting
    static class ReloadApkHyperlinkLabel
    extends HyperlinkLabel {
        ReloadApkHyperlinkLabel(@NotNull ReloadApkInEditorAction action, @NotNull Color background) {
            super("Import new APK", background);
            this.addHyperlinkListener(action);
        }

        protected void fireHyperlinkEvent(@Nullable InputEvent inputEvent) {
            super.fireHyperlinkEvent(inputEvent);
        }
    }
}

