/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.LibraryUpdates;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.FolderOrSharedObjectFileChooserFactory;
import com.android.tools.idea.apk.symbols.DebugSymbolsUpdater;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.apk.symbols.SharedObjectFileFinder;
import com.android.tools.idea.apk.symbols.SourceFoldersUpdater;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class AddSymbolsForAllLibrariesAction
extends AnAction
implements NotificationListener,
HyperlinkListener {
    @NotNull
    private final ApkFacet myApkFacet;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myApkFile;
    @NotNull
    private final SharedObjectFileFinder mySharedObjectFileFinder;
    @NotNull
    private final List<NativeLibrary> myLibrariesMissingSymbols;
    @NotNull
    private final FolderOrSharedObjectFileChooserFactory myChooserFactory;
    @NotNull
    private final DebugSymbolsUpdater myDebugSymbolsUpdater;
    @NotNull
    private final LibraryUpdates myLibraryUpdates;
    @NotNull
    private final EditorNotifications myEditorNotifications;
    @NotNull
    private final AndroidNotification myAndroidNotification;
    @NotNull
    private final SourceFoldersUpdater mySourceFoldersUpdater;
    private static final String NOTIFICATION_TITLE = "APK Debugging";

    public AddSymbolsForAllLibrariesAction(@NotNull ApkFacet apkFacet, @NotNull VirtualFile apkFile, @NotNull List<NativeLibrary> librariesMissingSymbols) {
        this(apkFacet, apkFile, librariesMissingSymbols, apkFacet.getModule().getProject(), new SharedObjectFileFinder(), new FolderOrSharedObjectFileChooserFactory(), new DebugSymbolsUpdater(), new SourceFoldersUpdater(), LibraryUpdates.getInstance(apkFacet.getModule().getProject()), EditorNotifications.getInstance((Project)apkFacet.getModule().getProject()), AndroidNotification.getInstance((Project)apkFacet.getModule().getProject()));
    }

    @VisibleForTesting
    public AddSymbolsForAllLibrariesAction(@NotNull ApkFacet apkFacet, @NotNull VirtualFile apkFile, @NotNull List<NativeLibrary> librariesMissingSymbols, @NotNull Project project, @NotNull SharedObjectFileFinder sharedObjectFileFinder, @NotNull FolderOrSharedObjectFileChooserFactory chooserFactory, @NotNull DebugSymbolsUpdater debugSymbolsUpdater, @NotNull SourceFoldersUpdater sourceFoldersUpdater, @NotNull LibraryUpdates libraryUpdates, @NotNull EditorNotifications editorNotifications, @NotNull AndroidNotification androidNotification) {
        super("All Libraries");
        this.myApkFacet = apkFacet;
        this.myApkFile = apkFile;
        this.myLibrariesMissingSymbols = librariesMissingSymbols;
        this.myProject = project;
        this.mySharedObjectFileFinder = sharedObjectFileFinder;
        this.myChooserFactory = chooserFactory;
        this.myDebugSymbolsUpdater = debugSymbolsUpdater;
        this.mySourceFoldersUpdater = sourceFoldersUpdater;
        this.myLibraryUpdates = libraryUpdates;
        this.myEditorNotifications = editorNotifications;
        this.myAndroidNotification = androidNotification;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.addSymbols();
    }

    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
        this.hyperlinkUpdate(event);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.addSymbols();
        }
    }

    private void addSymbols() {
        FileOrFolderChooser chooser = this.myChooserFactory.create(this.myApkFacet);
        VirtualFile[] chosen = chooser.choose(this.myProject);
        if (chosen.length == 0) {
            return;
        }
        for (NativeLibrary library : this.myLibrariesMissingSymbols) {
            AsyncResult<List<SharedObjectFile>> callback = this.mySharedObjectFileFinder.findSharedObjectFiles(chosen, library, this.myProject);
            callback.doWhenDone(() -> {
                List result = (List)callback.getResult();
                assert (result != null);
                this.attach(library, result);
            }).doWhenRejected(() -> {
                Throwable error = callback.getUnexpectedError();
                if (error != null) {
                    String message = "Adding symbol files for " + library.name + ":<br/> - Unexpected error: " + error.getMessage();
                    this.notifyUser(message, NotificationType.ERROR);
                }
            });
        }
    }

    private void attach(@NotNull NativeLibrary library, @NotNull List<SharedObjectFile> files) {
        AsyncResult<DebugSymbolsUpdater.UpdateResult> callback = this.myDebugSymbolsUpdater.updateDebugSymbolsInLibrary(files, library, this.myApkFacet);
        callback.doWhenDone(() -> {
            DebugSymbolsUpdater.UpdateResult result = (DebugSymbolsUpdater.UpdateResult)callback.getResult();
            assert (result != null);
            this.myLibraryUpdates.notifyLibrariesChanged(Collections.singletonList(library));
            this.myEditorNotifications.updateNotifications(this.myApkFile);
            NotificationType notificationType = NotificationType.INFORMATION;
            StringBuilder buffer = new StringBuilder();
            buffer.append("Adding symbol files for ").append(library.name).append(":");
            if (!result.addedFiles.isEmpty()) {
                for (DebuggableSharedObjectFile file : result.addedFiles) {
                    buffer.append("<br/> - ").append("Added: ").append(FileUtil.toSystemDependentName((String)file.path));
                }
                this.mySourceFoldersUpdater.updateSourceFolders(this.myApkFacet);
            } else {
                buffer.append("<br/> No new symbol files were added");
                notificationType = NotificationType.WARNING;
            }
            this.notifyUser(buffer.toString(), notificationType);
        }).doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            if (error != null) {
                String message = "Adding symbol files for " + library.name + ":<br/> - Unexpected error: " + error.getMessage();
                this.notifyUser(message, NotificationType.ERROR);
            }
        });
    }

    private void notifyUser(@NotNull String text, @NotNull NotificationType notificationType) {
        this.myAndroidNotification.showBalloon(NOTIFICATION_TITLE, text, notificationType);
    }
}

