/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkFileWatcher
implements Disposable {
    @Nullable
    private LocalFileSystem.WatchRequest myWatchRequest;
    @Nullable
    private VirtualFileListener myFileListener;

    public void startWatching(final @NotNull String path, final @NotNull Runnable runnable) {
        this.stopWatching();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(path, false);
        this.myFileListener = new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event.getFile().getPath().equals(path)) {
                    runnable.run();
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event.getFile().getPath().equals(path)) {
                    runnable.run();
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event.getFile().getPath().equals(path)) {
                    runnable.run();
                }
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(this.myFileListener);
    }

    public void stopWatching() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
            this.myWatchRequest = null;
        }
        if (this.myFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.myFileListener);
        }
    }

    public void dispose() {
        this.stopWatching();
    }
}

