/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.util;

import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Image;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"DATA_IMAGE_PREFIX", "", "convertLogoUriToIcon", "Landroidx/compose/ui/graphics/ImageBitmap;", "logoUri", "extractPngBytes", "", "aiplugin.ij-platform"})
public final class IconUtilsKt {
    @NotNull
    public static final String DATA_IMAGE_PREFIX = "data:image/png;base64,";

    @Nullable
    public static final ImageBitmap convertLogoUriToIcon(@Nullable String logoUri) {
        ImageBitmap imageBitmap;
        try {
            ImageBitmap bitmap;
            byte[] pngBytes = IconUtilsKt.extractPngBytes(logoUri);
            imageBitmap = pngBytes != null ? (bitmap = SkiaImageAsset_skikoKt.toComposeImageBitmap((Image)Image.Companion.makeFromEncoded(pngBytes))) : null;
        }
        catch (Exception exception) {
            imageBitmap = null;
        }
        return imageBitmap;
    }

    @VisibleForTesting
    @Nullable
    public static final byte[] extractPngBytes(@Nullable String logoUri) {
        String string = logoUri;
        return (string != null ? StringsKt.startsWith$default((String)string, (String)DATA_IMAGE_PREFIX, (boolean)false, (int)2, null) : false) ? Base64.getDecoder().decode(StringsKt.removePrefix((String)logoUri, (CharSequence)DATA_IMAGE_PREFIX)) : null;
    }
}

