/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.annotation.GuardedBy;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.Citation;
import com.google.api.services.cloudcode_pa.v1internal.model.Suggestion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.tools.intellij.aiplugin.recitation.AcceptedSuggestion;
import com.google.tools.intellij.aiplugin.recitation.RecitationLogService;
import com.google.tools.intellij.aiplugin.recitation.RecitationTrackingService;
import com.google.tools.intellij.aiplugin.recitation.RecitationUtils;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 R2\u00020\u0001:\u0005OPQRSB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ&\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J2\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u001e\u0010+\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012J*\u0010/\u001a\u0004\u0018\u00010'2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0011H\u0002J?\u00105\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)\u0018\u0001062\u0006\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020)2\b\u00109\u001a\u0004\u0018\u00010)2\b\u0010:\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u0010;J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0006\u0010=\u001a\u00020\u0005J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00060?2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u0002020A2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u0005H\u0002J\u000e\u0010C\u001a\u00020\u00162\u0006\u0010%\u001a\u00020$J\u0014\u0010D\u001a\u00020\u00162\f\u0010E\u001a\b\u0012\u0004\u0012\u00020$0\u001fJ\u0016\u0010F\u001a\u00020\u00162\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\fR(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006T"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService;", "", "()V", "acceptedSuggestions", "Lcom/google/common/collect/SetMultimap;", "", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$AcceptedCitations;", "getAcceptedSuggestions$annotations", "getAcceptedSuggestions", "()Lcom/google/common/collect/SetMultimap;", "citations", "", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$DetectedCitations;", "getCitations$annotations", "getCitations", "()Ljava/util/Map;", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "", "getLineOffsets", "(Ljava/lang/CharSequence;)Lcom/intellij/diff/tools/util/text/LineOffsets;", "addAcceptedSuggestion", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestion", "Lcom/google/api/services/cloudcode_pa/v1internal/model/Suggestion;", "acceptedSuggestion", "Lcom/google/tools/intellij/aiplugin/recitation/AcceptedSuggestion;", "filePath", "content", "", "Lcom/android/tools/idea/studiobot/Citation;", "addCitationsToCache", "clearCacheIfNeeded", "createCitationInstance", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationInstance;", "citation", "offsets", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationOffsets;", "citationStartIndex", "", "citationEndIndex", "detectCitations", "documentModificationStamp", "", "documentText", "getOffsets", "suggestionText", "unchangedRange", "Lcom/intellij/diff/util/Range;", "suggestionLineOffsets", "documentLineOffsets", "getOverlap", "Lkotlin/Pair;", "startIndex1", "endIndex1", "startIndex2", "endIndex2", "(IILjava/lang/Integer;Ljava/lang/Integer;)Lkotlin/Pair;", "getPromptCitationsFromCache", "editorFilePath", "getSuggestionsFromCache", "", "getUnchangedRanges", "", "completionText", "removeCitation", "removePromptCitation", "currentPromptCitations", "renameFile", "oldPath", "newPath", "stopTracking", "editor", "Lcom/intellij/openapi/editor/Editor;", "updateCitations", "", "newCitations", "AcceptedCitations", "CitationInstance", "CitationOffsets", "Companion", "DetectedCitations", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecitationTrackingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationTrackingService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,389:1\n40#2,3:390\n40#2,3:393\n40#2,3:396\n295#3,2:399\n295#3,2:401\n774#3:403\n865#3,2:404\n*S KotlinDebug\n*F\n+ 1 RecitationTrackingService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService\n*L\n188#1:390,3\n189#1:393,3\n201#1:396,3\n233#1:399,2\n249#1:401,2\n280#1:403\n280#1:404,2\n*E\n"})
public final class RecitationTrackingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @GuardedBy(value="this")
    @NotNull
    private final SetMultimap<String, AcceptedCitations> acceptedSuggestions;
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, DetectedCitations> citations;
    public static final int $stable = 8;

    public RecitationTrackingService() {
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        this.acceptedSuggestions = (SetMultimap)hashMultimap;
        this.citations = new LinkedHashMap();
    }

    @NotNull
    public final SetMultimap<String, AcceptedCitations> getAcceptedSuggestions() {
        return this.acceptedSuggestions;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAcceptedSuggestions$annotations() {
    }

    @NotNull
    public final Map<String, DetectedCitations> getCitations() {
        return this.citations;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCitations$annotations() {
    }

    @NotNull
    public final DetectedCitations detectCitations(@NotNull String filePath, long documentModificationStamp, @NotNull CharSequence documentText) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        List citations2 = new ArrayList();
        for (AcceptedCitations acceptedSuggestion : this.getSuggestionsFromCache(filePath)) {
            String suggestionText = acceptedSuggestion.getSuggestionText();
            for (Range unchangedRange : this.getUnchangedRanges(documentText, suggestionText)) {
                if (this.getOffsets(suggestionText, unchangedRange, this.getLineOffsets(suggestionText), this.getLineOffsets(documentText)) == null) continue;
                for (Citation citation : acceptedSuggestion.getCitations()) {
                    CitationOffsets offsets;
                    CitationInstance citationInstance = this.createCitationInstance(citation, filePath, offsets, citation.getRange().getStartOffset(), citation.getRange().getEndOffset());
                    if (citationInstance == null) continue;
                    citations2.add(citationInstance);
                }
            }
        }
        return new DetectedCitations(filePath, documentModificationStamp, citations2);
    }

    private final CitationInstance createCitationInstance(Citation citation, String filePath, CitationOffsets offsets, int citationStartIndex, int citationEndIndex) {
        Pair<Integer, Integer> pair = this.getOverlap(offsets.getStartOffsetInSuggestionText(), offsets.getEndOffsetInSuggestionText(), citationStartIndex, citationEndIndex);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int overlapStart = ((Number)pair2.component1()).intValue();
        int overlapEnd = ((Number)pair2.component2()).intValue();
        return new CitationInstance(citation, filePath, new TextRange(offsets.getStartOffsetInDocumentText() + overlapStart, offsets.getStartOffsetInDocumentText() + overlapEnd));
    }

    public final synchronized boolean updateCitations(@NotNull DetectedCitations newCitations) {
        long cachedEditorModificationTimestamp;
        Intrinsics.checkNotNullParameter((Object)newCitations, (String)"newCitations");
        DetectedCitations detectedCitations = this.citations.get(newCitations.getFilePath());
        long l2 = cachedEditorModificationTimestamp = detectedCitations != null ? detectedCitations.getDocumentModificationStamp() : 0L;
        if (newCitations.getDocumentModificationStamp() >= cachedEditorModificationTimestamp) {
            if (!((Collection)newCitations.getCitations()).isEmpty()) {
                this.citations.put(newCitations.getFilePath(), newCitations);
            } else {
                this.citations.remove(newCitations.getFilePath());
            }
            return true;
        }
        return false;
    }

    public final void addAcceptedSuggestion(@NotNull VirtualFile file, @NotNull AcceptedSuggestion acceptedSuggestion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)acceptedSuggestion, (String)"acceptedSuggestion");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.addAcceptedSuggestion(string, acceptedSuggestion.toSuggestion());
    }

    public final void addAcceptedSuggestion(@NotNull VirtualFile file, @Nullable Suggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.addAcceptedSuggestion(string, suggestion);
    }

    public final void addAcceptedSuggestion(@NotNull String filePath, @Nullable Suggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (suggestion == null) {
            return;
        }
        boolean $i$f$service = false;
        Class<RecitationUtils> serviceClass$iv = RecitationUtils.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        $i$f$service = false;
        serviceClass$iv = RecitationUtils.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List acceptedCitations = CollectionsKt.plus((Collection)((RecitationUtils)object).buildCitationsList(suggestion.getCitations()), (Iterable)((RecitationUtils)object2).buildPromptCitationsList(suggestion.getPromptCitations()));
        String string = suggestion.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContent(...)");
        this.addAcceptedSuggestion(filePath, string, acceptedCitations);
    }

    public final void addAcceptedSuggestion(@NotNull String filePath, @NotNull String content2, @NotNull List<? extends Citation> citations2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter(citations2, (String)"citations");
        if (citations2.isEmpty()) {
            return;
        }
        this.addCitationsToCache(filePath, content2, citations2);
        boolean $i$f$service = false;
        Class<RecitationLogService> serviceClass$iv = RecitationLogService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((RecitationLogService)object).logCitations(content2, citations2, filePath);
    }

    private final synchronized void addCitationsToCache(String filePath, String content2, List<? extends Citation> citations2) {
        this.acceptedSuggestions.get((Object)filePath).add(new AcceptedCitations(filePath, content2, CollectionsKt.toMutableList((Collection)citations2)));
    }

    public final synchronized void stopTracking(@NotNull Editor editor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Object object = editor2.getVirtualFile();
            if (object == null || (object = object.getPath()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.acceptedSuggestions.removeAll(it);
            this.citations.remove(it);
        }
    }

    public final synchronized void removeCitation(@NotNull CitationInstance citation) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)citation, (String)"citation");
            Set suggestions = this.acceptedSuggestions.get((Object)citation.getFilePath());
            Intrinsics.checkNotNull((Object)suggestions);
            Iterable $this$firstOrNull$iv = suggestions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AcceptedCitations it = (AcceptedCitations)element$iv;
                boolean bl = false;
                if (!it.getCitations().contains(citation.getCitation())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        AcceptedCitations acceptedCitations = v0;
        if (acceptedCitations == null) {
            return;
        }
        AcceptedCitations currentSuggestion = acceptedCitations;
        currentSuggestion.getCitations().remove(citation.getCitation());
        Object object = this.citations.get(citation.getFilePath());
        if (object != null && (object = ((DetectedCitations)object).getCitations()) != null) {
            object.remove(citation);
        }
        this.clearCacheIfNeeded(currentSuggestion);
    }

    public final synchronized void removePromptCitation(@NotNull List<CitationInstance> currentPromptCitations) {
        Intrinsics.checkNotNullParameter(currentPromptCitations, (String)"currentPromptCitations");
        for (CitationInstance promptCitation : currentPromptCitations) {
            AcceptedCitations currentSuggestion;
            Object v0;
            block3: {
                Set suggestions = this.acceptedSuggestions.get((Object)promptCitation.getFilePath());
                Intrinsics.checkNotNull((Object)suggestions);
                Iterable $this$firstOrNull$iv = suggestions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AcceptedCitations it = (AcceptedCitations)element$iv;
                    boolean bl = false;
                    if (!it.getCitations().contains(promptCitation.getCitation())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((AcceptedCitations)v0 == null) continue;
            currentSuggestion.getCitations().remove(promptCitation.getCitation());
            Object object = this.citations.get(promptCitation.getFilePath());
            if (object != null && (object = ((DetectedCitations)object).getCitations()) != null) {
                object.remove(promptCitation);
            }
            this.clearCacheIfNeeded(currentSuggestion);
        }
    }

    private final void clearCacheIfNeeded(AcceptedCitations suggestion) {
        String filePath = suggestion.getFilePath();
        this.acceptedSuggestions.get((Object)filePath).removeIf(arg_0 -> RecitationTrackingService.clearCacheIfNeeded$lambda$0(clearCacheIfNeeded.1.INSTANCE, arg_0));
        Object object = this.citations.get(filePath);
        boolean bl = object != null && (object = ((DetectedCitations)object).getCitations()) != null ? object.isEmpty() : false;
        if (bl) {
            this.citations.remove(filePath);
        }
    }

    private final synchronized Set<AcceptedCitations> getSuggestionsFromCache(String editorFilePath) {
        Set set = this.acceptedSuggestions.get((Object)editorFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"get(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<CitationInstance> getPromptCitationsFromCache(@NotNull String editorFilePath) {
        List list;
        List list2;
        List<CitationInstance> list3;
        Intrinsics.checkNotNullParameter((Object)editorFilePath, (String)"editorFilePath");
        DetectedCitations detectedCitations = this.citations.get(editorFilePath);
        if (detectedCitations != null && (list3 = detectedCitations.getCitations()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = list3;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CitationInstance it = (CitationInstance)element$iv$iv;
                boolean bl = false;
                if (!(it.getCitation() instanceof Citation.LocalFile || it.getCitation() instanceof Citation.RemoteRepository)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final synchronized void renameFile(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        Set suggestions = this.acceptedSuggestions.get((Object)oldPath);
        if (suggestions.isEmpty()) {
            return;
        }
        for (AcceptedCitations suggestion : suggestions) {
            Set set = this.acceptedSuggestions.get((Object)newPath);
            Intrinsics.checkNotNull((Object)suggestion);
            set.add(AcceptedCitations.copy$default(suggestion, newPath, null, null, 6, null));
        }
        this.acceptedSuggestions.removeAll((Object)oldPath);
        this.citations.remove(oldPath);
    }

    private final Iterable<Range> getUnchangedRanges(CharSequence documentText, String completionText) {
        return RangesBuilder.compareLines((CharSequence)documentText, (CharSequence)completionText, (LineOffsets)this.getLineOffsets(documentText), (LineOffsets)this.getLineOffsets(completionText)).iterateUnchanged();
    }

    private final CitationOffsets getOffsets(String suggestionText, Range unchangedRange, LineOffsets suggestionLineOffsets, LineOffsets documentLineOffsets) {
        int startOffsetInSuggestionText = suggestionLineOffsets.getLineStart(unchangedRange.start2);
        int endOffsetInSuggestionText = suggestionLineOffsets.getLineEnd(unchangedRange.end2 - 1);
        String string = suggestionText.substring(startOffsetInSuggestionText, endOffsetInSuggestionText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        int startOffsetInDocument = documentLineOffsets.getLineStart(unchangedRange.start1) - startOffsetInSuggestionText;
        return new CitationOffsets(startOffsetInDocument, startOffsetInSuggestionText, endOffsetInSuggestionText);
    }

    private final Pair<Integer, Integer> getOverlap(int startIndex1, int endIndex1, Integer startIndex2, Integer endIndex2) {
        int endIndex2Int;
        Integer n = startIndex2;
        int startIndex2Int = n != null ? n : 0;
        Integer n2 = endIndex2;
        int n3 = endIndex2Int = n2 != null ? n2 : 0;
        if (startIndex1 > endIndex2Int || startIndex2Int > endIndex1) {
            return null;
        }
        return new Pair((Object)Math.max(startIndex1, startIndex2Int), (Object)Math.min(endIndex1, endIndex2Int));
    }

    private final LineOffsets getLineOffsets(CharSequence $this$lineOffsets) {
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)$this$lineOffsets);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        return lineOffsets;
    }

    private static final boolean clearCacheIfNeeded$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$AcceptedCitations;", "", "filePath", "", "suggestionText", "citations", "", "Lcom/android/tools/idea/studiobot/Citation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getCitations", "()Ljava/util/List;", "getFilePath", "()Ljava/lang/String;", "getSuggestionText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class AcceptedCitations {
        @NotNull
        private final String filePath;
        @NotNull
        private final String suggestionText;
        @NotNull
        private final List<Citation> citations;
        public static final int $stable = 8;

        public AcceptedCitations(@NotNull String filePath, @NotNull String suggestionText, @NotNull List<Citation> citations2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)suggestionText, (String)"suggestionText");
            Intrinsics.checkNotNullParameter(citations2, (String)"citations");
            this.filePath = filePath;
            this.suggestionText = suggestionText;
            this.citations = citations2;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final String getSuggestionText() {
            return this.suggestionText;
        }

        @NotNull
        public final List<Citation> getCitations() {
            return this.citations;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final String component2() {
            return this.suggestionText;
        }

        @NotNull
        public final List<Citation> component3() {
            return this.citations;
        }

        @NotNull
        public final AcceptedCitations copy(@NotNull String filePath, @NotNull String suggestionText, @NotNull List<Citation> citations2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)suggestionText, (String)"suggestionText");
            Intrinsics.checkNotNullParameter(citations2, (String)"citations");
            return new AcceptedCitations(filePath, suggestionText, citations2);
        }

        public static /* synthetic */ AcceptedCitations copy$default(AcceptedCitations acceptedCitations, String string, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = acceptedCitations.filePath;
            }
            if ((n & 2) != 0) {
                string2 = acceptedCitations.suggestionText;
            }
            if ((n & 4) != 0) {
                list = acceptedCitations.citations;
            }
            return acceptedCitations.copy(string, string2, list);
        }

        @NotNull
        public String toString() {
            return "AcceptedCitations(filePath=" + this.filePath + ", suggestionText=" + this.suggestionText + ", citations=" + this.citations + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + this.suggestionText.hashCode();
            result2 = result2 * 31 + ((Object)this.citations).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AcceptedCitations)) {
                return false;
            }
            AcceptedCitations acceptedCitations = (AcceptedCitations)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)acceptedCitations.filePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestionText, (Object)acceptedCitations.suggestionText)) {
                return false;
            }
            return Intrinsics.areEqual(this.citations, acceptedCitations.citations);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationInstance;", "", "citation", "Lcom/android/tools/idea/studiobot/Citation;", "filePath", "", "rangeInDocument", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/android/tools/idea/studiobot/Citation;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getCitation", "()Lcom/android/tools/idea/studiobot/Citation;", "getFilePath", "()Ljava/lang/String;", "getRangeInDocument", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class CitationInstance {
        @NotNull
        private final Citation citation;
        @NotNull
        private final String filePath;
        @NotNull
        private final TextRange rangeInDocument;
        public static final int $stable = 8;

        public CitationInstance(@NotNull Citation citation, @NotNull String filePath, @NotNull TextRange rangeInDocument) {
            Intrinsics.checkNotNullParameter((Object)citation, (String)"citation");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)rangeInDocument, (String)"rangeInDocument");
            this.citation = citation;
            this.filePath = filePath;
            this.rangeInDocument = rangeInDocument;
        }

        @NotNull
        public final Citation getCitation() {
            return this.citation;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final TextRange getRangeInDocument() {
            return this.rangeInDocument;
        }

        @NotNull
        public final Citation component1() {
            return this.citation;
        }

        @NotNull
        public final String component2() {
            return this.filePath;
        }

        @NotNull
        public final TextRange component3() {
            return this.rangeInDocument;
        }

        @NotNull
        public final CitationInstance copy(@NotNull Citation citation, @NotNull String filePath, @NotNull TextRange rangeInDocument) {
            Intrinsics.checkNotNullParameter((Object)citation, (String)"citation");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)rangeInDocument, (String)"rangeInDocument");
            return new CitationInstance(citation, filePath, rangeInDocument);
        }

        public static /* synthetic */ CitationInstance copy$default(CitationInstance citationInstance, Citation citation, String string, TextRange textRange, int n, Object object) {
            if ((n & 1) != 0) {
                citation = citationInstance.citation;
            }
            if ((n & 2) != 0) {
                string = citationInstance.filePath;
            }
            if ((n & 4) != 0) {
                textRange = citationInstance.rangeInDocument;
            }
            return citationInstance.copy(citation, string, textRange);
        }

        @NotNull
        public String toString() {
            return "CitationInstance(citation=" + this.citation + ", filePath=" + this.filePath + ", rangeInDocument=" + this.rangeInDocument + ")";
        }

        public int hashCode() {
            int result2 = this.citation.hashCode();
            result2 = result2 * 31 + this.filePath.hashCode();
            result2 = result2 * 31 + this.rangeInDocument.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CitationInstance)) {
                return false;
            }
            CitationInstance citationInstance = (CitationInstance)other;
            if (!Intrinsics.areEqual((Object)this.citation, (Object)citationInstance.citation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)citationInstance.filePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rangeInDocument, (Object)citationInstance.rangeInDocument);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationOffsets;", "", "startOffsetInDocumentText", "", "startOffsetInSuggestionText", "endOffsetInSuggestionText", "(III)V", "getEndOffsetInSuggestionText", "()I", "getStartOffsetInDocumentText", "getStartOffsetInSuggestionText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=1)
    public static final class CitationOffsets {
        private final int startOffsetInDocumentText;
        private final int startOffsetInSuggestionText;
        private final int endOffsetInSuggestionText;
        public static final int $stable;

        public CitationOffsets(int startOffsetInDocumentText, int startOffsetInSuggestionText, int endOffsetInSuggestionText) {
            this.startOffsetInDocumentText = startOffsetInDocumentText;
            this.startOffsetInSuggestionText = startOffsetInSuggestionText;
            this.endOffsetInSuggestionText = endOffsetInSuggestionText;
        }

        public final int getStartOffsetInDocumentText() {
            return this.startOffsetInDocumentText;
        }

        public final int getStartOffsetInSuggestionText() {
            return this.startOffsetInSuggestionText;
        }

        public final int getEndOffsetInSuggestionText() {
            return this.endOffsetInSuggestionText;
        }

        public final int component1() {
            return this.startOffsetInDocumentText;
        }

        public final int component2() {
            return this.startOffsetInSuggestionText;
        }

        public final int component3() {
            return this.endOffsetInSuggestionText;
        }

        @NotNull
        public final CitationOffsets copy(int startOffsetInDocumentText, int startOffsetInSuggestionText, int endOffsetInSuggestionText) {
            return new CitationOffsets(startOffsetInDocumentText, startOffsetInSuggestionText, endOffsetInSuggestionText);
        }

        public static /* synthetic */ CitationOffsets copy$default(CitationOffsets citationOffsets, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = citationOffsets.startOffsetInDocumentText;
            }
            if ((n4 & 2) != 0) {
                n2 = citationOffsets.startOffsetInSuggestionText;
            }
            if ((n4 & 4) != 0) {
                n3 = citationOffsets.endOffsetInSuggestionText;
            }
            return citationOffsets.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "CitationOffsets(startOffsetInDocumentText=" + this.startOffsetInDocumentText + ", startOffsetInSuggestionText=" + this.startOffsetInSuggestionText + ", endOffsetInSuggestionText=" + this.endOffsetInSuggestionText + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startOffsetInDocumentText);
            result2 = result2 * 31 + Integer.hashCode(this.startOffsetInSuggestionText);
            result2 = result2 * 31 + Integer.hashCode(this.endOffsetInSuggestionText);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CitationOffsets)) {
                return false;
            }
            CitationOffsets citationOffsets = (CitationOffsets)other;
            if (this.startOffsetInDocumentText != citationOffsets.startOffsetInDocumentText) {
                return false;
            }
            if (this.startOffsetInSuggestionText != citationOffsets.startOffsetInSuggestionText) {
                return false;
            }
            return this.endOffsetInSuggestionText == citationOffsets.endOffsetInSuggestionText;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$Companion;", "", "()V", "getInstance", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nRecitationTrackingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationTrackingService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,389:1\n30#2,2:390\n*S KotlinDebug\n*F\n+ 1 RecitationTrackingService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$Companion\n*L\n370#1:390,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecitationTrackingService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RecitationTrackingService> serviceClass$iv = RecitationTrackingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RecitationTrackingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$DetectedCitations;", "", "filePath", "", "documentModificationStamp", "", "citations", "", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationInstance;", "(Ljava/lang/String;JLjava/util/List;)V", "getCitations", "()Ljava/util/List;", "getDocumentModificationStamp", "()J", "getFilePath", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class DetectedCitations {
        @NotNull
        private final String filePath;
        private final long documentModificationStamp;
        @NotNull
        private final List<CitationInstance> citations;
        public static final int $stable = 8;

        public DetectedCitations(@NotNull String filePath, long documentModificationStamp, @NotNull List<CitationInstance> citations2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(citations2, (String)"citations");
            this.filePath = filePath;
            this.documentModificationStamp = documentModificationStamp;
            this.citations = citations2;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final long getDocumentModificationStamp() {
            return this.documentModificationStamp;
        }

        @NotNull
        public final List<CitationInstance> getCitations() {
            return this.citations;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final long component2() {
            return this.documentModificationStamp;
        }

        @NotNull
        public final List<CitationInstance> component3() {
            return this.citations;
        }

        @NotNull
        public final DetectedCitations copy(@NotNull String filePath, long documentModificationStamp, @NotNull List<CitationInstance> citations2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(citations2, (String)"citations");
            return new DetectedCitations(filePath, documentModificationStamp, citations2);
        }

        public static /* synthetic */ DetectedCitations copy$default(DetectedCitations detectedCitations, String string, long l2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = detectedCitations.filePath;
            }
            if ((n & 2) != 0) {
                l2 = detectedCitations.documentModificationStamp;
            }
            if ((n & 4) != 0) {
                list = detectedCitations.citations;
            }
            return detectedCitations.copy(string, l2, list);
        }

        @NotNull
        public String toString() {
            return "DetectedCitations(filePath=" + this.filePath + ", documentModificationStamp=" + this.documentModificationStamp + ", citations=" + this.citations + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.documentModificationStamp);
            result2 = result2 * 31 + ((Object)this.citations).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectedCitations)) {
                return false;
            }
            DetectedCitations detectedCitations = (DetectedCitations)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)detectedCitations.filePath)) {
                return false;
            }
            if (this.documentModificationStamp != detectedCitations.documentModificationStamp) {
                return false;
            }
            return Intrinsics.areEqual(this.citations, detectedCitations.citations);
        }
    }
}

