/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.Citation;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.recitation.RecitationGutterActionIconRenderer;
import com.google.tools.intellij.aiplugin.recitation.RecitationTrackingService;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationGutterService;", "", "()V", "addLineHighlighter", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentCaretLine", "", "tooltip", "", "currentPromptCitations", "", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationInstance;", "createTooltipText", "promptCitation", "getPromptCitationFilepath", "citation", "Lcom/android/tools/idea/studiobot/Citation;", "getPromptCitationRepositoryUrl", "isCurrentLineInsideCitation", "", "caretOffset", "promptCitationDisplay", "removeLineHighlighter", "render", "updateGutterRenderer", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRecitationGutterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationGutterService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationGutterService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n3829#2:124\n4344#2,2:125\n1869#3,2:127\n*S KotlinDebug\n*F\n+ 1 RecitationGutterService.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationGutterService\n*L\n103#1:124\n103#1:125,2\n104#1:127,2\n*E\n"})
public final class RecitationGutterService {
    public static final int $stable;

    public final void render(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        this.updateGutterRenderer(editor2);
    }

    private final void updateGutterRenderer(Editor editor2) {
        this.removeLineHighlighter(editor2);
        if (editor2.getDocument().getTextLength() <= 0) {
            return;
        }
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Object object = editor2.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Object path2 = object;
        List<RecitationTrackingService.CitationInstance> promptCitations = RecitationTrackingService.Companion.getInstance(project3).getPromptCitationsFromCache((String)path2);
        int currentCaretLine = editor2.getCaretModel().getLogicalPosition().line;
        Object tooltip2 = "";
        List currentPromptCitations = new ArrayList();
        for (RecitationTrackingService.CitationInstance promptCitation : promptCitations) {
            if (!this.isCurrentLineInsideCitation(editor2.getCaretModel().getOffset(), promptCitation)) continue;
            tooltip2 = (String)tooltip2 + this.createTooltipText(editor2, promptCitation);
            currentPromptCitations.add(promptCitation);
        }
        if (!((Collection)currentPromptCitations).isEmpty()) {
            tooltip2 = (String)tooltip2 + "<br>" + SmlIjBundle.message("aiplugin.product.name", new Object[0]);
            this.addLineHighlighter(editor2, currentCaretLine, (String)tooltip2, currentPromptCitations);
        }
    }

    private final boolean isCurrentLineInsideCitation(int caretOffset2, RecitationTrackingService.CitationInstance promptCitationDisplay) {
        return promptCitationDisplay.getRangeInDocument().contains(caretOffset2);
    }

    private final String createTooltipText(Editor editor2, RecitationTrackingService.CitationInstance promptCitation) {
        int citationStartLine = editor2.getDocument().getLineNumber(promptCitation.getRangeInDocument().getStartOffset());
        int citationStartOffset = promptCitation.getRangeInDocument().getStartOffset() - editor2.getDocument().getLineStartOffset(citationStartLine);
        int endOffset = Math.min(promptCitation.getRangeInDocument().getEndOffset(), editor2.getDocument().getTextLength());
        int citationEndLine = editor2.getDocument().getLineNumber(endOffset - 1);
        int citationEndOffset = promptCitation.getRangeInDocument().getEndOffset() - 1 - editor2.getDocument().getLineStartOffset(citationEndLine);
        String uri = this.getPromptCitationRepositoryUrl(promptCitation.getCitation());
        String uriLink = ((CharSequence)uri).length() == 0 ? "" : "<a href=\"" + uri + "\">" + uri + "</a>";
        Object[] objectArray = new Object[]{citationStartLine + 1, citationStartOffset, citationEndLine + 1, citationEndOffset, uriLink, this.getPromptCitationFilepath(promptCitation.getCitation())};
        return SmlIjBundle.message("ai.plugin.settings.prompt.recitation.tooltip", objectArray);
    }

    private final void addLineHighlighter(Editor editor2, int currentCaretLine, String tooltip2, List<RecitationTrackingService.CitationInstance> currentPromptCitations) {
        RecitationGutterActionIconRenderer renderer2 = new RecitationGutterActionIconRenderer(tooltip2, currentPromptCitations);
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addLineHighlighter(currentCaretLine, 6001, new TextAttributes());
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addLineHighlighter(...)");
        RangeHighlighter highlighter2 = rangeHighlighter;
        highlighter2.setGutterIconRenderer((GutterIconRenderer)renderer2);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeLineHighlighter(Editor editor2) {
        void $this$filterTo$iv$iv;
        RangeHighlighter[] rangeHighlighterArray = editor2.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$filter$iv = rangeHighlighterArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            if (!(it.getGutterIconRenderer() instanceof RecitationGutterActionIconRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            editor2.getMarkupModel().removeHighlighter(it);
        }
    }

    private final String getPromptCitationRepositoryUrl(Citation citation) {
        String string;
        Citation citation2 = citation;
        if (citation2 instanceof Citation.LocalFile) {
            string = "";
        } else if (citation2 instanceof Citation.RemoteRepository) {
            string = ((Citation.RemoteRepository)citation).getRepositoryUrl();
        } else {
            throw new RuntimeException("Invalid type of Citation");
        }
        return string;
    }

    private final String getPromptCitationFilepath(Citation citation) {
        String string;
        Citation citation2 = citation;
        if (citation2 instanceof Citation.LocalFile) {
            string = ((Citation.LocalFile)citation).getFilePath();
        } else if (citation2 instanceof Citation.RemoteRepository) {
            string = ((Citation.RemoteRepository)citation).getFilePath();
        } else {
            throw new RuntimeException("Invalid type of Citation");
        }
        return string;
    }
}

