/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.outlines.OutlinesData;
import com.google.tools.intellij.aiplugin.outlines.OutlinesDisplayManager;
import com.google.tools.intellij.aiplugin.outlines.OutlinesManager;
import com.google.tools.intellij.aiplugin.outlines.OutlinesMetricsTracker;
import com.google.tools.intellij.aiplugin.outlines.TriggerType;
import com.google.tools.intellij.aiplugin.outlines.ui.OutlinesGotItToolTip;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020\u000bJ\u0006\u0010,\u001a\u00020\u000bJ\b\u0010-\u001a\u00020*H\u0002J\b\u0010.\u001a\u00020*H\u0002J\b\u0010/\u001a\u00020*H\u0002J\b\u00100\u001a\u00020*H\u0002J\b\u00101\u001a\u00020*H\u0002J\u0006\u00102\u001a\u00020*J\u000e\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\rJ\u000e\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020\tJ\b\u00106\u001a\u00020*H\u0002J\u0012\u00107\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u00010\tH\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011\u00a8\u00069"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesTabController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "_currentFile", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/openapi/vfs/VirtualFile;", "_notificationState", "", "_uiState", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesData;", "currentFile", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentFile", "()Lkotlinx/coroutines/flow/StateFlow;", "notificationState", "outlinesDisplayManager", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesDisplayManager;", "outlinesManager", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager;", "outlinesMetricsTracker", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker;", "getProject", "()Lcom/intellij/openapi/project/Project;", "tabContent", "Lcom/intellij/ui/content/Content;", "tabTitle", "", "Lorg/jetbrains/annotations/Nls;", "tabTitleWithNotificationDot", "getTabTitleWithNotificationDot", "()Ljava/lang/String;", "tabTitleWithNotificationDot$delegate", "Lkotlin/Lazy;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "uiState", "getUiState", "dispose", "", "isOutlinesTabSelected", "isPanelOpened", "listenForFileChanges", "listenForOutlineStateChanges", "listenForTabSelectionChanges", "listenForToolWindowChanges", "listenForUiStateChanges", "openOutlinesTab", "outlinesData", "setCurrentFile", "file", "showOutlines", "updateCurrentFile", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlinesTabController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesTabController.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesTabController\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n230#2,5:225\n230#2,3:230\n233#2,2:234\n1#3:233\n*S KotlinDebug\n*F\n+ 1 OutlinesTabController.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesTabController\n*L\n169#1:225,5\n170#1:230,3\n170#1:234,2\n*E\n"})
public final class OutlinesTabController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final OutlinesManager outlinesManager;
    @NotNull
    private final OutlinesDisplayManager outlinesDisplayManager;
    @NotNull
    private final OutlinesMetricsTracker outlinesMetricsTracker;
    @Nullable
    private final ToolWindow toolWindow;
    @NotNull
    private final MutableStateFlow<OutlinesData> _uiState;
    @NotNull
    private final StateFlow<OutlinesData> uiState;
    @NotNull
    private final MutableStateFlow<VirtualFile> _currentFile;
    @NotNull
    private final StateFlow<VirtualFile> currentFile;
    @NotNull
    private final MutableStateFlow<Boolean> _notificationState;
    @NotNull
    private final StateFlow<Boolean> notificationState;
    @Nullable
    private Content tabContent;
    @NotNull
    private final String tabTitle;
    @NotNull
    private final Lazy tabTitleWithNotificationDot$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final String NOTIFICATION_DOT = "\u25cf";
    @NotNull
    private static final JBColor NOTIFICATION_COLOR = new JBColor(16747520, 16747520);

    public OutlinesTabController(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.outlinesManager = OutlinesManager.Companion.getInstance(this.project);
        this.outlinesDisplayManager = OutlinesDisplayManager.Companion.getInstance(this.project);
        this.outlinesMetricsTracker = OutlinesMetricsTracker.Companion.getInstance();
        this.toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("StudioBot");
        this._uiState = StateFlowKt.MutableStateFlow(null);
        this.uiState = FlowKt.asStateFlow(this._uiState);
        this._currentFile = StateFlowKt.MutableStateFlow(null);
        this.currentFile = FlowKt.asStateFlow(this._currentFile);
        this._notificationState = StateFlowKt.MutableStateFlow((Object)false);
        this.notificationState = FlowKt.asStateFlow(this._notificationState);
        this.tabTitle = SmlIjBundle.message("aiplugin.outlines.tab", new Object[0]);
        this.tabTitleWithNotificationDot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ OutlinesTabController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                String string = ColorUtil.toHtmlColor((Color)((Color)OutlinesTabController.access$getNOTIFICATION_COLOR$cp()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
                String htmlColor = string;
                return "<html>" + OutlinesTabController.access$getTabTitle$p(this.this$0) + " <font color='" + htmlColor + "'>\u25cf</font></html>";
            }
        }));
        this.listenForUiStateChanges();
        this.listenForOutlineStateChanges();
        this.listenForFileChanges();
        this.listenForToolWindowChanges();
        this.listenForTabSelectionChanges();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StateFlow<OutlinesData> getUiState() {
        return this.uiState;
    }

    @NotNull
    public final StateFlow<VirtualFile> getCurrentFile() {
        return this.currentFile;
    }

    private final String getTabTitleWithNotificationDot() {
        Lazy lazy = this.tabTitleWithNotificationDot$delegate;
        return (String)lazy.getValue();
    }

    private final void listenForUiStateChanges() {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this._uiState), (Function2)((Function2)new Function2<OutlinesData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ OutlinesTabController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OutlinesData uiState = (OutlinesData)this.L$0;
                        if (this.this$0.isOutlinesTabSelected()) {
                            OutlinesTabController.access$showOutlines(this.this$0);
                        } else {
                            OutlinesTabController.access$get_notificationState$p(this.this$0).setValue((Object)Boxing.boxBoolean((uiState != null && !uiState.getHasBeenSeen() && (uiState.getStatus() == OutlinesData.Status.UP_TO_DATE || uiState.getStatus() == OutlinesData.Status.OUTDATED) ? 1 : 0) != 0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OutlinesData p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    private final void listenForOutlineStateChanges() {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.outlinesManager.getOutlinesState()), (Function2)((Function2)new Function2<OutlinesData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ OutlinesTabController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        OutlinesData outlinesData;
                        ResultKt.throwOnFailure((Object)object);
                        OutlinesData outlinesData2 = outlinesData = (OutlinesData)this.L$0;
                        if (Intrinsics.areEqual((Object)(outlinesData2 != null ? outlinesData2.getFile() : null), (Object)OutlinesTabController.access$get_currentFile$p(this.this$0).getValue())) {
                            OutlinesTabController.access$get_uiState$p(this.this$0).setValue((Object)outlinesData);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OutlinesData p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    private final void listenForFileChanges() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ OutlinesTabController this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                OutlinesTabController.access$updateCurrentFile(this.this$0, file);
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (Intrinsics.areEqual((Object)OutlinesTabController.access$get_currentFile$p(this.this$0).getValue(), (Object)file)) {
                    OutlinesTabController.access$updateCurrentFile(this.this$0, null);
                }
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                OutlinesTabController.access$updateCurrentFile(this.this$0, event.getNewFile());
            }
        });
    }

    private final void listenForToolWindowChanges() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ OutlinesTabController this$0;
            {
                this.this$0 = $receiver;
            }

            public void toolWindowShown(ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"StudioBot") && this.this$0.isOutlinesTabSelected()) {
                    OutlinesTabController.access$getOutlinesMetricsTracker$p(this.this$0).trackOutlinesPanelOpened();
                    OutlinesTabController.access$showOutlines(this.this$0);
                }
            }
        });
    }

    private final void listenForTabSelectionChanges() {
        block0: {
            ContentManager contentManager;
            ToolWindow toolWindow = this.toolWindow;
            if (toolWindow == null || (contentManager = toolWindow.getContentManager()) == null) break block0;
            contentManager.addContentManagerListener(new ContentManagerListener(this){
                final /* synthetic */ OutlinesTabController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Intrinsics.areEqual((Object)event.getContent(), (Object)OutlinesTabController.access$getTabContent$p(this.this$0))) {
                        OutlinesTabController.access$getOutlinesMetricsTracker$p(this.this$0).trackOutlinesPanelOpened();
                        OutlinesTabController.access$showOutlines(this.this$0);
                    }
                }

                public void contentAdded(ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (OutlinesTabController.access$getTabContent$p(this.this$0) == null) {
                        String string = event.getContent().getDisplayName();
                        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)OutlinesTabController.access$getTabTitle$p(this.this$0), (boolean)false, (int)2, null) : false;
                        if (bl) {
                            OutlinesTabController.access$setTabContent$p(this.this$0, event.getContent());
                            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)OutlinesTabController.access$getNotificationState$p(this.this$0)), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ boolean Z$0;
                                final /* synthetic */ OutlinesTabController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            boolean showNotification = this.Z$0;
                                            Content content2 = OutlinesTabController.access$getTabContent$p(this.this$0);
                                            if (content2 != null) {
                                                content2.setDisplayName(showNotification ? OutlinesTabController.access$getTabTitleWithNotificationDot(this.this$0) : OutlinesTabController.access$getTabTitle$p(this.this$0));
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.Z$0 = (Boolean)value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            })), (CoroutineScope)OutlinesTabController.access$getCoroutineScope$p(this.this$0));
                            Function0 onTryIt2 = (Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ OutlinesTabController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.openOutlinesTab();
                                }
                            };
                            OutlinesGotItToolTip.INSTANCE.show(this.this$0.getProject(), this.this$0, (Function0<Unit>)onTryIt2);
                        }
                    }
                }

                public void contentRemoved(ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Intrinsics.areEqual((Object)event.getContent(), (Object)OutlinesTabController.access$getTabContent$p(this.this$0))) {
                        OutlinesTabController.access$setTabContent$p(this.this$0, null);
                    }
                }
            });
        }
    }

    private final void updateCurrentFile(VirtualFile file) {
        OutlinesData outlinesData;
        OutlinesData nextValue$iv;
        Object it;
        VirtualFile nextValue$iv2;
        Object prevValue$iv;
        Object $this$update$iv = this._currentFile;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (VirtualFile)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv2 = file)));
        $this$update$iv = this._uiState;
        $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (OutlinesData)prevValue$iv;
            boolean bl = false;
            if (file != null) {
                VirtualFile it2;
                boolean bl2 = false;
                String string = it2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                outlinesData = this.outlinesManager.getOutlinesData(string);
                continue;
            }
            outlinesData = null;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = outlinesData));
    }

    private final void showOutlines() {
        block3: {
            this._notificationState.setValue((Object)false);
            VirtualFile currentFile = (VirtualFile)this._currentFile.getValue();
            if (((Boolean)AiPluginSettingsProvider.Companion.getInstance().getAutomaticGenerationOutlinesSettingState().getValue()).booleanValue() && currentFile != null) {
                String string = currentFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!this.outlinesManager.hasOutlines(string)) {
                    this.outlinesManager.generateOutlinesForFile(currentFile, TriggerType.AUTOMATIC);
                    return;
                }
            }
            OutlinesData outlinesData = (OutlinesData)this._uiState.getValue();
            if (outlinesData == null) break block3;
            OutlinesData it = outlinesData;
            boolean bl = false;
            OutlinesData outlinesData2 = this.outlinesManager.markOutlinesAsSeen(it.getFile());
            if (outlinesData2 == null) {
                outlinesData2 = it;
            }
            OutlinesData updatedOutlines = outlinesData2;
            this.outlinesDisplayManager.dismissOutlinesAvailableNotification();
            this.outlinesDisplayManager.showOutlines(updatedOutlines, false, true);
        }
    }

    public final void setCurrentFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.updateCurrentFile(file);
    }

    public final boolean isOutlinesTabSelected() {
        ToolWindow toolWindow = this.toolWindow;
        return (toolWindow != null ? toolWindow.isVisible() : false) && Intrinsics.areEqual((Object)this.toolWindow.getContentManager().getSelectedContent(), (Object)this.tabContent);
    }

    public final boolean isPanelOpened() {
        ToolWindow toolWindow = this.toolWindow;
        return toolWindow != null ? toolWindow.isVisible() : false;
    }

    public final void openOutlinesTab(@NotNull OutlinesData outlinesData) {
        Intrinsics.checkNotNullParameter((Object)outlinesData, (String)"outlinesData");
        this.updateCurrentFile(outlinesData.getFile());
        FileEditorManager.getInstance((Project)this.project).openFile(outlinesData.getFile(), true);
        this.openOutlinesTab();
    }

    public final void openOutlinesTab() {
        block3: {
            if (this.isOutlinesTabSelected()) {
                return;
            }
            ToolWindow toolWindow = this.toolWindow;
            if (toolWindow != null) {
                toolWindow.show();
            }
            Content content2 = this.tabContent;
            if (content2 == null) break block3;
            Content it = content2;
            boolean bl = false;
            ToolWindow toolWindow2 = this.toolWindow;
            if (toolWindow2 != null && (toolWindow2 = toolWindow2.getContentManager()) != null) {
                toolWindow2.setSelectedContent(it, true);
            }
        }
    }

    public void dispose() {
    }

    public static final /* synthetic */ void access$showOutlines(OutlinesTabController $this) {
        $this.showOutlines();
    }

    public static final /* synthetic */ MutableStateFlow access$get_notificationState$p(OutlinesTabController $this) {
        return $this._notificationState;
    }

    public static final /* synthetic */ MutableStateFlow access$get_currentFile$p(OutlinesTabController $this) {
        return $this._currentFile;
    }

    public static final /* synthetic */ MutableStateFlow access$get_uiState$p(OutlinesTabController $this) {
        return $this._uiState;
    }

    public static final /* synthetic */ void access$updateCurrentFile(OutlinesTabController $this, VirtualFile file) {
        $this.updateCurrentFile(file);
    }

    public static final /* synthetic */ OutlinesMetricsTracker access$getOutlinesMetricsTracker$p(OutlinesTabController $this) {
        return $this.outlinesMetricsTracker;
    }

    public static final /* synthetic */ Content access$getTabContent$p(OutlinesTabController $this) {
        return $this.tabContent;
    }

    public static final /* synthetic */ String access$getTabTitle$p(OutlinesTabController $this) {
        return $this.tabTitle;
    }

    public static final /* synthetic */ void access$setTabContent$p(OutlinesTabController $this, Content content2) {
        $this.tabContent = content2;
    }

    public static final /* synthetic */ StateFlow access$getNotificationState$p(OutlinesTabController $this) {
        return $this.notificationState;
    }

    public static final /* synthetic */ String access$getTabTitleWithNotificationDot(OutlinesTabController $this) {
        return $this.getTabTitleWithNotificationDot();
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(OutlinesTabController $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ JBColor access$getNOTIFICATION_COLOR$cp() {
        return NOTIFICATION_COLOR;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesTabController$Companion;", "", "()V", "NOTIFICATION_COLOR", "Lcom/intellij/ui/JBColor;", "NOTIFICATION_DOT", "", "getInstance", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesTabController;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nOutlinesTabController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesTabController.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesTabController$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,224:1\n30#2,2:225\n*S KotlinDebug\n*F\n+ 1 OutlinesTabController.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesTabController$Companion\n*L\n221#1:225,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OutlinesTabController getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<OutlinesTabController> serviceClass$iv = OutlinesTabController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (OutlinesTabController)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

