/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.outlines.OutlinePresentationRenderer;
import com.google.tools.intellij.aiplugin.outlines.OutlinesData;
import com.google.tools.intellij.aiplugin.outlines.OutlinesItem;
import com.google.tools.intellij.aiplugin.outlines.OutlinesRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Disposer;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "componentListener", "com/google/tools/intellij/aiplugin/outlines/OutlinesRenderer$componentListener$1", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesRenderer$componentListener$1;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "dispose", "", "showOutlines", "outlinesData", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesData;", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlinesRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesRenderer.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1#2:41\n1869#3,2:42\n*S KotlinDebug\n*F\n+ 1 OutlinesRenderer.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesRenderer\n*L\n35#1:42,2\n*E\n"})
public final class OutlinesRenderer
implements Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<Inlay<?>> inlays;
    @NotNull
    private final componentListener.1 componentListener;
    public static final int $stable = 8;

    public OutlinesRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.inlays = new ArrayList();
        this.componentListener = new ComponentAdapter(this){
            final /* synthetic */ OutlinesRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Iterable $this$forEach$iv = OutlinesRenderer.access$getInlays$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Inlay it = (Inlay)element$iv;
                    boolean bl = false;
                    it.update();
                }
            }
        };
        this.editor.getComponent().addComponentListener(this.componentListener);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final void showOutlines(@NotNull OutlinesData outlinesData) {
        Intrinsics.checkNotNullParameter((Object)outlinesData, (String)"outlinesData");
        for (OutlinesItem outline : outlinesData.getOutlines()) {
            Inlay it;
            int offset2 = this.editor.getDocument().getLineEndOffset(outline.getLineNumber() - 1);
            if (offset2 == -1) continue;
            OutlinePresentationRenderer renderer2 = new OutlinePresentationRenderer(this.editor, outline.getComment());
            if (this.editor.getInlayModel().addBlockElement(offset2, true, false, 1, (EditorCustomElementRenderer)renderer2) == null) continue;
            boolean bl = false;
            this.inlays.add(it);
        }
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.inlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlays.clear();
        this.editor.getComponent().removeComponentListener(this.componentListener);
    }

    public static final /* synthetic */ List access$getInlays$p(OutlinesRenderer $this) {
        return $this.inlays;
    }
}

