/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.outlines.OutlinesItem;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J*\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u000bJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J,\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J,\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesParser;", "", "()V", "HASH_COMMENT", "", "HASH_STAR_COMMENT", "OUTLINE_COMMENT_PREFIX_REGEX", "Lkotlin/text/Regex;", "SLASH_COMMENT", "SLASH_STAR_COMMENT", "isOutlineComment", "", "line", "onlyChangeComments", "originalContent", "modifiedContent", "preserveExistingComments", "normalize", "parse", "", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesItem;", "pushNewLines", "", "newLines", "resultLines", "", "pushOldLines", "oldLines", "removeOutlineComments", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlinesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesParser.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n774#2:163\n865#2,2:164\n*S KotlinDebug\n*F\n+ 1 OutlinesParser.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesParser\n*L\n148#1:160\n148#1:161,2\n151#1:163\n151#1:164,2\n*E\n"})
public final class OutlinesParser {
    @NotNull
    public static final OutlinesParser INSTANCE = new OutlinesParser();
    @NotNull
    private static final String HASH_STAR_COMMENT = "#*";
    @NotNull
    private static final String SLASH_STAR_COMMENT = "//*";
    @NotNull
    private static final String HASH_COMMENT = "#";
    @NotNull
    private static final String SLASH_COMMENT = "//";
    @NotNull
    private static final Regex OUTLINE_COMMENT_PREFIX_REGEX = new Regex("^\\s*([/#]+\\s*\\*[^a-zA-Z0-9\\s]*)");
    public static final int $stable = 8;

    private OutlinesParser() {
    }

    @NotNull
    public final List<OutlinesItem> parse(@NotNull String originalContent, @NotNull String modifiedContent) {
        Intrinsics.checkNotNullParameter((Object)originalContent, (String)"originalContent");
        Intrinsics.checkNotNullParameter((Object)modifiedContent, (String)"modifiedContent");
        String cleanContent = OutlinesParser.onlyChangeComments$default(this, originalContent, modifiedContent, false, false, 4, null);
        List cleanLines = StringsKt.lines((CharSequence)cleanContent);
        List outlineItems = new ArrayList();
        List list = ComparisonManager.getInstance().compareLines((CharSequence)originalContent, (CharSequence)cleanContent, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
        List lineFragments = list;
        for (LineFragment fragment : lineFragments) {
            if (!Intrinsics.areEqual((Object)DiffUtil.getLineDiffType((LineFragment)fragment), (Object)TextDiffType.INSERTED)) continue;
            int n = fragment.getEndLine2();
            for (int i2 = fragment.getStartLine2(); i2 < n; ++i2) {
                String line = (String)cleanLines.get(i2);
                if (!this.isOutlineComment(line)) continue;
                outlineItems.add(new OutlinesItem(fragment.getStartLine1(), this.removeOutlineComments(line)));
            }
        }
        return outlineItems;
    }

    private final boolean isOutlineComment(String line) {
        return OUTLINE_COMMENT_PREFIX_REGEX.containsMatchIn((CharSequence)line);
    }

    private final String removeOutlineComments(String line) {
        MatchResult matchResult = Regex.find$default((Regex)OUTLINE_COMMENT_PREFIX_REGEX, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null) {
            return line;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String string = line.substring(matchGroup.getRange().getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final String onlyChangeComments(@NotNull String originalContent, @NotNull String modifiedContent, boolean preserveExistingComments, boolean normalize) {
        Intrinsics.checkNotNullParameter((Object)originalContent, (String)"originalContent");
        Intrinsics.checkNotNullParameter((Object)modifiedContent, (String)"modifiedContent");
        List originalLines = StringsKt.lines((CharSequence)originalContent);
        List modifiedLines = StringsKt.lines((CharSequence)modifiedContent);
        List resultLines = new ArrayList();
        List list = ComparisonManager.getInstance().compareLines((CharSequence)originalContent, (CharSequence)modifiedContent, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
        List lineFragments = list;
        int lastProcessedLine = 0;
        for (LineFragment fragment : lineFragments) {
            TextDiffType textDiffType;
            if (fragment.getStartLine1() > lastProcessedLine) {
                resultLines.addAll(originalLines.subList(lastProcessedLine, fragment.getStartLine1()));
            }
            if (Intrinsics.areEqual((Object)(textDiffType = DiffUtil.getLineDiffType((LineFragment)fragment)), (Object)TextDiffType.INSERTED)) {
                newLines = modifiedLines.subList(fragment.getStartLine2(), fragment.getEndLine2());
                this.pushNewLines(newLines, resultLines, normalize);
            } else if (Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED)) {
                List<String> oldLines = originalLines.subList(fragment.getStartLine1(), fragment.getEndLine1());
                this.pushOldLines(oldLines, resultLines, preserveExistingComments);
            } else if (Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.MODIFIED)) {
                newLines = modifiedLines.subList(fragment.getStartLine2(), fragment.getEndLine2());
                this.pushNewLines(newLines, resultLines, normalize);
                List<String> oldLines = originalLines.subList(fragment.getStartLine1(), fragment.getEndLine1());
                this.pushOldLines(oldLines, resultLines, preserveExistingComments);
            }
            lastProcessedLine = fragment.getEndLine1();
        }
        if (lastProcessedLine < originalLines.size()) {
            resultLines.addAll(originalLines.subList(lastProcessedLine, originalLines.size()));
        }
        return CollectionsKt.joinToString$default((Iterable)resultLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String onlyChangeComments$default(OutlinesParser outlinesParser, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return outlinesParser.onlyChangeComments(string, string2, bl, bl2);
    }

    private final void pushNewLines(List<String> newLines, List<String> resultLines, boolean normalize) {
        for (String line : newLines) {
            MatchResult match = Regex.find$default((Regex)OUTLINE_COMMENT_PREFIX_REGEX, (CharSequence)line, (int)0, (int)2, null);
            if (match == null) continue;
            if (normalize) {
                String commentText;
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String prefix = matchGroup.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(match.getRange().getLast() + 1), (String)"substring(...)");
                String commentType = StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)prefix)).toString(), (String)HASH_COMMENT, (boolean)false, (int)2, null) ? HASH_STAR_COMMENT : SLASH_STAR_COMMENT;
                String indentation = StringsKt.repeat((CharSequence)" ", (int)(line.length() - ((Object)StringsKt.trimStart((CharSequence)line)).toString().length()));
                resultLines.add(indentation + commentType + commentText);
                continue;
            }
            resultLines.add(line);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void pushOldLines(List<String> oldLines, List<String> resultLines, boolean preserveExistingComments) {
        List linesToPush = oldLines;
        if (preserveExistingComments) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = linesToPush;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                if (!(!INSTANCE.isOutlineComment(line))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            linesToPush = (List)destination$iv$iv;
        } else {
            Iterable $this$filter$iv = linesToPush;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                String trimmed = ((Object)StringsKt.trimStart((CharSequence)line)).toString();
                if (!(!StringsKt.startsWith$default((String)trimmed, (String)HASH_COMMENT, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)trimmed, (String)SLASH_COMMENT, (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            linesToPush = (List)destination$iv$iv;
        }
        resultLines.addAll(linesToPush);
    }
}

