/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.outlines;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.FileContext;
import com.android.studio.ml.bot.MessageFeedbackModel;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.android.tools.idea.studiobot.AiExcludeService;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.google.tools.intellij.aiplugin.outlines.OutlinesCache;
import com.google.tools.intellij.aiplugin.outlines.OutlinesData;
import com.google.tools.intellij.aiplugin.outlines.OutlinesDisplayManager;
import com.google.tools.intellij.aiplugin.outlines.OutlinesFeedback;
import com.google.tools.intellij.aiplugin.outlines.OutlinesMetricsTracker;
import com.google.tools.intellij.aiplugin.outlines.OutlinesModelService;
import com.google.tools.intellij.aiplugin.outlines.OutlinesTabController;
import com.google.tools.intellij.aiplugin.outlines.TriggerType;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 82\u00020\u0001:\u000289B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\n\u0010!\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$J\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010*\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010-\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020'J\u0010\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020'J\u0016\u00106\u001a\u0004\u0018\u000107*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "_outlinesState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesData;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "focusEventChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager$ProjectFile;", "outlinesCache", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesCache;", "outlinesDisplayManager", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesDisplayManager;", "outlinesMetricsTracker", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesMetricsTracker;", "outlinesState", "Lkotlinx/coroutines/flow/StateFlow;", "getOutlinesState", "()Lkotlinx/coroutines/flow/StateFlow;", "cancelRequest", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "generateOutlinesForFile", "triggerType", "Lcom/google/tools/intellij/aiplugin/outlines/TriggerType;", "getActiveFile", "getOutlinesData", "filePath", "", "handleFileClosed", "hasOutlines", "", "isEnabled", "isEnabledForFile", "isFileSupported", "markOutlinesAsOutdated", "markOutlinesAsSeen", "markOutlinesAsShowInEditor", "show", "setupEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "updateFeedback", "rating", "Lcom/android/studio/ml/bot/MessageFeedbackModel$Rating;", "updateShowInEditor", "toFileContext", "Lcom/android/studio/ml/FileContext;", "Companion", "ProjectFile", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOutlinesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesManager.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,353:1\n30#2,2:354\n30#2,2:356\n30#2,2:358\n12797#3,3:360\n*S KotlinDebug\n*F\n+ 1 OutlinesManager.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesManager\n*L\n116#1:354,2\n129#1:356,2\n188#1:358,2\n246#1:360,3\n*E\n"})
public final class OutlinesManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final OutlinesDisplayManager outlinesDisplayManager;
    @NotNull
    private final OutlinesMetricsTracker outlinesMetricsTracker;
    @NotNull
    private final OutlinesCache outlinesCache;
    @NotNull
    private final Channel<ProjectFile> focusEventChannel;
    @NotNull
    private final MutableStateFlow<OutlinesData> _outlinesState;
    @NotNull
    private final StateFlow<OutlinesData> outlinesState;
    public static final int $stable = 8;
    private static final long FOCUS_DEBOUNCE_MS = 1000L;
    @NotNull
    private static final Set<MimeType> SUPPORTED_EXTENSIONS;

    public OutlinesManager(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.outlinesDisplayManager = OutlinesDisplayManager.Companion.getInstance(this.project);
        this.outlinesMetricsTracker = OutlinesMetricsTracker.Companion.getInstance();
        this.outlinesCache = new OutlinesCache();
        this.focusEventChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this._outlinesState = StateFlowKt.MutableStateFlow(null);
        this.outlinesState = FlowKt.asStateFlow(this._outlinesState);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.debounce((Flow)FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.focusEventChannel)), (long)1000L), (Function2)((Function2)new Function2<ProjectFile, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ OutlinesManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProjectFile it = (ProjectFile)this.L$0;
                        if (((Boolean)AiPluginSettingsProvider.Companion.getInstance().getAutomaticGenerationOutlinesSettingState().getValue()).booleanValue() && OutlinesTabController.Companion.getInstance(this.this$0.project).isOutlinesTabSelected()) {
                            OutlinesCache outlinesCache = this.this$0.outlinesCache;
                            String string = it.getFile().getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            OutlinesData outlines = outlinesCache.get(string);
                            if (outlines == null || outlines.getStatus() == OutlinesData.Status.OUTDATED) {
                                this.this$0.generateOutlinesForFile(it.getFile(), TriggerType.AUTOMATIC);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProjectFile p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Editor editor2 = source.getSelectedTextEditor();
                if (editor2 == null) {
                    return;
                }
                this.setupEditor(editor2);
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.handleFileClosed(file);
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor2 = event.getManager().getSelectedTextEditor();
                if (editor2 == null) {
                    return;
                }
                this.setupEditor(editor2);
            }
        });
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<AiPluginSettingsProvider> serviceClass$iv = AiPluginSettingsProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)((AiPluginSettingsProvider)object).getOutlinesInEditorSettingState()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ boolean Z$0;
            final /* synthetic */ OutlinesManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean show2 = this.Z$0;
                        if (show2) {
                            this.this$0.outlinesDisplayManager.showOutlinesForFiles(this.this$0.outlinesCache.getAll());
                        } else {
                            this.this$0.outlinesDisplayManager.disposeAllOutlines();
                        }
                        this.this$0.outlinesCache.updateShowInEditor(show2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.Z$0 = (Boolean)value;
                return (Continuation)var3_3;
            }

            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
        $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        $i$f$service = false;
        serviceClass$iv = AiPluginSettingsProvider.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.drop((Flow)((Flow)((AiPluginSettingsProvider)object2).getAutomaticGenerationOutlinesSettingState()), (int)1), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ boolean Z$0;
            final /* synthetic */ OutlinesManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean enabled = this.Z$0;
                        this.this$0.outlinesMetricsTracker.trackAutomaticGenerationToggled(enabled);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.Z$0 = (Boolean)value;
                return (Continuation)var3_3;
            }

            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final StateFlow<OutlinesData> getOutlinesState() {
        return this.outlinesState;
    }

    public final void cancelRequest(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutlinesMetricsTracker.Companion.getInstance().trackOutlinesGenerationCancelled();
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OutlinesModelService.INSTANCE.cancelRequest(string);
        OutlinesData cancelledOutlines = new OutlinesData(file, CollectionsKt.emptyList(), OutlinesData.Status.CANCELLED, null, false, false, null, 120, null);
        this._outlinesState.setValue((Object)cancelledOutlines);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.outlinesCache.put(string2, cancelledOutlines);
    }

    public final void generateOutlinesForFile(@NotNull VirtualFile file, @NotNull TriggerType triggerType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)triggerType), (String)"triggerType");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String action = this.hasOutlines(string) ? "MANUAL_REGENERATED" : triggerType.name();
        this.outlinesMetricsTracker.trackOutlinesGenerated(action);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, triggerType, null){
            Object L$0;
            int label;
            final /* synthetic */ OutlinesManager this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ TriggerType $triggerType;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$triggerType = $triggerType;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!this.this$0.isEnabledForFile(this.$file)) {
                            return Unit.INSTANCE;
                        }
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<FileContext>(this.this$0, this.$file){
                            final /* synthetic */ OutlinesManager this$0;
                            final /* synthetic */ VirtualFile $file;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                super(0);
                            }

                            public final FileContext invoke() {
                                return OutlinesManager.access$toFileContext(this.this$0, this.$file, OutlinesManager.access$getProject$p(this.this$0));
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        v1 = (FileContext)v0;
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        fileContext = v1;
                        this.L$0 = fileContext;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$file, this.$triggerType, null){
                            int label;
                            final /* synthetic */ OutlinesManager this$0;
                            final /* synthetic */ VirtualFile $file;
                            final /* synthetic */ TriggerType $triggerType;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                this.$triggerType = $triggerType;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        OutlinesManager.access$getOutlinesDisplayManager$p(this.this$0).dismissOutlinesAvailableNotification();
                                        OutlinesManager.access$getOutlinesDisplayManager$p(this.this$0).disposeOutlines(this.$file);
                                        OutlinesData pendingOutlines = new OutlinesData(this.$file, CollectionsKt.emptyList(), OutlinesData.Status.PENDING, null, false, false, null, 120, null);
                                        OutlinesManager.access$get_outlinesState$p(this.this$0).setValue((Object)pendingOutlines);
                                        OutlinesCache outlinesCache = OutlinesManager.access$getOutlinesCache$p(this.this$0);
                                        String string = this.$file.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                        outlinesCache.put(string, pendingOutlines);
                                        if (this.$triggerType == TriggerType.MANUAL) {
                                            OutlinesTabController.Companion.getInstance(OutlinesManager.access$getProject$p(this.this$0)).openOutlinesTab();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        fileContext = (FileContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 3;
                        v3 = OutlinesModelService.INSTANCE.generateOutlines(OutlinesManager.access$getProject$p(this.this$0), fileContext, (Continuation<? super OutlinesData>)((Continuation)this));
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl38
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl38:
                        // 2 sources

                        outlinesData = (OutlinesData)v3;
                        this.label = 4;
                        v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, outlinesData, this.$file, this.$triggerType, null){
                            int label;
                            final /* synthetic */ OutlinesManager this$0;
                            final /* synthetic */ OutlinesData $outlinesData;
                            final /* synthetic */ VirtualFile $file;
                            final /* synthetic */ TriggerType $triggerType;
                            {
                                this.this$0 = $receiver;
                                this.$outlinesData = $outlinesData;
                                this.$file = $file;
                                this.$triggerType = $triggerType;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        OutlinesManager.access$get_outlinesState$p(this.this$0).setValue((Object)this.$outlinesData);
                                        if (this.$outlinesData.getStatus() == OutlinesData.Status.UP_TO_DATE) {
                                            OutlinesCache outlinesCache = OutlinesManager.access$getOutlinesCache$p(this.this$0);
                                            String string = this.$file.getPath();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                            outlinesCache.put(string, this.$outlinesData);
                                            if (this.$triggerType == TriggerType.MANUAL || OutlinesTabController.Companion.getInstance(OutlinesManager.access$getProject$p(this.this$0)).isOutlinesTabSelected()) {
                                                OutlinesDisplayManager.showOutlines$default(OutlinesManager.access$getOutlinesDisplayManager$p(this.this$0), this.$outlinesData, false, false, 6, null);
                                            } else if (!((Collection)this.$outlinesData.getOutlines()).isEmpty()) {
                                                OutlinesManager.access$getOutlinesDisplayManager$p(this.this$0).showOutlinesAvailableNotification(this.$outlinesData);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v4 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl47
                    }
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl47:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean isEnabled() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        OnboardingState.State onboardingState2 = (OnboardingState.State)((Object)((OnboardingState)((ActiveOnboardingProvider)object).getOnboardingState().getValue()).getCurrentState().getValue());
        return FeatureFlagsService.Companion.getInstance().isOutlinesEnabled() && onboardingState2 == OnboardingState.State.ONBOARDED;
    }

    public final boolean isFileSupported(@NotNull VirtualFile file) {
        String string;
        Iterable iterable;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                iterable = SUPPORTED_EXTENSIONS;
                string = file.getExtension();
                if (string == null) break block2;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        String string3 = MimeTypeUtilsKt.fromExtension(MimeType.Companion, string);
        return CollectionsKt.contains((Iterable)iterable, (Object)(string3 != null ? MimeType.box-impl(string3) : null));
    }

    public final boolean isEnabledForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isEnabled() && this.isFileSupported(file) && !AiExcludeService.Companion.getInstance(this.project).isFileExcluded(file);
    }

    public final boolean hasOutlines(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.outlinesCache.get(filePath) != null;
    }

    private final void setupEditor(Editor editor2) {
        if (!FeatureFlagsService.Companion.getInstance().isOutlinesEnabled() || editor2.isViewer() || editor2.getEditorKind() != EditorKind.MAIN_EDITOR) {
            return;
        }
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile file = virtualFile2;
            boolean bl = false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            OutlinesData cachedOutlines = this.outlinesCache.get(string);
            this._outlinesState.setValue((Object)cachedOutlines);
            if (cachedOutlines != null && cachedOutlines.getHasBeenSeen()) {
                OutlinesDisplayManager.showOutlines$default(this.outlinesDisplayManager, cachedOutlines, false, false, 4, null);
                return;
            }
        }
        Project project2 = editor2.getProject();
        if (project2 != null) {
            VirtualFile virtualFile3;
            Project project3 = project2;
            boolean bl = false;
            VirtualFile virtualFile4 = virtualFile3 = editor2.getVirtualFile();
            if (virtualFile4 != null) {
                Intrinsics.checkNotNull((Object)virtualFile4);
                VirtualFile it = virtualFile3;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                ChannelResult.box-impl((Object)this.focusEventChannel.trySend-JP2dKIU((Object)new ProjectFile(project3, it, (EditorImpl)editor2)));
            }
        }
        Document document2 = editor2.getDocument();
        DocumentListener documentListener2 = new DocumentListener(this){
            final /* synthetic */ OutlinesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                block0: {
                    VirtualFile file;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile2 = file = FileDocumentManager.getInstance().getFile(event.getDocument());
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = virtualFile2;
                    OutlinesManager outlinesManager = this.this$0;
                    VirtualFile it = virtualFile3;
                    boolean bl = false;
                    OutlinesManager.access$markOutlinesAsOutdated(outlinesManager, it);
                }
            }
        };
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        document2.addDocumentListener(documentListener2, ((EditorImpl)editor2).getDisposable());
    }

    private final void handleFileClosed(VirtualFile file) {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$count$iv = fileEditorArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            FileEditor it = (FileEditor)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
            ++count$iv;
        }
        int remainingEditors = count$iv;
        if (remainingEditors > 0) {
            return;
        }
        this.cancelRequest(file);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (this.outlinesCache.contains(string)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
                int label;
                final /* synthetic */ OutlinesManager this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            OutlinesCache outlinesCache = OutlinesManager.access$getOutlinesCache$p(this.this$0);
                            String string = this.$file.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            outlinesCache.remove(string);
                            OutlinesManager.access$getOutlinesDisplayManager$p(this.this$0).disposeOutlines(this.$file);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final void updateShowInEditor(@NotNull VirtualFile file, boolean show2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.markOutlinesAsShowInEditor(file, show2);
        if (show2) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            OutlinesData outlinesData = this.outlinesCache.get(string);
            if (outlinesData == null) {
                return;
            }
            OutlinesData outlinesData2 = outlinesData;
            OutlinesDisplayManager.showOutlines$default(this.outlinesDisplayManager, outlinesData2, false, false, 6, null);
        } else {
            this.outlinesDisplayManager.disposeOutlines(file);
        }
    }

    public final void updateFeedback(@NotNull VirtualFile file, @NotNull MessageFeedbackModel.Rating rating) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OutlinesData outlinesData = this.outlinesCache.get(string);
        if (outlinesData == null) {
            return;
        }
        OutlinesData outlines = outlinesData;
        OutlinesData updatedOutlines = OutlinesData.copy$default(outlines, null, null, null, null, false, false, new OutlinesFeedback(rating), 63, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.outlinesCache.put(string2, updatedOutlines);
        this._outlinesState.setValue((Object)updatedOutlines);
        this.outlinesMetricsTracker.trackOutlinesFeedback(outlines.getFeedback().getRating().name());
    }

    public final void markOutlinesAsShowInEditor(@NotNull VirtualFile file, boolean show2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OutlinesData outlinesData = this.outlinesCache.get(string);
        if (outlinesData == null) {
            return;
        }
        OutlinesData outlines = outlinesData;
        OutlinesData updatedOutlines = OutlinesData.copy$default(outlines, null, null, null, null, show2, false, null, 111, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.outlinesCache.put(string2, updatedOutlines);
        this._outlinesState.setValue((Object)updatedOutlines);
    }

    private final void markOutlinesAsOutdated(VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OutlinesData outlinesData = this.outlinesCache.get(string);
        if (outlinesData == null) {
            return;
        }
        OutlinesData outlines = outlinesData;
        if (outlines.getStatus() == OutlinesData.Status.OUTDATED) {
            return;
        }
        OutlinesData outdatedOutlines = OutlinesData.copy$default(outlines, null, null, OutlinesData.Status.OUTDATED, null, false, false, null, 123, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.outlinesCache.put(string2, outdatedOutlines);
        if (Intrinsics.areEqual((Object)file, (Object)this.getActiveFile())) {
            this._outlinesState.setValue((Object)outdatedOutlines);
        }
        this.outlinesDisplayManager.disposeOutlines(file);
        this.outlinesDisplayManager.dismissOutlinesAvailableNotification();
    }

    @Nullable
    public final OutlinesData markOutlinesAsSeen(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OutlinesData outlinesData = this.outlinesCache.get(string);
        if (outlinesData == null) {
            return null;
        }
        OutlinesData outlines = outlinesData;
        OutlinesData updatedOutlines = OutlinesData.copy$default(outlines, null, null, null, null, false, true, null, 95, null);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.outlinesCache.put(string2, updatedOutlines);
        this._outlinesState.setValue((Object)updatedOutlines);
        return updatedOutlines;
    }

    private final VirtualFile getActiveFile() {
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        return (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
    }

    private final FileContext toFileContext(VirtualFile $this$toFileContext, Project project2) {
        Document document2;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile($this$toFileContext);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        Language language2 = psiFile3.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        String string = MimeTypeUtilsKt.fromLanguage$default(MimeType.Companion, language2, $this$toFileContext, null, 4, null);
        if (string == null) {
            string = MimeType.Companion.getUNKNOWN-i_3W7CY();
        }
        String lang = string;
        Document document3 = document2 = FileDocumentManager.getInstance().getDocument($this$toFileContext);
        int textLength = document3 != null ? document3.getTextLength() : (int)$this$toFileContext.getLength();
        Document document4 = document2;
        FileContext.CaretInfo caretInfo2 = new FileContext.CaretInfo(0, new TextRange(0, RangesKt.coerceAtMost((int)textLength, (int)(document4 != null ? document4.getTextLength() : 0))));
        return new FileContext($this$toFileContext, lang, CollectionsKt.listOf((Object)caretInfo2), null, null);
    }

    @Nullable
    public final OutlinesData getOutlinesData(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.outlinesCache.get(filePath);
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public static final /* synthetic */ FileContext access$toFileContext(OutlinesManager $this, VirtualFile $receiver, Project project2) {
        return $this.toFileContext($receiver, project2);
    }

    public static final /* synthetic */ MutableStateFlow access$get_outlinesState$p(OutlinesManager $this) {
        return $this._outlinesState;
    }

    public static final /* synthetic */ void access$markOutlinesAsOutdated(OutlinesManager $this, VirtualFile file) {
        $this.markOutlinesAsOutdated(file);
    }

    static {
        Object[] objectArray = new MimeType[]{MimeType.box-impl(MimeType.Companion.getC-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getCPP-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getCSHARP-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getJAVA-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getJAVASCRIPT-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getPYTHON-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getGO-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getTYPESCRIPT-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getKOTLIN-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getSWIFT-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getRUST-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getR-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getPHP-i_3W7CY())};
        SUPPORTED_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager$Companion;", "", "()V", "FOCUS_DEBOUNCE_MS", "", "SUPPORTED_EXTENSIONS", "", "Lcom/android/tools/idea/studiobot/MimeType;", "getInstance", "Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nOutlinesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlinesManager.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,353:1\n30#2,2:354\n*S KotlinDebug\n*F\n+ 1 OutlinesManager.kt\ncom/google/tools/intellij/aiplugin/outlines/OutlinesManager$Companion\n*L\n332#1:354,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OutlinesManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<OutlinesManager> serviceClass$iv = OutlinesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (OutlinesManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/outlines/OutlinesManager$ProjectFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "aiplugin.ij-platform"})
    private static final class ProjectFile {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final EditorImpl editor;

        public ProjectFile(@NotNull Project project2, @NotNull VirtualFile file, @NotNull EditorImpl editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.project = project2;
            this.file = file;
            this.editor = editor2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final EditorImpl getEditor() {
            return this.editor;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final EditorImpl component3() {
            return this.editor;
        }

        @NotNull
        public final ProjectFile copy(@NotNull Project project2, @NotNull VirtualFile file, @NotNull EditorImpl editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return new ProjectFile(project2, file, editor2);
        }

        public static /* synthetic */ ProjectFile copy$default(ProjectFile projectFile, Project project2, VirtualFile virtualFile2, EditorImpl editorImpl, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = projectFile.project;
            }
            if ((n & 2) != 0) {
                virtualFile2 = projectFile.file;
            }
            if ((n & 4) != 0) {
                editorImpl = projectFile.editor;
            }
            return projectFile.copy(project2, virtualFile2, editorImpl);
        }

        @NotNull
        public String toString() {
            return "ProjectFile(project=" + this.project + ", file=" + this.file + ", editor=" + this.editor + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            result2 = result2 * 31 + this.editor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectFile)) {
                return false;
            }
            ProjectFile projectFile = (ProjectFile)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)projectFile.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)projectFile.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.editor, (Object)projectFile.editor);
        }
    }
}

