/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.onboarding.controller;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ModelError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.action.SelectGcpProjectAction;
import com.google.tools.intellij.aiplugin.enablement.AiPluginApiEnablementService;
import com.google.tools.intellij.aiplugin.notification.AiPluginNotificationService;
import com.google.tools.intellij.aiplugin.onboarding.controller.GcpProjectSelectionController;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\u0006\u0010\u0014\u001a\u00020\u0013R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/tools/intellij/aiplugin/onboarding/controller/GcpProjectSelectionController;", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldEnableApi", "", "(Lcom/intellij/openapi/project/Project;Z)V", "_selectedProjectName", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectedProjectName", "Lkotlinx/coroutines/flow/StateFlow;", "getSelectedProjectName", "()Lkotlinx/coroutines/flow/StateFlow;", "enableAPI", "", "onSelectProject", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGcpProjectSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GcpProjectSelectionController.kt\ncom/google/tools/intellij/aiplugin/onboarding/controller/GcpProjectSelectionController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n24#2:79\n*S KotlinDebug\n*F\n+ 1 GcpProjectSelectionController.kt\ncom/google/tools/intellij/aiplugin/onboarding/controller/GcpProjectSelectionController\n*L\n28#1:79\n*E\n"})
public final class GcpProjectSelectionController {
    @NotNull
    private final Project project;
    private final boolean shouldEnableApi;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MutableStateFlow<String> _selectedProjectName;
    @NotNull
    private final StateFlow<String> selectedProjectName;
    public static final int $stable = 8;

    public GcpProjectSelectionController(@NotNull Project project2, boolean shouldEnableApi) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.shouldEnableApi = shouldEnableApi;
        GcpProjectSelectionController $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GcpProjectSelectionController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this._selectedProjectName = StateFlowKt.MutableStateFlow(null);
        this.selectedProjectName = FlowKt.asStateFlow(this._selectedProjectName);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StateFlow<String> getSelectedProjectName() {
        return this.selectedProjectName;
    }

    public final void onSelectProject() {
        CharSequence charSequence;
        SelectGcpProjectAction.Companion.selectGcpProject(this.project);
        String projectId = AiPluginSettingsProvider.getCaicProjectIdStoredInSettings$default(AiPluginSettingsProvider.Companion.getInstance(), null, 1, null);
        this._selectedProjectName.setValue((Object)projectId);
        if (this.shouldEnableApi && !((charSequence = (CharSequence)projectId) == null || charSequence.length() == 0)) {
            this.enableAPI(this.project);
        }
    }

    @VisibleForTesting
    public final void enableAPI(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = SmlIjBundle.message("aiplugin.enablement.enable.gemini.api", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, this, string){
            final /* synthetic */ GcpProjectSelectionController this$0;
            {
                this.this$0 = $receiver;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    if (AiPluginApiEnablementService.serviceState$default(AiPluginApiEnablementService.Companion.getInstance(), null, 1, null) == AiPluginApiEnablementService.ServiceState.DISABLED) {
                        AiPluginApiEnablementService.enableService$default(AiPluginApiEnablementService.Companion.getInstance(), null, 1, null);
                        GcpProjectSelectionController.access$getLogger$p(this.this$0).info("API enabled successfully.");
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(() -> enableAPI.1.run$lambda$0(e));
                }
            }

            private static final void run$lambda$0(Exception $e) {
                AiPluginNotificationService aiPluginNotificationService = AiPluginNotificationService.Companion.getInstance();
                String string = SmlIjBundle.message("aiplugin.error.fail.enable.api.title.text", new Object[0]);
                Intrinsics.checkNotNull((Object)$e, (String)"null cannot be cast to non-null type com.google.api.client.googleapis.json.GoogleJsonResponseException");
                String string2 = ((GoogleJsonResponseException)((Object)$e)).getDetails().getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
                AiPluginNotificationService.notifyError$default(aiPluginNotificationService, new ModelError.Error(string, string2, CollectionsKt.listOf((Object)"SubmitFeedback")), null, 2, null);
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(GcpProjectSelectionController $this) {
        return $this.logger;
    }
}

