/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.oauth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginService1pImpl;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginServiceByoidImpl;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginServiceImpl;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.tools.intellij.login.ByoidProviderKt;
import com.google.cloud.tools.intellij.login.ClientCredentialsKt;
import com.google.cloud.tools.intellij.login.CredentialedUser;
import com.google.cloud.tools.intellij.login.sdk.ExtendedCredential;
import com.google.cloud.tools.intellij.service.ApiEndpointOverride;
import com.google.cloud.tools.intellij.service.EndpointOverrideUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.tools.intellij.aiplugin.integration.AiPluginIntegrationTestUtilKt;
import com.google.tools.intellij.aiplugin.oauth.AiPluginAuthenticator;
import com.google.tools.intellij.aiplugin.oauth.AiPluginIntelliJLoginClient;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ \u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/google/tools/intellij/aiplugin/oauth/AiPluginLoginService;", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceImpl;", "loginClient", "Lcom/google/tools/intellij/aiplugin/oauth/AiPluginIntelliJLoginClient;", "(Lcom/google/tools/intellij/aiplugin/oauth/AiPluginIntelliJLoginClient;)V", "apiEndpointOverride", "Lcom/google/cloud/tools/intellij/service/ApiEndpointOverride;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLoginClient", "()Lcom/google/tools/intellij/aiplugin/oauth/AiPluginIntelliJLoginClient;", "createCredentialedUser", "Lcom/google/cloud/tools/intellij/login/CredentialedUser;", "doCreateCredentialedUser", "email", "", "active", "", "extendedCredential", "Lcom/google/cloud/tools/intellij/login/sdk/ExtendedCredential;", "getEmail", "getLoggedInUser", "logByoidEnvVar", "", "logInWithLocalServer", "onComplete", "Lkotlin/Function0;", "onAuthUrl", "Lkotlin/Function1;", "logOut", "overrideLoginServiceImplEndpoints", "refreshCredentials", "updateAuthState", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public class AiPluginLoginService
extends GoogleLoginServiceImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AiPluginIntelliJLoginClient loginClient;
    @NotNull
    private final Logger log;
    @NotNull
    private final ApiEndpointOverride apiEndpointOverride;
    public static final int $stable = 8;
    @NotNull
    private static final String STS_OVERRIDE_URL = "https://sts.googleapis.com/";

    public AiPluginLoginService(@NotNull AiPluginIntelliJLoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super((IntellijLoginClient)loginClient, ByoidProviderKt.isByoidEnabled());
        this.loginClient = loginClient;
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.apiEndpointOverride = new ApiEndpointOverride();
        this.overrideLoginServiceImplEndpoints();
    }

    public /* synthetic */ AiPluginLoginService(AiPluginIntelliJLoginClient aiPluginIntelliJLoginClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            aiPluginIntelliJLoginClient = new AiPluginIntelliJLoginClient();
        }
        this(aiPluginIntelliJLoginClient);
    }

    @NotNull
    public final AiPluginIntelliJLoginClient getLoginClient() {
        return this.loginClient;
    }

    private final void overrideLoginServiceImplEndpoints() {
        GoogleLoginService1pImpl googleLoginService1pImpl;
        if (ByoidProviderKt.isByoidEnabled()) {
            AiPluginIntelliJLoginClient aiPluginIntelliJLoginClient = this.loginClient;
            googleLoginService1pImpl = (GoogleLoginService1pImpl)new GoogleLoginServiceByoidImpl(this, aiPluginIntelliJLoginClient){
                final /* synthetic */ AiPluginLoginService this$0;
                {
                    this.this$0 = $receiver;
                    super((IntellijLoginClient)$super_call_param$1);
                }

                public String getOauth2RootUrl() {
                    return "https://sts.googleapis.com/";
                }

                public String getOpenidConnectRootUrl() {
                    return AiPluginLoginService.access$getApiEndpointOverride$p(this.this$0).getRootUrl(EndpointOverrideUrl.OPENID_CONNECT);
                }
            };
        } else {
            AiPluginIntelliJLoginClient aiPluginIntelliJLoginClient = this.loginClient;
            googleLoginService1pImpl = new GoogleLoginService1pImpl(this, aiPluginIntelliJLoginClient){
                final /* synthetic */ AiPluginLoginService this$0;
                {
                    this.this$0 = $receiver;
                    super((IntellijLoginClient)$super_call_param$1);
                }

                public String getOauth2RootUrl() {
                    return AiPluginLoginService.access$getApiEndpointOverride$p(this.this$0).getRootUrl(EndpointOverrideUrl.OAUTH2);
                }

                public String getOpenidConnectRootUrl() {
                    return AiPluginLoginService.access$getApiEndpointOverride$p(this.this$0).getRootUrl(EndpointOverrideUrl.OPENID_CONNECT);
                }
            };
        }
        this.setLoginService(googleLoginService1pImpl);
    }

    public void logInWithLocalServer(@NotNull Function0<Unit> onComplete, @NotNull Function1<? super String, Unit> onAuthUrl) {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Intrinsics.checkNotNullParameter(onAuthUrl, (String)"onAuthUrl");
        if (ByoidProviderKt.isByoidEnabled()) {
            this.logByoidEnvVar();
        }
        super.logInWithLocalServer(onComplete, onAuthUrl);
    }

    private final void logByoidEnvVar() {
        this.log.info("BYOID Enabled\nGEMINI_CODE_ASSIST_WIF_PROVIDER_NAME=" + ByoidProviderKt.getWifProviderName() + "\nGEMINI_CODE_ASSIST_WIF_AUTH_URL=" + ByoidProviderKt.getWifAuthUrl() + "\n");
    }

    public void refreshCredentials() {
        super.refreshCredentials();
        this.updateAuthState();
    }

    public void logOut(@NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        super.logOut((Function0)new Function0<Unit>(this, onComplete){
            final /* synthetic */ AiPluginLoginService this$0;
            final /* synthetic */ Function0<Unit> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(0);
            }

            public final void invoke() {
                AiPluginLoginService.access$updateAuthState(this.this$0);
                this.$onComplete.invoke();
            }
        });
    }

    @Nullable
    public String getEmail() {
        if (AiPluginIntegrationTestUtilKt.isIntegrationTestMode()) {
            return "test_user_email";
        }
        return super.getEmail();
    }

    @Nullable
    public final CredentialedUser createCredentialedUser() {
        if (!this.isLoggedIn()) {
            return null;
        }
        String string = this.getEmail();
        if (string == null) {
            return null;
        }
        String email = string;
        GoogleCredential credential = this.createCredentials();
        ExtendedCredential extendedCredential = new ExtendedCredential((Credential)credential, ClientCredentialsKt.getOauthClientId(), ClientCredentialsKt.getOauthClientNotSoSecret(), credential.getAccessToken(), null, null, 48, null);
        return this.doCreateCredentialedUser(email, true, extendedCredential);
    }

    @Nullable
    public final CredentialedUser getLoggedInUser(@Nullable String email) {
        CredentialedUser currentUser;
        CredentialedUser credentialedUser = currentUser = this.createCredentialedUser();
        return Intrinsics.areEqual((Object)(credentialedUser != null ? credentialedUser.getEmail() : null), (Object)email) ? currentUser : null;
    }

    private final void updateAuthState() {
        Authenticator authenticator = Authenticator.Companion.current();
        if (authenticator instanceof AiPluginAuthenticator) {
            ((AiPluginAuthenticator)authenticator).updateAuthState$aiplugin_ij_platform();
        }
    }

    @VisibleForTesting
    @NotNull
    public CredentialedUser doCreateCredentialedUser(@NotNull String email, boolean active, @NotNull ExtendedCredential extendedCredential) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)extendedCredential, (String)"extendedCredential");
        return new CredentialedUser(email, active, extendedCredential);
    }

    public AiPluginLoginService() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ApiEndpointOverride access$getApiEndpointOverride$p(AiPluginLoginService $this) {
        return $this.apiEndpointOverride;
    }

    public static final /* synthetic */ void access$updateAuthState(AiPluginLoginService $this) {
        $this.updateAuthState();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/tools/intellij/aiplugin/oauth/AiPluginLoginService$Companion;", "", "()V", "STS_OVERRIDE_URL", "", "getInstance", "Lcom/google/tools/intellij/aiplugin/oauth/AiPluginLoginService;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nAiPluginLoginService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginLoginService.kt\ncom/google/tools/intellij/aiplugin/oauth/AiPluginLoginService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,147:1\n40#2,3:148\n*S KotlinDebug\n*F\n+ 1 AiPluginLoginService.kt\ncom/google/tools/intellij/aiplugin/oauth/AiPluginLoginService$Companion\n*L\n141#1:148,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AiPluginLoginService getInstance() {
            boolean $i$f$service = false;
            Class<AiPluginLoginService> serviceClass$iv = AiPluginLoginService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AiPluginLoginService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

