/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.completion.SmlInlineCompletionInlayManager;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/SuggestionUIFactory;", "", "()V", "createAcceptDismissHint", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createDecoratorAcceptDismissHint", "hintText", "", "createKeyActionPresentation", "factory", "Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "keyText", "actionText", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class SuggestionUIFactory {
    @NotNull
    public static final SuggestionUIFactory INSTANCE = new SuggestionUIFactory();
    public static final int $stable;

    private SuggestionUIFactory() {
    }

    @NotNull
    public final InlayPresentation createKeyActionPresentation(@NotNull ScaleAwarePresentationFactory factory, @NotNull String keyText, @NotNull String actionText) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)keyText, (String)"keyText");
        Intrinsics.checkNotNullParameter((Object)actionText, (String)"actionText");
        Color keyTextBackgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)Lookup.LOOKUP_COLOR);
        Color keyTextBorderColor = DefaultLanguageHighlighterColors.INLAY_DEFAULT.getDefaultAttributes().getForegroundColor();
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{SmlInlineCompletionInlayManager.Companion.withBorder(SmlInlineCompletionInlayManager.Companion.withRoundedCornerBox(factory.smallText(keyText), (InlayPresentationFactory)factory, keyTextBackgroundColor), (InlayPresentationFactory)factory, keyTextBorderColor), SmlInlineCompletionInlayManager.Companion.withBorder$default(SmlInlineCompletionInlayManager.Companion, SmlInlineCompletionInlayManager.Companion.withRoundedCornerBox$default(SmlInlineCompletionInlayManager.Companion, factory.smallText(actionText), (InlayPresentationFactory)factory, null, 2, null), (InlayPresentationFactory)factory, null, 2, null)};
        return SmlInlineCompletionInlayManager.Companion.verticallyCentered(factory.seq(inlayPresentationArray), factory);
    }

    @NotNull
    public final InlayPresentation createAcceptDismissHint(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ScaleAwarePresentationFactory factory = new ScaleAwarePresentationFactory(editor2, new PresentationFactory(editor2));
        InlayPresentation tabPresentation = this.createKeyActionPresentation(factory, "Tab", "to accept");
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{factory.text(" "), tabPresentation};
        return SmlInlineCompletionInlayManager.Companion.verticallyCentered(factory.seq(inlayPresentationArray), factory);
    }

    @NotNull
    public final InlayPresentation createDecoratorAcceptDismissHint(@NotNull Editor editor2, @NotNull String hintText) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)hintText, (String)"hintText");
        ScaleAwarePresentationFactory factory = new ScaleAwarePresentationFactory(editor2, new PresentationFactory(editor2));
        InlayPresentation tabPresentation = this.createKeyActionPresentation(factory, "Tab", "to jump");
        InlayPresentation escapePresentation = this.createKeyActionPresentation(factory, "Esc", "to dismiss");
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{SmlInlineCompletionInlayManager.Companion.verticallyCentered(factory.text(hintText + " "), factory), tabPresentation, SmlInlineCompletionInlayManager.Companion.verticallyCentered(factory.text("| "), factory), escapePresentation};
        return SmlInlineCompletionInlayManager.Companion.verticallyCentered(factory.seq(inlayPresentationArray), factory);
    }
}

