/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J,\u0010\u0010\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/LoadingIndicatorRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "currentFrame", "", "timer", "Ljavax/swing/Timer;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "dispose", "", "ensureTimerStarted", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "resetAndStart", "stopTimer", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class LoadingIndicatorRenderer
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    private int currentFrame;
    @Nullable
    private Timer timer;
    public static final int $stable = 8;
    @NotNull
    private static final String INDICATOR = "...";
    private static final int GHOST_TEXT_ALPHA = 192;
    private static final int FRAME_DELAY = 500;
    private static final int HORIZONTAL_OFFSET = 20;

    public LoadingIndicatorRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.currentFrame = 1;
    }

    private final void ensureTimerStarted() {
        block3: {
            block2: {
                if (this.timer == null) break block2;
                Timer timer = this.timer;
                Intrinsics.checkNotNull((Object)timer);
                if (timer.isRunning()) break block3;
            }
            this.currentFrame = 1;
            Timer timer = this.timer = new Timer(500, arg_0 -> LoadingIndicatorRenderer.ensureTimerStarted$lambda$0(this, arg_0));
            if (timer != null) {
                timer.setRepeats(true);
            }
            Timer timer2 = this.timer;
            if (timer2 != null) {
                timer2.start();
            }
        }
    }

    public final void stopTimer() {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
        }
        this.timer = null;
        this.currentFrame = 1;
    }

    public final void resetAndStart() {
        this.stopTimer();
        this.ensureTimerStarted();
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.editor.getContentComponent().getFontMetrics(this.editor.getColorsScheme().getFont(EditorFontType.PLAIN)).stringWidth(INDICATOR) + 20;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.ensureTimerStarted();
        g.setFont(this.editor.getColorsScheme().getFont(EditorFontType.ITALIC));
        Color it = this.editor.getColorsScheme().getDefaultForeground();
        boolean bl = false;
        g.setColor(new Color(it.getRed(), it.getGreen(), it.getBlue(), 192));
        String string = INDICATOR.substring(0, this.currentFrame);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String textToDraw = string;
        g.drawString(textToDraw, targetRegion.x + 20, targetRegion.y + this.editor.getAscent());
    }

    public void dispose() {
        this.stopTimer();
    }

    private static final void ensureTimerStarted$lambda$0(LoadingIndicatorRenderer this$0, ActionEvent it) {
        this$0.currentFrame = this$0.currentFrame % 3 + 1;
        if (this$0.editor.getContentComponent().isShowing()) {
            ApplicationManager.getApplication().invokeLater(() -> LoadingIndicatorRenderer.ensureTimerStarted$lambda$0$0(this$0));
        }
    }

    private static final void ensureTimerStarted$lambda$0$0(LoadingIndicatorRenderer this$0) {
        this$0.editor.getContentComponent().repaint();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/LoadingIndicatorRenderer$Companion;", "", "()V", "FRAME_DELAY", "", "GHOST_TEXT_ALPHA", "HORIZONTAL_OFFSET", "INDICATOR", "", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

