/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.debug;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.tools.aiplugin.editor.prediction.Delta;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffChunk;
import com.google.tools.aiplugin.editor.prediction.DiffLine;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.LineAction;
import com.google.tools.aiplugin.editor.prediction.LineType;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.predictionservices.PredictionService;
import com.google.tools.aiplugin.editor.predictionservices.debug.DebugDialogUtilsKt;
import com.google.tools.aiplugin.editor.predictionservices.debug.DiffPlaygroundPanel;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0014*\u0001\u0019\u0018\u00002\u00020\u0001:\u0004()*+BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0016J \u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u00012\u0006\u0010\u001f\u001a\u00020\bH\u0082\b\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\"\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onTextChanged", "Lkotlin/Function2;", "", "", "languageProperty", "Lkotlin/reflect/KMutableProperty0;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function2;Lkotlin/reflect/KMutableProperty0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "before", "Ljavax/swing/JTextPane;", "after", "result", "gson", "Lcom/google/gson/Gson;", "pendingPayload", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$DiffPayload;", "windowFocusListener", "com/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$windowFocusListener$1", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$windowFocusListener$1;", "addNotify", "removeNotify", "parseFromJsonOrNull", "T", "json", "(Ljava/lang/String;)Ljava/lang/Object;", "parseFromDiffOrNull", "diff", "checkForClipboardData", "installContextMenu", "component", "installPasteInterceptor", "pane", "DiffDocumentListener", "LanguageTransferableData", "LanguageCopyPasteProcessor", "DiffPayload", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nDiffPlaygroundPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffPlaygroundPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n155#1,5:439\n1374#2:432\n1460#2,5:433\n1#3:438\n*S KotlinDebug\n*F\n+ 1 DiffPlaygroundPanel.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel\n*L\n203#1:439,5\n168#1:432\n168#1:433,5\n*E\n"})
public final class DiffPlaygroundPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final Function2<String, String, Unit> onTextChanged;
    @NotNull
    private final KMutableProperty0<String> languageProperty;
    @NotNull
    private final JTextPane before;
    @NotNull
    private final JTextPane after;
    @NotNull
    private final JTextPane result;
    @NotNull
    private final Gson gson;
    @Nullable
    private DiffPayload pendingPayload;
    @NotNull
    private final windowFocusListener.1 windowFocusListener;

    public DiffPlaygroundPanel(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull Function2<? super String, ? super String, Unit> onTextChanged, @NotNull KMutableProperty0<String> languageProperty) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onTextChanged, (String)"onTextChanged");
        Intrinsics.checkNotNullParameter(languageProperty, (String)"languageProperty");
        super(new BorderLayout());
        this.project = project2;
        this.onTextChanged = onTextChanged;
        this.languageProperty = languageProperty;
        this.before = new JTextPane();
        this.after = new JTextPane();
        this.result = new JTextPane();
        this.gson = new Gson();
        this.windowFocusListener = new WindowAdapter(this){
            final /* synthetic */ DiffPlaygroundPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowGainedFocus(WindowEvent e) {
                DiffPlaygroundPanel.access$checkForClipboardData(this.this$0);
            }

            public void windowActivated(WindowEvent e) {
                DiffPlaygroundPanel.access$checkForClipboardData(this.this$0);
            }
        };
        CopyPastePostProcessor.EP_NAME.getPoint().registerExtension((Object)new LanguageCopyPasteProcessor(), parentDisposable);
        Font fixedFont = new Font("Monospaced", 0, 14);
        this.before.setFont(fixedFont);
        this.after.setFont(fixedFont);
        this.result.setFont(fixedFont);
        this.result.setEditable(false);
        this.installPasteInterceptor(this.before);
        this.installContextMenu(this.before);
        this.installContextMenu(this.after);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.checkForClipboardData();
            }
        });
        JPanel files2 = new JPanel();
        files2.setLayout(new BoxLayout(files2, 0));
        files2.add(new JScrollPane(this.before));
        files2.add(new JScrollPane(this.after));
        JPanel diff = new JPanel();
        diff.setLayout(new BoxLayout(diff, 1));
        diff.add(files2);
        diff.add(new JScrollPane(this.result));
        this.add((Component)diff, "Center");
        DiffDocumentListener it = new DiffDocumentListener();
        boolean bl = false;
        this.before.getDocument().addDocumentListener((DocumentListener)((Object)it));
        this.after.getDocument().addDocumentListener((DocumentListener)((Object)it));
        this.before.setText("Hello");
        this.after.setText("Goodbye");
        this.checkForClipboardData();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void addNotify() {
        block0: {
            super.addNotify();
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window == null) break block0;
            window.addWindowFocusListener(this.windowFocusListener);
        }
    }

    @Override
    public void removeNotify() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeWindowFocusListener(this.windowFocusListener);
        }
        super.removeNotify();
    }

    private final /* synthetic */ <T> T parseFromJsonOrNull(String json) {
        Object object;
        boolean $i$f$parseFromJsonOrNull = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = this.gson.fromJson(json, Object.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private final DiffPayload parseFromDiffOrNull(String diff) {
        try {
            String string;
            void $this$flatMapTo$iv$iv;
            Diff diff2 = Diff.Companion.parseDiff(diff);
            if (diff2.getChunks().isEmpty()) {
                return null;
            }
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            Iterable $this$flatMap$iv = diff2.getChunks();
            boolean $i$f$flatMap = false;
            Object object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DiffChunk p0 = (DiffChunk)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = p0.getLines();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            for (DiffLine line : (List)destination$iv$iv) {
                switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 1: {
                        before.append(line.getContent());
                        StringBuilder stringBuilder = after.append(line.getContent());
                        break;
                    }
                    case 2: {
                        StringBuilder stringBuilder = before.append(line.getContent());
                        break;
                    }
                    case 3: {
                        StringBuilder stringBuilder = after.append(line.getContent());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String it = string = diff2.getOldFile().getPath();
            boolean bl = false;
            Object object2 = !Intrinsics.areEqual((Object)it, (Object)"/dev/null") ? string : null;
            if (object2 == null) {
                Object it2 = object = diff2.getNewFile().getPath();
                boolean bl2 = false;
                object2 = !Intrinsics.areEqual((Object)it2, (Object)"/dev/null") ? object : null;
                if (object2 == null) {
                    object2 = "Unknown.txt";
                }
            }
            String filename = object2;
            String string2 = before.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = after.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return new DiffPayload(string2, string3, filename);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForClipboardData() {
        DiffPayload diffPayload;
        Object object;
        Clipboard clipboard;
        try {
            Clipboard it = clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            boolean bl = false;
            Clipboard clipboard2 = it.isDataFlavorAvailable(DataFlavor.stringFlavor) ? clipboard : null;
            object = clipboard2 != null ? clipboard2.getData(DataFlavor.stringFlavor) : null;
            object = object instanceof String ? (String)object : null;
        }
        catch (Exception exception) {
            object = null;
        }
        Object content2 = object;
        DiffPlaygroundPanel diffPlaygroundPanel2 = this;
        if (content2 == null) {
            diffPayload = null;
        } else {
            Object object2;
            DiffPlaygroundPanel exception = this;
            clipboard = content2;
            DiffPlaygroundPanel diffPlaygroundPanel3 = diffPlaygroundPanel2;
            boolean $i$f$parseFromJsonOrNull = false;
            try {
                void json$iv;
                void this_$iv;
                object2 = this_$iv.gson.fromJson((String)json$iv, DiffPayload.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                object2 = null;
            }
            diffPlaygroundPanel2 = diffPlaygroundPanel3;
            diffPayload = (DiffPayload)object2;
            if (diffPayload == null) {
                diffPayload = this.parseFromDiffOrNull((String)content2);
            }
        }
        diffPlaygroundPanel2.pendingPayload = diffPayload;
    }

    private final void installContextMenu(JTextPane component2) {
        component2.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DiffPlaygroundPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleContextMenu(e);
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleContextMenu(e);
            }

            private final void handleContextMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Prediction lastPrediction;
                    JComponent jComponent;
                    JPopupMenu menu = new JPopupMenu();
                    if (DiffPlaygroundPanel.access$getPendingPayload$p(this.this$0) != null) {
                        JMenuItem jMenuItem = new JMenuItem("Load Diff from Clipboard");
                        jComponent = this.this$0;
                        JMenuItem $this$handleContextMenu_u24lambda_u240 = jMenuItem;
                        boolean bl = false;
                        $this$handleContextMenu_u24lambda_u240.addActionListener(arg_0 -> installContextMenu.1.handleContextMenu$lambda$0$0((DiffPlaygroundPanel)jComponent, arg_0));
                        JMenuItem p0 = jMenuItem;
                        boolean bl2 = false;
                        menu.add(p0);
                    }
                    if ((lastPrediction = (Prediction)PredictionService.Companion.getInstance(this.this$0.getProject()).getLatestPredictionState().getValue()) != null) {
                        jComponent = new JMenuItem("Load Last Prediction");
                        DiffPlaygroundPanel bl2 = this.this$0;
                        JComponent $this$handleContextMenu_u24lambda_u241 = jComponent;
                        boolean bl = false;
                        ((AbstractButton)$this$handleContextMenu_u24lambda_u241).addActionListener(arg_0 -> installContextMenu.1.handleContextMenu$lambda$1$0(lastPrediction, bl2, arg_0));
                        JComponent p0 = jComponent;
                        boolean bl3 = false;
                        menu.add((JMenuItem)p0);
                    }
                    jComponent = new JMenuItem("Copy Diff as JSON");
                    JComponent p0 = this.this$0;
                    JComponent $this$handleContextMenu_u24lambda_u243 = jComponent;
                    boolean bl = false;
                    ((AbstractButton)$this$handleContextMenu_u24lambda_u243).addActionListener(arg_0 -> installContextMenu.1.handleContextMenu$lambda$3$0((DiffPlaygroundPanel)p0, arg_0));
                    p0 = jComponent;
                    boolean bl4 = false;
                    menu.add((JMenuItem)p0);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            private static final void handleContextMenu$lambda$0$0(DiffPlaygroundPanel this$0, ActionEvent it) {
                block1: {
                    DiffPayload diffPayload = DiffPlaygroundPanel.access$getPendingPayload$p(this$0);
                    if (diffPayload == null) break block1;
                    DiffPayload it2 = diffPayload;
                    boolean bl = false;
                    DiffPlaygroundPanel.access$getBefore$p(this$0).setText(it2.getBefore());
                    DiffPlaygroundPanel.access$getAfter$p(this$0).setText(it2.getAfter());
                    FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(it2.getFilename());
                    LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
                    if (languageFileType == null) {
                        languageFileType = (LanguageFileType)PlainTextFileType.INSTANCE;
                    }
                    LanguageFileType fileType2 = languageFileType;
                    DiffPlaygroundPanel.access$getLanguageProperty$p(this$0).set((Object)fileType2.getLanguage().getID());
                }
            }

            private static final void handleContextMenu$lambda$1$0(Prediction $lastPrediction, DiffPlaygroundPanel this$0, ActionEvent it) {
                Object object;
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile($lastPrediction.getPath());
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile vFile = virtualFile2;
                Pair pair = (Pair)ActionsKt.runReadAction(() -> installContextMenu.1.handleContextMenu$lambda$1$0$0(vFile, this$0));
                String originalContent = (String)pair.component1();
                String languageId = (String)pair.component2();
                try {
                    object = $lastPrediction.getDiff().apply(originalContent);
                }
                catch (Exception e) {
                    object = "Error applying diff: " + e.getMessage();
                }
                Object newContent2 = object;
                DiffPlaygroundPanel.access$getBefore$p(this$0).setText(originalContent);
                DiffPlaygroundPanel.access$getAfter$p(this$0).setText((String)newContent2);
                if (languageId != null) {
                    DiffPlaygroundPanel.access$getLanguageProperty$p(this$0).set((Object)languageId);
                }
            }

            private static final Pair handleContextMenu$lambda$1$0$0(VirtualFile $vFile, DiffPlaygroundPanel this$0) {
                String string = VfsUtilCore.loadText((VirtualFile)$vFile);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
                String text2 = string;
                PsiFile psiFile2 = PsiManager.getInstance((Project)this$0.getProject()).findFile($vFile);
                PsiFile psiFile3 = psiFile2;
                String lang = psiFile3 != null && (psiFile3 = psiFile3.getLanguage()) != null ? psiFile3.getID() : null;
                return new Pair((Object)text2, (Object)lang);
            }

            /*
             * Unable to fully structure code
             */
            private static final void handleContextMenu$lambda$3$0(DiffPlaygroundPanel this$0, ActionEvent it) {
                var3_2 = (String)DiffPlaygroundPanel.access$getLanguageProperty$p(this$0).get();
                if (var3_2 == null) ** GOTO lbl-1000
                p0 = var3_2;
                $i$a$-let-DiffPlaygroundPanel$installContextMenu$1$handleContextMenu$5$1$ext$1 = false;
                var4_5 = Language.findLanguageByID((String)p0);
                if (var4_5 != null && (var5_6 = var4_5.getAssociatedFileType()) != null && (var6_3 = var5_6.getDefaultExtension()) != null) {
                    v0 = var6_3;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = "txt";
                }
                ext = v0;
                v1 = DiffPlaygroundPanel.access$getBefore$p(this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
                v2 = DiffPlaygroundPanel.access$getAfter$p(this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                payload = new DiffPayload(v1, v2, "debug_diff." + ext);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(DiffPlaygroundPanel.access$getGson$p(this$0).toJson((Object)payload)));
                DiffPlaygroundPanel.access$checkForClipboardData(this$0);
            }
        });
    }

    private final void installPasteInterceptor(JTextPane pane) {
        String key = "paste-from-clipboard";
        Action defaultAction = pane.getActionMap().get(key);
        TextAction interceptedAction2 = new TextAction(key, this, defaultAction){
            final /* synthetic */ DiffPlaygroundPanel this$0;
            final /* synthetic */ Action $defaultAction;
            {
                this.this$0 = $receiver;
                this.$defaultAction = $defaultAction;
                super($key);
            }

            public void actionPerformed(ActionEvent e) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Transferable contents = CopyPasteManager.getInstance().getContents();
                    if (contents != null && contents.isDataFlavorSupported(LanguageTransferableData.Companion.getFLAVOR())) {
                        try {
                            Object object = contents.getTransferData(LanguageTransferableData.Companion.getFLAVOR());
                            LanguageTransferableData data2 = object instanceof LanguageTransferableData ? (LanguageTransferableData)object : null;
                            Object object2 = data2;
                            if (object2 != null && (object2 = ((LanguageTransferableData)object2).getLanguageId()) != null) {
                                Object object3 = object2;
                                KMutableProperty0 kMutableProperty0 = DiffPlaygroundPanel.access$getLanguageProperty$p(this.this$0);
                                Object p0 = object3;
                                boolean bl = false;
                                kMutableProperty0.set(p0);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Action action = this.$defaultAction;
                    if (action == null) break block4;
                    action.actionPerformed(e);
                }
            }
        };
        pane.getActionMap().put(key, interceptedAction2);
    }

    public static final /* synthetic */ DiffPayload access$getPendingPayload$p(DiffPlaygroundPanel $this) {
        return $this.pendingPayload;
    }

    public static final /* synthetic */ KMutableProperty0 access$getLanguageProperty$p(DiffPlaygroundPanel $this) {
        return $this.languageProperty;
    }

    public static final /* synthetic */ Gson access$getGson$p(DiffPlaygroundPanel $this) {
        return $this.gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$DiffDocumentListener;", "Lcom/intellij/ui/DocumentAdapter;", "<init>", "(Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel;)V", "regular", "Ljavax/swing/text/Style;", "getRegular", "()Ljavax/swing/text/Style;", "red", "getRed", "green", "getGreen", "blue", "getBlue", "render", "", "textChanged", "e", "Ljavax/swing/event/DocumentEvent;", "aiplugin.editor.prediction-services"})
    private final class DiffDocumentListener
    extends DocumentAdapter {
        @NotNull
        private final Style regular;
        @NotNull
        private final Style red;
        @NotNull
        private final Style green;
        @NotNull
        private final Style blue;

        public DiffDocumentListener() {
            Style style = DiffPlaygroundPanel.this.result.addStyle("Regular", null);
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"addStyle(...)");
            this.regular = style;
            Style style2 = DiffPlaygroundPanel.this.result.addStyle("Red", null);
            Intrinsics.checkNotNullExpressionValue((Object)style2, (String)"addStyle(...)");
            this.red = style2;
            StyleConstants.setBackground(this.red, new Color(1.0f, 0.0f, 0.0f, 0.2f));
            Style style3 = DiffPlaygroundPanel.this.result.addStyle("Green", null);
            Intrinsics.checkNotNullExpressionValue((Object)style3, (String)"addStyle(...)");
            this.green = style3;
            StyleConstants.setBackground(this.green, new Color(0.0f, 1.0f, 0.0f, 0.2f));
            Style style4 = DiffPlaygroundPanel.this.result.addStyle("Blue", null);
            Intrinsics.checkNotNullExpressionValue((Object)style4, (String)"addStyle(...)");
            this.blue = style4;
            StyleConstants.setBackground(this.blue, new Color(0.0f, 0.0f, 1.0f, 0.2f));
        }

        @NotNull
        public final Style getRegular() {
            return this.regular;
        }

        @NotNull
        public final Style getRed() {
            return this.red;
        }

        @NotNull
        public final Style getGreen() {
            return this.green;
        }

        @NotNull
        public final Style getBlue() {
            return this.blue;
        }

        public final void render() {
            Object object;
            Comparable comparable;
            String string = DiffPlaygroundPanel.this.before.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = DiffPlaygroundPanel.this.after.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            List<LineAction> lines = Differ.INSTANCE.calculateLineActions(string, string2);
            Iterator iterator = ((Iterable)lines).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                int n;
                LineAction it = (LineAction)iterator.next();
                boolean bl = false;
                LineAction lineAction = it;
                if (lineAction instanceof LineAction.Edit) {
                    n = Math.max(((LineAction.Edit)it).getBefore().length(), ((LineAction.Edit)it).getAfter().length());
                } else if (lineAction instanceof LineAction.Delete) {
                    n = ((LineAction.Delete)it).getBefore().length();
                } else if (lineAction instanceof LineAction.Add) {
                    n = ((LineAction.Add)it).getAfter().length();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = n;
                while (iterator.hasNext()) {
                    int n2;
                    Object it2 = (LineAction)iterator.next();
                    $i$a$-maxOfOrNull-DiffPlaygroundPanel$DiffDocumentListener$render$width$1 = false;
                    Object object2 = it2;
                    if (object2 instanceof LineAction.Edit) {
                        n2 = Math.max(((LineAction.Edit)it2).getBefore().length(), ((LineAction.Edit)it2).getAfter().length());
                    } else if (object2 instanceof LineAction.Delete) {
                        n2 = ((LineAction.Delete)it2).getBefore().length();
                    } else if (object2 instanceof LineAction.Add) {
                        n2 = ((LineAction.Add)it2).getAfter().length();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (object.compareTo(it2 = (Comparable)Integer.valueOf(n2)) >= 0) continue;
                    object = it2;
                }
                comparable = object;
            }
            Integer n = (Integer)comparable;
            int width = n != null ? n : 0;
            StyledDocument doc = DiffPlaygroundPanel.this.result.getStyledDocument();
            DiffPlaygroundPanel.this.result.setText("");
            for (LineAction line : lines) {
                object = line;
                if (object instanceof LineAction.Delete) {
                    doc.insertString(doc.getLength(), StringsKt.padEnd$default((String)DebugDialogUtilsKt.trimNewLine(((LineAction.Delete)line).getBefore()), (int)width, (char)'\u0000', (int)2, null), this.red);
                    doc.insertString(doc.getLength(), " ", this.blue);
                    doc.insertString(doc.getLength(), StringsKt.repeat((CharSequence)" ", (int)width) + "\n", this.blue);
                    continue;
                }
                if (object instanceof LineAction.Add) {
                    doc.insertString(doc.getLength(), StringsKt.repeat((CharSequence)" ", (int)width), this.blue);
                    doc.insertString(doc.getLength(), " ", this.blue);
                    doc.insertString(doc.getLength(), StringsKt.padEnd$default((String)DebugDialogUtilsKt.trimNewLine(((LineAction.Add)line).getAfter()), (int)width, (char)'\u0000', (int)2, null) + "\n", this.green);
                    continue;
                }
                if (object instanceof LineAction.Edit) {
                    String l2 = DebugDialogUtilsKt.trimNewLine(((LineAction.Edit)line).getBefore());
                    int last = 0;
                    for (Delta delta : ((LineAction.Edit)line).getDeltas()) {
                        String before = DebugDialogUtilsKt.trimNewLine(delta.getBefore());
                        int n3 = doc.getLength();
                        String string3 = l2.substring(last, delta.getOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        doc.insertString(n3, string3, this.regular);
                        doc.insertString(doc.getLength(), before, this.red);
                        last = delta.getOffset() + before.length();
                    }
                    int n4 = doc.getLength();
                    String string4 = l2.substring(last);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    doc.insertString(n4, StringsKt.padEnd$default((String)string4, (int)(width - last), (char)'\u0000', (int)2, null), this.regular);
                    doc.insertString(doc.getLength(), " ", this.blue);
                    last = 0;
                    int len = 0;
                    for (Delta delta : ((LineAction.Edit)line).getDeltas()) {
                        String before = DebugDialogUtilsKt.trimNewLine(delta.getBefore());
                        String after = DebugDialogUtilsKt.trimNewLine(delta.getAfter());
                        int n5 = doc.getLength();
                        String string5 = l2.substring(last, delta.getOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        doc.insertString(n5, string5, this.regular);
                        doc.insertString(doc.getLength(), after, this.green);
                        len += delta.getOffset() - last + after.length();
                        last = delta.getOffset() + before.length();
                    }
                    int n6 = doc.getLength();
                    String string6 = l2.substring(last);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    doc.insertString(n6, StringsKt.padEnd$default((String)string6, (int)(width - len), (char)'\u0000', (int)2, null) + "\n", this.regular);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            SimpleAttributeSet centerAlign = new SimpleAttributeSet();
            StyleConstants.setAlignment(centerAlign, 1);
            doc.setParagraphAttributes(0, doc.getLength(), centerAlign, false);
        }

        protected void textChanged(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Function2 function2 = DiffPlaygroundPanel.this.onTextChanged;
            String string = DiffPlaygroundPanel.this.before.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = DiffPlaygroundPanel.this.after.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            function2.invoke((Object)string, (Object)string2);
            this.render();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$DiffPayload;", "", "before", "", "after", "filename", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBefore", "()Ljava/lang/String;", "getAfter", "getFilename", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.editor.prediction-services"})
    public static final class DiffPayload {
        @NotNull
        private final String before;
        @NotNull
        private final String after;
        @NotNull
        private final String filename;

        public DiffPayload(@NotNull String before, @NotNull String after, @NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            this.before = before;
            this.after = after;
            this.filename = filename;
        }

        @NotNull
        public final String getBefore() {
            return this.before;
        }

        @NotNull
        public final String getAfter() {
            return this.after;
        }

        @NotNull
        public final String getFilename() {
            return this.filename;
        }

        @NotNull
        public final String component1() {
            return this.before;
        }

        @NotNull
        public final String component2() {
            return this.after;
        }

        @NotNull
        public final String component3() {
            return this.filename;
        }

        @NotNull
        public final DiffPayload copy(@NotNull String before, @NotNull String after, @NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            return new DiffPayload(before, after, filename);
        }

        public static /* synthetic */ DiffPayload copy$default(DiffPayload diffPayload, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = diffPayload.before;
            }
            if ((n & 2) != 0) {
                string2 = diffPayload.after;
            }
            if ((n & 4) != 0) {
                string3 = diffPayload.filename;
            }
            return diffPayload.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DiffPayload(before=" + this.before + ", after=" + this.after + ", filename=" + this.filename + ")";
        }

        public int hashCode() {
            int result2 = this.before.hashCode();
            result2 = result2 * 31 + this.after.hashCode();
            result2 = result2 * 31 + this.filename.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiffPayload)) {
                return false;
            }
            DiffPayload diffPayload = (DiffPayload)other;
            if (!Intrinsics.areEqual((Object)this.before, (Object)diffPayload.before)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.after, (Object)diffPayload.after)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filename, (Object)diffPayload.filename);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$LanguageCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$LanguageTransferableData;", "<init>", "()V", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "aiplugin.editor.prediction-services"})
    public static final class LanguageCopyPasteProcessor
    extends CopyPastePostProcessor<LanguageTransferableData> {
        @NotNull
        public List<LanguageTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
            Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
            String string = file.getLanguage().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            return CollectionsKt.listOf((Object)new LanguageTransferableData(string));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$LanguageTransferableData;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "Ljava/io/Serializable;", "languageId", "", "<init>", "(Ljava/lang/String;)V", "getLanguageId", "()Ljava/lang/String;", "getFlavor", "Ljava/awt/datatransfer/DataFlavor;", "getOffsetCount", "", "Companion", "aiplugin.editor.prediction-services"})
    public static final class LanguageTransferableData
    implements TextBlockTransferableData,
    Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String languageId;
        @NotNull
        private static final DataFlavor FLAVOR = new DataFlavor(LanguageTransferableData.class, "IntelliJ Language ID");

        public LanguageTransferableData(@NotNull String languageId) {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            this.languageId = languageId;
        }

        @NotNull
        public final String getLanguageId() {
            return this.languageId;
        }

        @NotNull
        public DataFlavor getFlavor() {
            return FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffPlaygroundPanel$LanguageTransferableData$Companion;", "", "<init>", "()V", "FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getFLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "aiplugin.editor.prediction-services"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFlavor getFLAVOR() {
                return FLAVOR;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineType.values().length];
            try {
                nArray[LineType.CONTEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

