/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.tools.aiplugin.editor.prediction.Config;
import com.google.tools.aiplugin.editor.prediction.DocumentChangeTracker;
import com.google.tools.aiplugin.editor.prediction.NextEditPredictor;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.prediction.PredictionModelProvider;
import com.google.tools.aiplugin.editor.predictionservices.StudioPredictionModelProvider;
import com.google.tools.aiplugin.editor.predictionservices.configuration.NextEditPredictionSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService;", "Lcom/intellij/openapi/Disposable$Default;", "Lcom/google/tools/aiplugin/editor/predictionservices/configuration/NextEditPredictionSettings$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "clock", "Lkotlinx/datetime/Clock;", "edtDispatcher", "Lkotlin/coroutines/CoroutineContext;", "provider", "Lcom/google/tools/aiplugin/editor/prediction/PredictionModelProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/datetime/Clock;Lkotlin/coroutines/CoroutineContext;Lcom/google/tools/aiplugin/editor/prediction/PredictionModelProvider;)V", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "tracker", "Lcom/google/tools/aiplugin/editor/prediction/DocumentChangeTracker;", "predictor", "Lcom/google/tools/aiplugin/editor/prediction/NextEditPredictor;", "getPredictor", "()Lcom/google/tools/aiplugin/editor/prediction/NextEditPredictor;", "predictions", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "getPredictions", "()Lkotlinx/coroutines/flow/Flow;", "latestPredictionState", "Lkotlinx/coroutines/flow/StateFlow;", "getLatestPredictionState", "()Lkotlinx/coroutines/flow/StateFlow;", "start", "", "predict", "settingsChanged", "settings", "Lcom/google/tools/aiplugin/editor/predictionservices/configuration/NextEditPredictionSettings;", "Companion", "aiplugin.editor.prediction-services"})
public final class PredictionService
implements Disposable.Default,
NextEditPredictionSettings.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DocumentChangeTracker tracker;
    @NotNull
    private final NextEditPredictor predictor;
    @NotNull
    private final StateFlow<Prediction> latestPredictionState;

    public PredictionService(@NotNull Project project2, @NotNull CoroutineScope cs, @NotNull Clock clock, @NotNull CoroutineContext edtDispatcher, @NotNull PredictionModelProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)edtDispatcher, (String)"edtDispatcher");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.project = project2;
        this.cs = cs;
        this.tracker = new DocumentChangeTracker(clock, (Disposable)this);
        this.predictor = new NextEditPredictor(this.tracker, this.cs, edtDispatcher, provider, (Function1<? super Path, Boolean>)((Function1)arg_0 -> PredictionService.predictor$lambda$0(this, arg_0)));
        this.latestPredictionState = FlowKt.stateIn(this.predictor.getPredictions(), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this).subscribe(NextEditPredictionSettings.Companion.getTOPIC(), (Object)this);
        this.settingsChanged(NextEditPredictionSettings.Companion.getInstance());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public PredictionService(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this(project2, cs, (Clock)Clock.System.INSTANCE, CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), new StudioPredictionModelProvider(project2));
    }

    @NotNull
    public final NextEditPredictor getPredictor() {
        return this.predictor;
    }

    @NotNull
    public final Flow<Prediction> getPredictions() {
        return this.predictor.getPredictions();
    }

    @NotNull
    public final StateFlow<Prediction> getLatestPredictionState() {
        return this.latestPredictionState;
    }

    public final void start() {
        this.predictor.start();
    }

    public final void predict() {
        this.predictor.predict();
    }

    @Override
    public void settingsChanged(@NotNull NextEditPredictionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        long effectiveDelay = settings.isEnabled() ? settings.getAutoPredictDelayMs() : 0L;
        boolean bl = settings.getIgnoreOutdated();
        long l2 = settings.getMaxNumberOfDocuments();
        long l3 = settings.getMaxChangesPerDocument();
        this.predictor.updateConfig(new Config(effectiveDelay, bl, l3, l2));
    }

    private static final boolean predictor$lambda$0(PredictionService this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AiExcludeService.Companion.getInstance(this$0.project).isFileExcluded(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.editor.prediction-services"})
    @SourceDebugExtension(value={"SMAP\nPredictionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PredictionService.kt\ncom/google/tools/aiplugin/editor/predictionservices/PredictionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,110:1\n30#2,2:111\n*S KotlinDebug\n*F\n+ 1 PredictionService.kt\ncom/google/tools/aiplugin/editor/predictionservices/PredictionService$Companion\n*L\n99#1:111,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PredictionService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<PredictionService> serviceClass$iv = PredictionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PredictionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

