/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.LineNumberRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0003\"#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0012H\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0003J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\f\u0010\u001f\u001a\u00020 *\u00020\u001eH\u0002J\f\u0010!\u001a\u00020\u0012*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0018\u00010\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider;", "Lcom/intellij/openapi/Disposable;", "document", "Lcom/intellij/openapi/editor/Document;", "parent", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/Disposable;)V", "ranges", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider$MappedLineRange;", "kotlin.jvm.PlatformType", "documentListener", "Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider$DocumentListener;", "getNewLineNumberRange", "Lcom/google/tools/aiplugin/editor/prediction/LineNumberRange;", "originalRange", "originalStartLine", "", "originalLineCount", "getNewLineNumber", "originalLineNumber", "(I)Ljava/lang/Integer;", "getRange", "dispose", "", "handleBulkUpdate", "removeListener", "handleBeforeChangeEvent", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "modifiedLineRange", "Lkotlin/ranges/IntRange;", "lineAdjustment", "MappedLineRange", "DocumentListener", "Companion", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nUpdatedLineNumberProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdatedLineNumberProvider.kt\ncom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,282:1\n1#2:283\n295#3,2:284\n1104#4,3:286\n1104#4,3:289\n*S KotlinDebug\n*F\n+ 1 UpdatedLineNumberProvider.kt\ncom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider\n*L\n108#1:284,2\n176#1:286,3\n177#1:289,3\n*E\n"})
public final class UpdatedLineNumberProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final AtomicReference<List<MappedLineRange>> ranges;
    @Nullable
    private DocumentListener documentListener;

    /*
     * WARNING - void declaration
     */
    public UpdatedLineNumberProvider(@NotNull Document document2, @NotNull Disposable parent) {
        void it;
        DocumentListener documentListener2;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.document = document2;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.ranges = new AtomicReference<List>(CollectionsKt.listOf((Object)new MappedLineRange(RangesKt.until((int)0, (int)this.document.getLineCount()), 0)));
        DocumentListener documentListener3 = documentListener2 = new DocumentListener();
        UpdatedLineNumberProvider updatedLineNumberProvider = this;
        boolean bl = false;
        this.document.addDocumentListener((com.intellij.openapi.editor.event.DocumentListener)it);
        updatedLineNumberProvider.documentListener = documentListener2;
    }

    @RequiresReadLock
    @Nullable
    public final LineNumberRange getNewLineNumberRange(@NotNull LineNumberRange originalRange) {
        Intrinsics.checkNotNullParameter((Object)originalRange, (String)"originalRange");
        return this.getNewLineNumberRange(originalRange.getStartLine(), originalRange.getLineCount());
    }

    @RequiresReadLock
    @Nullable
    public final LineNumberRange getNewLineNumberRange(int originalStartLine, int originalLineCount) {
        MappedLineRange mappedLineRange = this.getRange(originalStartLine);
        if (mappedLineRange == null) {
            return null;
        }
        MappedLineRange range = mappedLineRange;
        int lastOriginalLine = originalStartLine + originalLineCount - 1;
        IntRange intRange = range.getOriginalLineRange();
        int n = intRange.getFirst();
        if (!(lastOriginalLine <= intRange.getLast() ? n <= lastOriginalLine : false)) {
            return null;
        }
        return new LineNumberRange(originalStartLine + range.getAdjustment(), originalLineCount);
    }

    @RequiresReadLock
    @Nullable
    public final Integer getNewLineNumber(int originalLineNumber) {
        MappedLineRange mappedLineRange = this.getRange(originalLineNumber);
        if (mappedLineRange == null) {
            return null;
        }
        MappedLineRange range = mappedLineRange;
        return originalLineNumber + range.getAdjustment();
    }

    @RequiresReadLock
    private final MappedLineRange getRange(int originalLineNumber) {
        Object v2;
        block1: {
            ApplicationKt.getApplication().assertReadAccessAllowed();
            List<MappedLineRange> list = this.ranges.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MappedLineRange it = (MappedLineRange)element$iv;
                boolean bl = false;
                IntRange intRange = it.getOriginalLineRange();
                int n = intRange.getFirst();
                boolean bl2 = originalLineNumber <= intRange.getLast() ? n <= originalLineNumber : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    public void dispose() {
        this.removeListener();
    }

    @RequiresEdt
    private final void handleBulkUpdate() {
        this.removeListener();
        this.ranges.set(CollectionsKt.emptyList());
    }

    private final void removeListener() {
        block0: {
            DocumentListener documentListener2 = this.documentListener;
            if (documentListener2 == null) break block0;
            DocumentListener it = documentListener2;
            boolean bl = false;
            this.document.removeDocumentListener((com.intellij.openapi.editor.event.DocumentListener)it);
            this.documentListener = null;
        }
    }

    @RequiresEdt
    private final void handleBeforeChangeEvent(DocumentEvent event) {
        List list;
        IntRange modifiedLineRange = this.modifiedLineRange(event);
        int adjustment = this.lineAdjustment(event);
        List<MappedLineRange> localRanges = this.ranges.get();
        List $this$handleBeforeChangeEvent_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int i2 = 0;
        while (true) {
            boolean bl2 = 0 <= i2 ? i2 < ((Collection)localRanges).size() : false;
            if (!bl2 || localRanges.get(i2).getNewLineRange().getLast() >= modifiedLineRange.getFirst()) break;
            $this$handleBeforeChangeEvent_u24lambda_u240.add(localRanges.get(i2));
            ++i2;
        }
        while (true) {
            boolean bl3 = 0 <= i2 ? i2 < ((Collection)localRanges).size() : false;
            if (!bl3 || !UpdatedLineNumberProvider.Companion.intersects(localRanges.get(i2).getNewLineRange(), modifiedLineRange)) break;
            $this$handleBeforeChangeEvent_u24lambda_u240.addAll((Collection)localRanges.get(i2).split(modifiedLineRange, adjustment));
            ++i2;
        }
        while (true) {
            boolean bl4 = 0 <= i2 ? i2 < ((Collection)localRanges).size() : false;
            if (!bl4) break;
            $this$handleBeforeChangeEvent_u24lambda_u240.add(new MappedLineRange(localRanges.get(i2).getOriginalLineRange(), localRanges.get(i2).getAdjustment() + adjustment));
            ++i2;
        }
        List updatedRanges = CollectionsKt.build((List)list);
        this.ranges.set(updatedRanges);
    }

    private final IntRange modifiedLineRange(DocumentEvent $this$modifiedLineRange) {
        int startLineNumber = $this$modifiedLineRange.getDocument().getLineNumber($this$modifiedLineRange.getOffset());
        int endLineNumber = $this$modifiedLineRange.getDocument().getLineNumber($this$modifiedLineRange.getOffset() + $this$modifiedLineRange.getOldLength() - 1);
        return new IntRange(startLineNumber, endLineNumber);
    }

    private final int lineAdjustment(DocumentEvent $this$lineAdjustment) {
        CharSequence charSequence = $this$lineAdjustment.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        CharSequence $this$count$iv = charSequence;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int newlinesInNew = count$iv;
        CharSequence charSequence2 = $this$lineAdjustment.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
        CharSequence $this$count$iv2 = charSequence2;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        for (int j = 0; j < $this$count$iv2.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv2.charAt(j);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv2;
        }
        int newlinesInOld = count$iv2;
        return newlinesInNew - newlinesInOld;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider$Companion;", "", "<init>", "()V", "intersects", "", "Lkotlin/ranges/IntRange;", "other", "aiplugin.editor.prediction-services"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean intersects(IntRange $this$intersects, IntRange other) {
            return $this$intersects.getFirst() <= other.getLast() && $this$intersects.getLast() >= other.getFirst();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider$DocumentListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider;)V", "beforeDocumentChangeNonBulk", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "bulkUpdateStarting", "document", "Lcom/intellij/openapi/editor/Document;", "aiplugin.editor.prediction-services"})
    private final class DocumentListener
    implements BulkAwareDocumentListener {
        public void beforeDocumentChangeNonBulk(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ApplicationKt.getApplication().assertIsDispatchThread();
            UpdatedLineNumberProvider.this.handleBeforeChangeEvent(event);
        }

        public void bulkUpdateStarting(@NotNull Document document2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            ApplicationKt.getApplication().assertIsDispatchThread();
            UpdatedLineNumberProvider.this.handleBulkUpdate();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0005J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/UpdatedLineNumberProvider$MappedLineRange;", "", "originalLineRange", "Lkotlin/ranges/IntRange;", "adjustment", "", "<init>", "(Lkotlin/ranges/IntRange;I)V", "getOriginalLineRange", "()Lkotlin/ranges/IntRange;", "getAdjustment", "()I", "newLineRange", "getNewLineRange", "split", "", "modifiedLineRange", "modifiedAdjustment", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "aiplugin.editor.prediction-services"})
    private static final class MappedLineRange {
        @NotNull
        private final IntRange originalLineRange;
        private final int adjustment;
        @NotNull
        private final IntRange newLineRange;

        public MappedLineRange(@NotNull IntRange originalLineRange, int adjustment) {
            Intrinsics.checkNotNullParameter((Object)originalLineRange, (String)"originalLineRange");
            this.originalLineRange = originalLineRange;
            this.adjustment = adjustment;
            this.newLineRange = new IntRange(this.originalLineRange.getFirst() + this.adjustment, this.originalLineRange.getLast() + this.adjustment);
        }

        @NotNull
        public final IntRange getOriginalLineRange() {
            return this.originalLineRange;
        }

        public final int getAdjustment() {
            return this.adjustment;
        }

        @NotNull
        public final IntRange getNewLineRange() {
            return this.newLineRange;
        }

        @NotNull
        public final List<MappedLineRange> split(@NotNull IntRange modifiedLineRange, int modifiedAdjustment) {
            List list;
            Intrinsics.checkNotNullParameter((Object)modifiedLineRange, (String)"modifiedLineRange");
            IntRange beforeRange = new IntRange(this.originalLineRange.getFirst(), modifiedLineRange.getFirst() - 1 - this.adjustment);
            IntRange afterRange = new IntRange(modifiedLineRange.getLast() + 1 - this.adjustment, this.originalLineRange.getLast());
            List $this$split_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (!beforeRange.isEmpty()) {
                $this$split_u24lambda_u240.add(new MappedLineRange(beforeRange, this.adjustment));
            }
            if (!afterRange.isEmpty()) {
                $this$split_u24lambda_u240.add(new MappedLineRange(afterRange, this.adjustment + modifiedAdjustment));
            }
            return CollectionsKt.build((List)list);
        }

        @NotNull
        public final IntRange component1() {
            return this.originalLineRange;
        }

        public final int component2() {
            return this.adjustment;
        }

        @NotNull
        public final MappedLineRange copy(@NotNull IntRange originalLineRange, int adjustment) {
            Intrinsics.checkNotNullParameter((Object)originalLineRange, (String)"originalLineRange");
            return new MappedLineRange(originalLineRange, adjustment);
        }

        public static /* synthetic */ MappedLineRange copy$default(MappedLineRange mappedLineRange, IntRange intRange, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                intRange = mappedLineRange.originalLineRange;
            }
            if ((n2 & 2) != 0) {
                n = mappedLineRange.adjustment;
            }
            return mappedLineRange.copy(intRange, n);
        }

        @NotNull
        public String toString() {
            return "MappedLineRange(originalLineRange=" + this.originalLineRange + ", adjustment=" + this.adjustment + ")";
        }

        public int hashCode() {
            int result2 = this.originalLineRange.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.adjustment);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MappedLineRange)) {
                return false;
            }
            MappedLineRange mappedLineRange = (MappedLineRange)other;
            if (!Intrinsics.areEqual((Object)this.originalLineRange, (Object)mappedLineRange.originalLineRange)) {
                return false;
            }
            return this.adjustment == mappedLineRange.adjustment;
        }
    }
}

