/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffChunk;
import com.google.tools.aiplugin.editor.prediction.DocumentHistory;
import com.google.tools.aiplugin.editor.prediction.EditHistoryKt;
import com.google.tools.aiplugin.editor.prediction.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0018J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/EditHistory;", "", "maxDocs", "", "maxEdits", "<init>", "(JJ)V", "getMaxDocs", "()J", "setMaxDocs", "(J)V", "getMaxEdits", "setMaxEdits", "documents", "", "", "Lcom/google/tools/aiplugin/editor/prediction/DocumentHistory;", "lastEditId", "", "events", "", "wantToMerge", "", "diff1", "Lcom/google/tools/aiplugin/editor/prediction/Diff;", "diff2", "addDiff", "id", "diff", "prune", "setLimits", "", "docs", "edits", "remove", "path", "getLastEditId", "aiplugin.editor.prediction"})
@SourceDebugExtension(value={"SMAP\nEditHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditHistory.kt\ncom/google/tools/aiplugin/editor/prediction/EditHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1056#2:135\n1056#2:136\n*S KotlinDebug\n*F\n+ 1 EditHistory.kt\ncom/google/tools/aiplugin/editor/prediction/EditHistory\n*L\n41#1:135\n112#1:136\n*E\n"})
public final class EditHistory {
    private long maxDocs;
    private long maxEdits;
    @NotNull
    private Map<String, DocumentHistory> documents;
    private int lastEditId;

    public EditHistory(long maxDocs, long maxEdits) {
        this.maxDocs = maxDocs;
        this.maxEdits = maxEdits;
        this.documents = new LinkedHashMap();
        this.lastEditId = -1;
    }

    public /* synthetic */ EditHistory(long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l2 = 5L;
        }
        if ((n & 2) != 0) {
            l3 = 10L;
        }
        this(l2, l3);
    }

    public final long getMaxDocs() {
        return this.maxDocs;
    }

    public final void setMaxDocs(long l2) {
        this.maxDocs = l2;
    }

    public final long getMaxEdits() {
        return this.maxEdits;
    }

    public final void setMaxEdits(long l2) {
        this.maxEdits = l2;
    }

    @NotNull
    public final List<DocumentHistory> events() {
        Iterable $this$sortedBy$iv = this.documents.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DocumentHistory it = (DocumentHistory)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTime();
                it = (DocumentHistory)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTime()));
            }
        });
    }

    private final boolean wantToMerge(Diff diff1, Diff diff2) {
        if (diff1.getChunks().size() > 1 || diff2.getChunks().size() > 1) {
            return false;
        }
        if (diff1.getChunks().isEmpty() || diff2.getChunks().isEmpty()) {
            return true;
        }
        DiffChunk chunk1 = (DiffChunk)CollectionsKt.first(diff1.getChunks());
        DiffChunk chunk2 = (DiffChunk)CollectionsKt.first(diff2.getChunks());
        return chunk1.getOldStart() <= chunk2.getOldStart() && chunk2.getOldStart() <= chunk1.getOldStart() + chunk1.getOldLength();
    }

    @NotNull
    public final List<String> addDiff(int id, @NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.lastEditId = id;
        String path2 = diff.getNewFile().getPath();
        if (diff.isCreate()) {
            String content2 = diff.apply("");
            this.documents.put(path2, new DocumentHistory(path2, content2, new ArrayList(), content2, diff.getNewFile().getStamp(), diff.getNewFile().getTime()));
        } else {
            Event last;
            DocumentHistory documentHistory = this.documents.get(path2);
            if (documentHistory == null) {
                return CollectionsKt.emptyList();
            }
            DocumentHistory history2 = documentHistory;
            if (history2.getStamp() != diff.getOldFile().getStamp()) {
                this.documents.remove(path2);
                EditHistoryKt.access$getLogger$p().warn("Unexpected out of order diff on " + path2 + ", expected stamp " + history2.getStamp() + ", got " + diff.getOldFile().getStamp());
                return CollectionsKt.emptyList();
            }
            history2.setStamp(diff.getNewFile().getStamp());
            history2.setTime(diff.getNewFile().getTime());
            history2.setAfter(diff.apply(history2.getAfter()));
            if (!((Collection)history2.getEdits()).isEmpty() && this.wantToMerge((last = (Event)CollectionsKt.last(history2.getEdits())).getDiff(), diff)) {
                last.setDiff(last.getDiff().squash(diff));
                return CollectionsKt.emptyList();
            }
            history2.getEdits().add(new Event(diff));
        }
        return this.prune();
    }

    @NotNull
    public final List<String> prune() {
        for (DocumentHistory history2 : this.documents.values()) {
            while ((long)history2.getEdits().size() > this.maxEdits) {
                Event event = history2.getEdits().removeFirst();
                try {
                    history2.setBefore(event.getDiff().apply(history2.getBefore()));
                }
                catch (Exception e) {
                    EditHistoryKt.access$getLogger$p().error("Cannot prune history", (Throwable)e);
                }
            }
        }
        List old2 = new ArrayList();
        Iterable $this$sortedBy$iv = this.documents.values();
        boolean $i$f$sortedBy = false;
        for (DocumentHistory history3 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DocumentHistory it = (DocumentHistory)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTime();
                it = (DocumentHistory)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTime()));
            }
        })) {
            if ((long)(this.documents.size() - old2.size()) <= this.maxDocs) break;
            old2.add(history3.getPath());
        }
        return old2;
    }

    public final void setLimits(long docs, long edits) {
        this.maxDocs = docs;
        this.maxEdits = edits;
    }

    public final void remove(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.documents.remove(path2);
    }

    public final int getLastEditId() {
        return this.lastEditId;
    }

    public EditHistory() {
        this(0L, 0L, 3, null);
    }
}

