/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.ChangeTracker;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DocumentChange;
import com.google.tools.aiplugin.editor.prediction.FileHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\u0016\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/DocumentChangeTracker;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/google/tools/aiplugin/editor/prediction/ChangeTracker;", "clock", "Lkotlinx/datetime/Clock;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lkotlinx/datetime/Clock;Lcom/intellij/openapi/Disposable;)V", "getClock", "()Lkotlinx/datetime/Clock;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/google/tools/aiplugin/editor/prediction/DocumentChange;", "changeId", "", "docs", "", "Ljava/nio/file/Path;", "", "getDocs", "()Ljava/util/Map;", "start", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "clear", "paths", "", "", "aiplugin.editor.prediction"})
public final class DocumentChangeTracker
implements DocumentListener,
ChangeTracker {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Channel<DocumentChange> channel;
    private int changeId;
    @NotNull
    private final Map<Path, Long> docs;

    public DocumentChangeTracker(@NotNull Clock clock, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.clock = clock;
        this.disposable = disposable;
        this.channel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.docs = new LinkedHashMap();
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final Map<Path, Long> getDocs() {
        return this.docs;
    }

    @Override
    @NotNull
    public Channel<DocumentChange> start() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this, this.disposable);
        return this.channel;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        DocumentChange documentChange;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Document document2 = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document doc = document2;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(doc);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!virtualFile3.isInLocalFileSystem()) {
            return;
        }
        Path path2 = virtualFile3.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        Path path3 = path2;
        Instant now = this.clock.now();
        Long l2 = this.docs.get(path3);
        long l3 = event.getOldTimeStamp();
        if (l2 == null || l2 != l3) {
            FileHeader header = new FileHeader(((Object)path3).toString(), now, doc.getModificationStamp());
            int n = this.changeId;
            this.changeId = n + 1;
            String string = doc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            documentChange = new DocumentChange.Create(n, header, string);
        } else {
            String afterChange;
            String string = doc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = afterChange = string;
            int n = event.getOffset();
            int n2 = event.getOffset() + event.getNewFragment().length();
            CharSequence charSequence = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
            CharSequence charSequence2 = charSequence;
            String beforeChange = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)n, (int)n2, (CharSequence)charSequence2)).toString();
            FileHeader oldFile = new FileHeader(((Object)path3).toString(), now, event.getOldTimeStamp());
            FileHeader newFile = new FileHeader(((Object)path3).toString(), now, doc.getModificationStamp());
            Diff diff = Diff.Companion.calculateDiff(beforeChange, afterChange, oldFile, newFile);
            int n3 = this.changeId;
            this.changeId = n3 + 1;
            documentChange = new DocumentChange.Delta(n3, diff);
        }
        DocumentChange change = documentChange;
        this.docs.put(path3, doc.getModificationStamp());
        this.channel.trySend-JP2dKIU((Object)change);
    }

    @RequiresEdt
    public final void clear() {
        this.docs.clear();
        this.channel.trySend-JP2dKIU((Object)DocumentChange.Clear.INSTANCE);
    }

    @Override
    @RequiresEdt
    public void clear(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (String path2 : paths) {
            this.docs.remove(Path.of(path2, new String[0]));
            this.channel.trySend-JP2dKIU((Object)new DocumentChange.Remove(path2));
        }
    }
}

