/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Alarm;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public abstract class DebouncedDocumentAdapter
extends DocumentAdapter
implements Disposable {
    static final long MODIFIED_DOCUMENT_TIMEOUT_MS = 200L;
    private final Alarm documentAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);

    public DebouncedDocumentAdapter(Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
    }

    protected void textChanged(@NotNull DocumentEvent e) {
        if (this.documentAlarm.isDisposed()) {
            return;
        }
        this.documentAlarm.cancelAllRequests();
        this.documentAlarm.addRequest(() -> this.debouncedTextChanged(e), 200L);
    }

    protected abstract void debouncedTextChanged(DocumentEvent var1);
}

