/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.oauth;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.cloud.tools.intellij.login.GoogleLoginUtils;
import com.google.cloud.tools.intellij.oauth.UserinfoWithPicture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/cloud/tools/intellij/oauth/OauthUserInfoFetcher;", "", "<init>", "()V", "getUserInfo", "Lcom/google/cloud/tools/intellij/oauth/UserinfoWithPicture;", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nOauthUserInfoFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OauthUserInfoFetcher.kt\ncom/google/cloud/tools/intellij/oauth/OauthUserInfoFetcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n24#2:48\n*S KotlinDebug\n*F\n+ 1 OauthUserInfoFetcher.kt\ncom/google/cloud/tools/intellij/oauth/OauthUserInfoFetcher\n*L\n38#1:48\n*E\n"})
public final class OauthUserInfoFetcher {
    @NotNull
    public static final OauthUserInfoFetcher INSTANCE = new OauthUserInfoFetcher();

    private OauthUserInfoFetcher() {
    }

    @Nullable
    public final UserinfoWithPicture getUserInfo(@NotNull Credential credential) {
        UserinfoWithPicture userinfoWithPicture;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)credential).setApplicationName("intellij-plugin-core").build();
        Userinfo userInfo = null;
        BufferedImage profilePicture = null;
        try {
            userInfo = (Userinfo)userInfoService.userinfo().get().execute();
            String string = userInfo.getPicture();
            if (string != null) {
                String urlString = string;
                boolean bl = false;
                URL url = GoogleLoginUtils.appendSizeParameterIfNecessary(urlString);
                profilePicture = ImageIO.read(url);
            }
        }
        catch (Exception ex) {
            OauthUserInfoFetcher $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(OauthUserInfoFetcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error retrieving user information or profile picture.", (Throwable)ex);
        }
        if (userInfo != null) {
            String string = userInfo.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmail(...)");
            String string2 = userInfo.getName();
            if (string2 == null) {
                string2 = userInfo.getEmail();
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            UserinfoWithPicture userinfoWithPicture2 = new UserinfoWithPicture(string, string3, profilePicture);
            userinfoWithPicture = userinfoWithPicture2;
        } else {
            userinfoWithPicture = null;
        }
        return userinfoWithPicture;
    }
}

