/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.feedback;

import com.google.cloud.tools.intellij.feedback.HttpConnectionFactory;
import com.google.cloud.tools.intellij.feedback.ProxyHttpConnectionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.SystemInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\b\u0010\n\u001a\u00020\u0005H&J \u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0013\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/google/cloud/tools/intellij/feedback/CrashReportServiceBase;", "", "<init>", "()V", "getPluginVersionString", "", "getProductString", "getExperimentIds", "", "", "getExperimentFlags", "submitCrashReport", "", "connectionFactory", "Lcom/google/cloud/tools/intellij/feedback/HttpConnectionFactory;", "throwable", "", "errorDescription", "assemblePIISafeStackTrace", "assembleCause", "getStackTraceString", "Companion", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nCrashReportServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashReportServiceBase.kt\ncom/google/cloud/tools/intellij/feedback/CrashReportServiceBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public abstract class CrashReportServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String URL_TEMPLATE = "%s?product=%s&version=%s";
    @NotNull
    private static final String CRASH_URL = "https://clients2.google.com/cr/report";
    @NotNull
    private static final String CONTENT_TYPE_TMPL = "multipart/form-data; boundary=%s";
    @NotNull
    private static final String separator = "\n\tat ";
    @NotNull
    private static final String REDACTED = "[MESSAGE REDACTED]";

    @NotNull
    public abstract String getPluginVersionString();

    @NotNull
    public abstract String getProductString();

    @NotNull
    public abstract List<Integer> getExperimentIds();

    @NotNull
    public abstract String getExperimentFlags();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void submitCrashReport(@NotNull HttpConnectionFactory connectionFactory, @NotNull Throwable throwable, @NotNull String errorDescription) throws IOException {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
        String clientVersion = this.getPluginVersionString();
        String product = this.getProductString();
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        String string = URL_TEMPLATE;
        Object[] objectArray = new Object[]{CRASH_URL, product, clientVersion};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String url = string2;
        String stackTraceString = this.assemblePIISafeStackTrace(throwable);
        String boundary = "---------------------------1234567890";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(boundary);
        builder.addTextBody("product", product);
        builder.addTextBody("version", clientVersion);
        builder.addTextBody("comments", errorDescription);
        builder.addTextBody("os_name", SystemInfo.OS_NAME);
        builder.addTextBody("os_version", SystemInfo.OS_VERSION);
        builder.addTextBody("os_arch", SystemInfo.OS_ARCH);
        builder.addTextBody("ide_flavor", applicationInfo.getVersionName());
        builder.addTextBody("ide_version_major", applicationInfo.getMajorVersion());
        builder.addTextBody("ide_version_minor", applicationInfo.getMinorVersion());
        builder.addTextBody("exception_info", stackTraceString);
        builder.addTextBody("experiment_ids", this.getExperimentIds().toString());
        builder.addTextBody("experiment_flags", this.getExperimentFlags());
        Object object = connectionFactory.openHttpConnection(url);
        HttpURLConnection $this$submitCrashReport_u24lambda_u240 = object;
        boolean bl = false;
        $this$submitCrashReport_u24lambda_u240.setConnectTimeout(2000);
        $this$submitCrashReport_u24lambda_u240.setDoOutput(true);
        $this$submitCrashReport_u24lambda_u240.setReadTimeout(10000);
        $this$submitCrashReport_u24lambda_u240.setRequestMethod("POST");
        $this$submitCrashReport_u24lambda_u240.setRequestProperty("key", "AIzaSyDzfRBhwbHZqGZgwAX4VjJ6pgIah_jDeg4");
        String string3 = CONTENT_TYPE_TMPL;
        Object[] objectArray2 = new Object[]{boundary};
        String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        $this$submitCrashReport_u24lambda_u240.setRequestProperty("Content-Type", string4);
        HttpURLConnection connection = object;
        object = connection.getOutputStream();
        Throwable throwable2 = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl2 = false;
            builder.build().writeTo(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
        }
        int code = connection.getResponseCode();
        if (code != 200) {
            throw new RuntimeException("Error submitting feedback: Expected HTTP_OK (200), obtained " + code);
        }
    }

    public static /* synthetic */ void submitCrashReport$default(CrashReportServiceBase crashReportServiceBase, HttpConnectionFactory httpConnectionFactory, Throwable throwable, String string, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: submitCrashReport");
        }
        if ((n & 1) != 0) {
            httpConnectionFactory = new ProxyHttpConnectionFactory();
        }
        crashReportServiceBase.submitCrashReport(httpConnectionFactory, throwable, string);
    }

    @VisibleForTesting
    @NotNull
    public final String assemblePIISafeStackTrace(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        Object stackTraceString = "";
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        if (!(stackTraceElementArray == null || stackTraceElementArray.length == 0)) {
            stackTraceString = this.getStackTraceString(throwable);
            stackTraceString = (String)stackTraceString + this.assembleCause(throwable.getCause());
        }
        return stackTraceString;
    }

    private final String assembleCause(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String cause = "\nCaused by: " + this.getStackTraceString(throwable);
        return cause + this.assembleCause(throwable.getCause());
    }

    private final String getStackTraceString(Throwable throwable) {
        String string = throwable.getClass().getCanonicalName();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        return string + ": [MESSAGE REDACTED]\n\tat " + ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)separator, null, null, (int)0, null, CrashReportServiceBase::getStackTraceString$lambda$0, (int)30, null);
    }

    private static final CharSequence getStackTraceString$lambda$0(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/cloud/tools/intellij/feedback/CrashReportServiceBase$Companion;", "", "<init>", "()V", "URL_TEMPLATE", "", "CRASH_URL", "CONTENT_TYPE_TMPL", "separator", "REDACTED", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

