/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import com.google.cloud.tools.intellij.analytics.IdeSessionIndex;
import com.google.cloud.tools.intellij.analytics.IdeSessionIndexError;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/google/cloud/tools/intellij/analytics/IdeSessionIndexSerializer;", "", "<init>", "()V", "Companion", "aiplugin.cloudcode-core"})
public abstract class IdeSessionIndexSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex IDE_SESSION_INDEX_REGEX = new Regex("(\\d{8})_(\\d{4})");
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/google/cloud/tools/intellij/analytics/IdeSessionIndexSerializer$Companion;", "", "<init>", "()V", "IDE_SESSION_INDEX_REGEX", "Lkotlin/text/Regex;", "DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDATE_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "deserialize", "Lcom/google/cloud/tools/intellij/analytics/IdeSessionIndex;", "ideSessionIndexString", "", "serialize", "index", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimeFormatter getDATE_FORMAT() {
            return DATE_FORMAT;
        }

        @NotNull
        public final IdeSessionIndex deserialize(@NotNull String ideSessionIndexString) {
            Intrinsics.checkNotNullParameter((Object)ideSessionIndexString, (String)"ideSessionIndexString");
            MatchResult matchResult = Regex.find$default((Regex)IDE_SESSION_INDEX_REGEX, (CharSequence)ideSessionIndexString, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new IdeSessionIndexError("'" + ideSessionIndexString + "' does not match the ide session index regex: " + IDE_SESSION_INDEX_REGEX);
            }
            MatchResult match = matchResult;
            String dateString = (String)match.getGroupValues().get(1);
            String countString = (String)match.getGroupValues().get(2);
            int count = Integer.parseInt(countString);
            LocalDate date = LocalDate.parse(dateString, this.getDATE_FORMAT());
            Intrinsics.checkNotNull((Object)date);
            return new IdeSessionIndex(date, count);
        }

        @NotNull
        public final String serialize(@NotNull IdeSessionIndex index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            String dateString = this.getDATE_FORMAT().format(index.getDate());
            String countString = StringsKt.padStart((String)String.valueOf(index.getCount()), (int)4, (char)'0');
            return dateString + "_" + countString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

