/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.BooleanQueryKtBuilder;
import com.google.aiplugin.rag.lucene.IndexedDocumentCollection;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001a\u001a\u0010\u0019\u001a\u00020\u001a*\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u001b\u001a\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u0007*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001f\u001a%\u0010)\u001a\u00020*2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,\u00a2\u0006\u0002\b/H\u0086\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0007*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0007*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"\"\u0017\u0010$\u001a\u0004\u0018\u00010%*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(*\"\u0010\u0016\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u00172\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"FIELD_NAME_VFILE_ID", "", "FIELD_NAME_SUBDOCUMENT_INDEX", "FIELD_NAME_PARENT", "getVirtualFileIdField", "Lorg/apache/lucene/document/IntField;", "vfileId", "", "getVirtualFileIdQuery", "Lorg/apache/lucene/search/Query;", "getSubDocumentIndexField", "index", "getSubDocumentIndexQuery", "getMetadataFields", "", "Lorg/apache/lucene/index/IndexableField;", "virtualFileId", "subDocumentIndex", "INTERNAL_FIELD_NAMES", "", "getINTERNAL_FIELD_NAMES", "()Ljava/util/Set;", "LuceneIndexId", "Lcom/intellij/util/indexing/ID;", "Lcom/google/aiplugin/rag/lucene/IndexedDocumentCollection;", "getIndexPath", "Ljava/nio/file/Path;", "Lcom/google/aiplugin/rag/lucene/LuceneIndexId;", "getVirtualFileIdForDoc", "Lorg/apache/lucene/index/StoredFields;", "docId", "(Lorg/apache/lucene/index/StoredFields;I)Ljava/lang/Integer;", "Lorg/apache/lucene/document/Document;", "getVirtualFileId", "(Lorg/apache/lucene/document/Document;)Ljava/lang/Integer;", "getSubDocumentIndex", "version", "", "Lorg/apache/lucene/index/IndexReader;", "getVersion", "(Lorg/apache/lucene/index/IndexReader;)Ljava/lang/Long;", "buildBooleanQuery", "Lorg/apache/lucene/search/BooleanQuery;", "block", "Lkotlin/Function1;", "Lcom/google/aiplugin/rag/lucene/BooleanQueryKtBuilder;", "", "Lkotlin/ExtensionFunctionType;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nLuceneIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexUtils.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class LuceneIndexUtilsKt {
    @NotNull
    private static final String FIELD_NAME_VFILE_ID = "vfile.id";
    @NotNull
    private static final String FIELD_NAME_SUBDOCUMENT_INDEX = "subdocument.index";
    @NotNull
    public static final String FIELD_NAME_PARENT = "@internal:parent";
    @NotNull
    private static final Set<String> INTERNAL_FIELD_NAMES;

    @NotNull
    public static final IntField getVirtualFileIdField(int vfileId) {
        return new IntField(FIELD_NAME_VFILE_ID, vfileId, Field.Store.YES);
    }

    @NotNull
    public static final Query getVirtualFileIdQuery(int vfileId) {
        Query query = IntField.newExactQuery((String)FIELD_NAME_VFILE_ID, (int)vfileId);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"newExactQuery(...)");
        return query;
    }

    @NotNull
    public static final IntField getSubDocumentIndexField(int index) {
        return new IntField(FIELD_NAME_SUBDOCUMENT_INDEX, index, Field.Store.YES);
    }

    @NotNull
    public static final Query getSubDocumentIndexQuery(int index) {
        Query query = IntField.newExactQuery((String)FIELD_NAME_SUBDOCUMENT_INDEX, (int)index);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"newExactQuery(...)");
        return query;
    }

    @NotNull
    public static final List<IndexableField> getMetadataFields(int virtualFileId, int subDocumentIndex) {
        Object[] objectArray = new IntField[]{LuceneIndexUtilsKt.getVirtualFileIdField(virtualFileId), LuceneIndexUtilsKt.getSubDocumentIndexField(subDocumentIndex)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Set<String> getINTERNAL_FIELD_NAMES() {
        return INTERNAL_FIELD_NAMES;
    }

    @NotNull
    public static final Path getIndexPath(@NotNull ID<Integer, IndexedDocumentCollection> $this$getIndexPath) {
        Intrinsics.checkNotNullParameter($this$getIndexPath, (String)"<this>");
        Path path2 = IndexInfrastructure.getIndexRootDir($this$getIndexPath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getIndexRootDir(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("lucene");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        return path4;
    }

    @Nullable
    public static final Integer getVirtualFileIdForDoc(@NotNull StoredFields $this$getVirtualFileIdForDoc, int docId) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileIdForDoc, (String)"<this>");
        Document document2 = $this$getVirtualFileIdForDoc.document(docId, SetsKt.setOf((Object)FIELD_NAME_VFILE_ID));
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document(...)");
        return LuceneIndexUtilsKt.getVirtualFileId(document2);
    }

    @Nullable
    public static final Integer getVirtualFileId(@NotNull Document $this$virtualFileId) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFileId, (String)"<this>");
        Object object = $this$virtualFileId.getField(FIELD_NAME_VFILE_ID);
        return object != null && (object = object.numericValue()) != null ? Integer.valueOf(((Number)object).intValue()) : null;
    }

    @Nullable
    public static final Integer getSubDocumentIndex(@NotNull Document $this$subDocumentIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$subDocumentIndex, (String)"<this>");
        Object object = $this$subDocumentIndex.getField(FIELD_NAME_SUBDOCUMENT_INDEX);
        return object != null && (object = object.numericValue()) != null ? Integer.valueOf(((Number)object).intValue()) : null;
    }

    @Nullable
    public static final Long getVersion(@NotNull IndexReader $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        DirectoryReader directoryReader = $this$version instanceof DirectoryReader ? (DirectoryReader)$this$version : null;
        return directoryReader != null ? Long.valueOf(directoryReader.getVersion()) : null;
    }

    @NotNull
    public static final BooleanQuery buildBooleanQuery(@NotNull Function1<? super BooleanQueryKtBuilder, Unit> block) {
        BooleanQueryKtBuilder booleanQueryKtBuilder;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$buildBooleanQuery = false;
        BooleanQueryKtBuilder $this$buildBooleanQuery_u24lambda_u240 = booleanQueryKtBuilder = new BooleanQueryKtBuilder();
        boolean bl = false;
        block.invoke((Object)$this$buildBooleanQuery_u24lambda_u240);
        BooleanQuery booleanQuery = booleanQueryKtBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"build(...)");
        return booleanQuery;
    }

    static {
        Object[] objectArray = new String[]{FIELD_NAME_VFILE_ID, FIELD_NAME_SUBDOCUMENT_INDEX, FIELD_NAME_PARENT};
        INTERNAL_FIELD_NAMES = SetsKt.setOf((Object[])objectArray);
    }
}

