/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.RagEvent;
import com.google.aiplugin.rag.internal.FilesInProjectDirectoryPropertyPusherKt;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\r\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0007\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u001a\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0007\u001a\u000e\u0010\u0013\u001a\u00020\t*\u0004\u0018\u00010\u0014H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u0016*\u0004\u0018\u00010\u0014H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u001a(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0000\u001a0\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0000\u001a\u001c\u0010%\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u001a0\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0016H\u0000\u001a\u001c\u0010+\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u001a(\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0016H\u0000\u001a\u001a\u00100\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a8\u00061"}, d2={"shouldBeIndexedForRag", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "shouldIndexFileForRag", "file", "Lcom/intellij/util/indexing/IndexedFile;", "getRepositoryPath", "", "Lcom/intellij/openapi/project/Project;", "getRelativePath", "basePath", "absolutePath", "getFilePathToIndex", "project", "getPsiFileForAnalysis", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/util/indexing/FileContent;", "getIndexerType", "Lcom/google/aiplugin/rag/internal/RagIndexer;", "getVersion", "", "getMessageWithThrowable", "message", "t", "", "reportRagIndexError", "", "indexer", "reportRagIndexMetrics", "indexedFiles", "indexedKtFiles", "indexedJavaFiles", "generatedFiles", "indexingTimeMs", "", "reportRagToolError", "reportRagToolMetrics", "resultCount", "resourceCount", "searchTimeMs", "totalIndexedDocs", "reportFindFilesToolError", "reportBm25FindFilesToolMetrics", "combinedResultCount", "bm25SearchCount", "findFilesSearchCount", "reportKbRagIndexError", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nRagIndexerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagIndexerUtils.kt\ncom/google/aiplugin/rag/internal/RagIndexerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class RagIndexerUtilsKt {
    public static final boolean shouldBeIndexedForRag(@NotNull VirtualFile $this$shouldBeIndexedForRag, @Nullable ProjectFileIndex projectFileIndex2) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeIndexedForRag, (String)"<this>");
        if (!VirtualFileUtil.isFile((VirtualFile)$this$shouldBeIndexedForRag)) {
            return false;
        }
        if (!FilesInProjectDirectoryPropertyPusherKt.isInProjectDirectory($this$shouldBeIndexedForRag)) {
            return false;
        }
        if (projectFileIndex2 == null) {
            return true;
        }
        return (Boolean)ActionsKt.runReadAction(() -> RagIndexerUtilsKt.shouldBeIndexedForRag$lambda$0(projectFileIndex2, $this$shouldBeIndexedForRag));
    }

    @RequiresReadLock
    private static final boolean shouldIndexFileForRag(ProjectFileIndex $this$shouldIndexFileForRag, VirtualFile file) {
        if ($this$shouldIndexFileForRag.isExcluded(file)) {
            return false;
        }
        if ($this$shouldIndexFileForRag.isInGeneratedSources(file)) {
            return false;
        }
        return !$this$shouldIndexFileForRag.isInLibraryClasses(file);
    }

    public static final boolean shouldBeIndexedForRag(@NotNull IndexedFile $this$shouldBeIndexedForRag) {
        ProjectFileIndex projectFileIndex2;
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeIndexedForRag, (String)"<this>");
        try {
            projectFileIndex2 = ProjectFileIndex.getInstance((Project)$this$shouldBeIndexedForRag.getProject());
        }
        catch (IllegalStateException e) {
            projectFileIndex2 = null;
        }
        ProjectFileIndex projectFileIndex3 = projectFileIndex2;
        VirtualFile virtualFile2 = $this$shouldBeIndexedForRag.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        return RagIndexerUtilsKt.shouldBeIndexedForRag(virtualFile2, projectFileIndex3);
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull Project $this$getRepositoryPath, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getRepositoryPath, (String)"<this>");
        VirtualFile virtualFile2 = file;
        if (virtualFile2 == null && (virtualFile2 = $this$getRepositoryPath.getWorkspaceFile()) == null) {
            return $this$getRepositoryPath.getBasePath();
        }
        VirtualFile workSpaceFile = virtualFile2;
        VirtualFile virtualFile3 = (VirtualFile)ActionsKt.runReadAction(() -> RagIndexerUtilsKt.getRepositoryPath$lambda$0($this$getRepositoryPath, workSpaceFile));
        return virtualFile3 != null ? virtualFile3.getPath() : null;
    }

    public static /* synthetic */ String getRepositoryPath$default(Project project2, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile2 = null;
        }
        return RagIndexerUtilsKt.getRepositoryPath(project2, virtualFile2);
    }

    @Nullable
    public static final String getRelativePath(@NotNull String basePath2, @NotNull String absolutePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        Path absolute = Paths.get(absolutePath, new String[0]);
        Path base = Paths.get(basePath2, new String[0]);
        try {
            string = ((Object)base.relativize(absolute)).toString();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getFilePathToIndex(@NotNull VirtualFile file, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project3 = project2;
        if (project3 == null && (project3 = VirtualFileUtilsKt.guessProject(file)) == null) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        Project projectToUse = project3;
        String string = RagIndexerUtilsKt.getRepositoryPath(projectToUse, file);
        if (string == null) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }
        String basePath2 = string;
        String string3 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String string4 = RagIndexerUtilsKt.getRelativePath(basePath2, string3);
        if (string4 == null) {
            String string5 = file.getName();
            string4 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        }
        return string4;
    }

    public static /* synthetic */ String getFilePathToIndex$default(VirtualFile virtualFile2, Project project2, int n, Object object) {
        if ((n & 2) != 0) {
            project2 = null;
        }
        return RagIndexerUtilsKt.getFilePathToIndex(virtualFile2, project2);
    }

    @RequiresReadLock
    @NotNull
    public static final PsiFile getPsiFileForAnalysis(@NotNull FileContent $this$getPsiFileForAnalysis) {
        Project project2;
        block5: {
            block4: {
                Project project3;
                Intrinsics.checkNotNullParameter((Object)$this$getPsiFileForAnalysis, (String)"<this>");
                Project project4 = $this$getPsiFileForAnalysis.getProject();
                if (project4 == null) {
                    VirtualFile virtualFile2 = $this$getPsiFileForAnalysis.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    project4 = VirtualFileUtilsKt.guessProject(virtualFile2);
                }
                if ((project2 = (project3 = project4)) == null) break block4;
                Project p0 = project2;
                boolean bl = false;
                PsiManager psiManager = PsiManager.getInstance((Project)p0);
                project2 = psiManager;
                if (psiManager != null && (project2 = project2.findFile($this$getPsiFileForAnalysis.getFile())) != null) break block5;
            }
            PsiFile psiFile2 = $this$getPsiFileForAnalysis.getPsiFile();
            project2 = psiFile2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getPsiFile(...)");
        }
        return project2;
    }

    private static final String getIndexerType(RagIndexer $this$getIndexerType) {
        Object object;
        block3: {
            block2: {
                object = $this$getIndexerType;
                if (object == null) break block2;
                RagIndexer it = object;
                boolean bl = false;
                String string = it.getClass().getSimpleName();
                object = string;
                if (string != null) break block3;
            }
            object = "no indexer";
        }
        return object;
    }

    private static final int getVersion(RagIndexer $this$getVersion) {
        RagIndexer ragIndexer = $this$getVersion;
        return ragIndexer != null ? ragIndexer.getVersion() : -1;
    }

    private static final String getMessageWithThrowable(String message, Throwable t) {
        StringBuilder stringBuilder;
        StringBuilder $this$getMessageWithThrowable_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getMessageWithThrowable_u24lambda_u240.append(message);
        if (t != null) {
            $this$getMessageWithThrowable_u24lambda_u240.append('\n');
            $this$getMessageWithThrowable_u24lambda_u240.append(ExceptionUtil.getThrowableText((Throwable)t));
        }
        return stringBuilder.toString();
    }

    public static final void reportRagIndexError(@NotNull String message, @Nullable Throwable t, @Nullable RagIndexer indexer2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = RagIndexerUtilsKt.getIndexerType(indexer2);
        String string2 = RagIndexerUtilsKt.getMessageWithThrowable(message, t);
        int n = RagIndexerUtilsKt.getVersion(indexer2);
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagIndexerErrorReport(string, n, string2));
    }

    public static /* synthetic */ void reportRagIndexError$default(String string, Throwable throwable, RagIndexer ragIndexer, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            ragIndexer = RagIndexer.Companion.getInstance();
        }
        RagIndexerUtilsKt.reportRagIndexError(string, throwable, ragIndexer);
    }

    public static final void reportRagIndexMetrics(int indexedFiles, int indexedKtFiles, int indexedJavaFiles, int generatedFiles, long indexingTimeMs) {
        String string = RagIndexerUtilsKt.getIndexerType(RagIndexer.Companion.getInstance());
        int n = RagIndexerUtilsKt.getVersion(RagIndexer.Companion.getInstance());
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagIndexerMetrics(string, n, indexedFiles, indexedKtFiles, indexedJavaFiles, generatedFiles, indexingTimeMs));
    }

    public static final void reportRagToolError(@NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagToolErrorReport(RagIndexerUtilsKt.getMessageWithThrowable(message, t)));
    }

    public static /* synthetic */ void reportRagToolError$default(String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        RagIndexerUtilsKt.reportRagToolError(string, throwable);
    }

    public static final void reportRagToolMetrics(int resultCount, int resourceCount, int generatedFiles, long searchTimeMs, int totalIndexedDocs) {
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagToolMetrics(resultCount, resourceCount, generatedFiles, searchTimeMs, totalIndexedDocs));
    }

    public static final void reportFindFilesToolError(@NotNull String message, @Nullable Throwable t) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StringBuilder $this$reportFindFilesToolError_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$reportFindFilesToolError_u24lambda_u240.append("Indexer type: " + RagIndexerUtilsKt.getIndexerType(RagIndexer.Companion.getInstance())).append('\n');
        $this$reportFindFilesToolError_u24lambda_u240.append("Indexer version: " + RagIndexerUtilsKt.getVersion(RagIndexer.Companion.getInstance())).append('\n');
        $this$reportFindFilesToolError_u24lambda_u240.append(RagIndexerUtilsKt.getMessageWithThrowable(message, t));
        String errorInfo = stringBuilder.toString();
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.FindFileErrorReport(errorInfo));
    }

    public static /* synthetic */ void reportFindFilesToolError$default(String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        RagIndexerUtilsKt.reportFindFilesToolError(string, throwable);
    }

    public static final void reportBm25FindFilesToolMetrics(int combinedResultCount, int bm25SearchCount, int findFilesSearchCount, int totalIndexedDocs) {
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.Bm25FindFileMetrics(combinedResultCount, bm25SearchCount, findFilesSearchCount, totalIndexedDocs));
    }

    public static final void reportKbRagIndexError(@NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.KbRagIndexerErrorReport(RagIndexerUtilsKt.getMessageWithThrowable(message, t)));
    }

    public static /* synthetic */ void reportKbRagIndexError$default(String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        RagIndexerUtilsKt.reportKbRagIndexError(string, throwable);
    }

    private static final boolean shouldBeIndexedForRag$lambda$0(ProjectFileIndex $projectFileIndex, VirtualFile $this_shouldBeIndexedForRag) {
        return RagIndexerUtilsKt.shouldIndexFileForRag($projectFileIndex, $this_shouldBeIndexedForRag);
    }

    private static final VirtualFile getRepositoryPath$lambda$0(Project $this_getRepositoryPath, VirtualFile $workSpaceFile) {
        return ProjectFileIndex.getInstance((Project)$this_getRepositoryPath).getContentRootForFile($workSpaceFile);
    }
}

