/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.embedding;

import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.RagEvent;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.embedding.EmbeddingIndexer;
import com.google.aiplugin.rag.embedding.EmbeddingSearchTool;
import com.google.aiplugin.rag.embedding.EmbeddingSearchTool$Args$;
import com.google.aiplugin.rag.internal.IndexerMode;
import com.google.aiplugin.rag.internal.OldRagSearchToolResult;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.processing.FileResolveUtilsKt;
import com.google.aiplugin.rag.processing.RagReranker;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches the file chunk from the user's code base", description="This tool uses an embedding model and the cosine similarity between the query and the file chunk embeddings.", instructions="Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.", examples={})
@ToolResult(description="Returns up to 50 chunks that has high semantic similarities with the given query.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "indexer", "Lcom/google/aiplugin/rag/embedding/EmbeddingIndexer;", "getIndexer", "()Lcom/google/aiplugin/rag/embedding/EmbeddingIndexer;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "restoreHandler", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "Args", "Handler", "aiplugin.rag.indexer"})
public class EmbeddingSearchTool
implements Tool<Args> {
    @NotNull
    private final String name;

    public EmbeddingSearchTool() {
        this.name = "code_search";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final EmbeddingIndexer getIndexer() {
        RagIndexer ragIndexer = RagIndexer.Companion.getInstance();
        return ragIndexer instanceof EmbeddingIndexer ? (EmbeddingIndexer)ragIndexer : null;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching the codebase based on embeddings";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched the codebase based on embeddings";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(this.getIndexer(), context2, args);
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return null;
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args;", "", "query", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getQuery", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_rag_indexer", "$serializer", "Companion", "aiplugin.rag.indexer"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String query;

        public Args(@ToolArgument(description="A string that should be semantically similar to the file chunk.") @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.query = query;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @NotNull
        public final String component1() {
            return this.query;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="A string that should be semantically similar to the file chunk.") @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new Args(query);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.query;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(query=" + this.query + ")";
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.query, (Object)args.query);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_rag_indexer(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.query);
        }

        public /* synthetic */ Args(int seen0, String query, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.query = query;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args;", "aiplugin.rag.indexer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "indexer", "Lcom/google/aiplugin/rag/embedding/EmbeddingIndexer;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args;", "<init>", "(Lcom/google/aiplugin/rag/embedding/EmbeddingIndexer;Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Args;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nEmbeddingSearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingSearchTool.kt\ncom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n24#2:106\n1563#3:107\n1634#3,3:108\n*S KotlinDebug\n*F\n+ 1 EmbeddingSearchTool.kt\ncom/google/aiplugin/rag/embedding/EmbeddingSearchTool$Handler\n*L\n85#1:106\n100#1:107\n100#1:108,3\n*E\n"})
    public static final class Handler
    implements ToolHandler {
        @Nullable
        private final EmbeddingIndexer indexer;
        @NotNull
        private final ToolContext context;
        @NotNull
        private final Args args;
        @NotNull
        private final Logger logger;

        public Handler(@Nullable EmbeddingIndexer indexer2, @NotNull ToolContext context2, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.indexer = indexer2;
            this.context = context2;
            this.args = args;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var16_2 = $completion;
            if ((var16_2.label & -2147483648) != 0) {
                var16_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var18_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.indexer == null) {
                        this.logger.warn("Embedding Indexer is not active");
                        MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagToolErrorReport("IndexerInactive(" + IndexerMode.EMBEDDING.getModeName() + ")"));
                        return new Response(null, "code search is disabled", null, null, null, 29, null);
                    }
                    $continuation.label = 1;
                    v0 = this.indexer.search(this.args.getQuery(), (Continuation<? super List<Integer>>)$continuation);
                    if (v0 == var18_4) {
                        return var18_4;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    similarVFileIds = (List)v0;
                    $continuation.label = 2;
                    v1 = RagReranker.Companion.rerank(this.context.getProject(), FileResolveUtilsKt.findOrUnindexVirtualFilesById(similarVFileIds, this.logger), (Continuation<? super List<? extends VirtualFile>>)$continuation);
                    if (v1 == var18_4) {
                        return var18_4;
                    }
                    ** GOTO lbl33
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    projectFiles = (List)v1;
                    $this$map$iv = CollectionsKt.take((Iterable)projectFiles, (int)50);
                    $i$f$map = false;
                    var7_9 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var12_14 = (VirtualFile)item$iv$iv;
                        var14_16 = destination$iv$iv;
                        $i$a$-map-EmbeddingSearchTool$Handler$handle$result$1 = false;
                        v2 = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                        var14_16.add(v2);
                    }
                    var17_17 = (List)destination$iv$iv;
                    result = new OldRagSearchToolResult(var17_17);
                    return new Response(new Gson().toJson((Object)result), null, null, null, null, 30, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

