/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.doc;

import com.android.ide.common.repository.NetworkCache;
import com.android.studio.ml.bot.StudioBotFlags;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.doc.KBZipDownloader;
import com.google.aiplugin.rag.doc.KbArticleLookupTool;
import com.google.aiplugin.rag.doc.KbDoc;
import com.google.aiplugin.rag.doc.KbDocFile;
import com.google.aiplugin.rag.doc.KbFetchResult;
import com.google.aiplugin.rag.doc.KbIndexerService;
import com.google.aiplugin.rag.doc.KbIndexerServiceImpl;
import com.google.aiplugin.rag.doc.KbIndexerUtilsKt;
import com.google.aiplugin.rag.doc.KbSearchResult;
import com.google.aiplugin.rag.doc.KbSearchResultDoc;
import com.google.aiplugin.rag.doc.KbSearchTool;
import com.google.aiplugin.rag.doc.SentinelFileContent;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.gson.Gson;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001NB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\rB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u000b\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0002J\u001a\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010.\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0082@\u00a2\u0006\u0002\u0010/J \u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000fH\u0002J\u0010\u0010>\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000fH\u0002J\u0012\u0010?\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030A0@H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J\u0016\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0@H\u0016J\u001a\u0010J\u001a\u0004\u0018\u00010:2\u0006\u0010K\u001a\u00020L2\u0006\u00104\u001a\u00020\u000fH\u0002J\b\u0010M\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl;", "Lcom/google/aiplugin/rag/doc/KbIndexerService;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "baseDirectory", "Ljava/nio/file/Path;", "isServiceInPluginXml", "", "kbZipDownloader", "Lcom/android/ide/common/repository/NetworkCache;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/nio/file/Path;ZLcom/android/ide/common/repository/NetworkCache;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "overridingKBZipPath", "", "(Lkotlinx/coroutines/CoroutineScope;Ljava/nio/file/Path;Ljava/lang/String;)V", "_indexState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/google/aiplugin/rag/doc/KbIndexerService$State;", "indexState", "Lkotlinx/coroutines/flow/StateFlow;", "getIndexState", "()Lkotlinx/coroutines/flow/StateFlow;", "analyzer", "Lcom/google/aiplugin/rag/bm25/CodeAnalyzer;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "indexerJob", "Lkotlinx/coroutines/Job;", "zipPath", "indexDirectory", "kotlin.jvm.PlatformType", "setUpIndex", "", "updateSentinelFileForError", "readyFile", "zipHash", "resolveKbZip", "createIndexWriter", "Lorg/apache/lucene/index/IndexWriter;", "fsDir", "Lorg/apache/lucene/store/FSDirectory;", "createSimilarity", "Lorg/apache/lucene/search/similarities/BM25Similarity;", "getZipFileHash", "indexAllDocs", "(Lorg/apache/lucene/store/FSDirectory;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDocIndexStatus", "Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl$DocIndexStatus;", "directoryReader", "Lorg/apache/lucene/index/DirectoryReader;", "url", "content", "waitForHashInReadyFile", "index", "indexWriter", "kbDocFile", "Lcom/google/aiplugin/rag/doc/KbDocFile;", "buildMultiFieldSearchQuery", "Lorg/apache/lucene/search/Query;", "query", "buildCombinedSearchQuery", "getKbTools", "", "Lcom/google/aiplugin/agents/Tool;", "search", "Lcom/google/aiplugin/rag/doc/KbSearchResult;", "maxResults", "", "trimFetchedDoc", "fetchByRelativeUrls", "Lcom/google/aiplugin/rag/doc/KbFetchResult;", "relativeUrls", "readDoc", "doc", "Lorg/apache/lucene/document/Document;", "dispose", "DocIndexStatus", "aiplugin.rag.kb"})
@SourceDebugExtension(value={"SMAP\nKbIndexerServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KbIndexerServiceImpl.kt\ncom/google/aiplugin/rag/doc/KbIndexerServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,651:1\n24#2:652\n1#3:653\n*S KotlinDebug\n*F\n+ 1 KbIndexerServiceImpl.kt\ncom/google/aiplugin/rag/doc/KbIndexerServiceImpl\n*L\n165#1:652\n*E\n"})
public final class KbIndexerServiceImpl
implements KbIndexerService,
Disposable {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Path baseDirectory;
    @NotNull
    private final NetworkCache kbZipDownloader;
    @NotNull
    private final MutableStateFlow<KbIndexerService.State> _indexState;
    @NotNull
    private final StateFlow<KbIndexerService.State> indexState;
    @NotNull
    private final CodeAnalyzer analyzer;
    @NotNull
    private final Logger logger;
    private Job indexerJob;
    private String zipPath;
    private final Path indexDirectory;

    public KbIndexerServiceImpl(@NotNull CoroutineScope scope2, @NotNull Path baseDirectory, boolean isServiceInPluginXml, @NotNull NetworkCache kbZipDownloader) {
        boolean skipIndexing;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkNotNullParameter((Object)kbZipDownloader, (String)"kbZipDownloader");
        this.scope = scope2;
        this.baseDirectory = baseDirectory;
        this.kbZipDownloader = kbZipDownloader;
        this._indexState = StateFlowKt.MutableStateFlow((Object)((Object)KbIndexerService.State.INITIALIZING));
        this.indexState = (StateFlow)this._indexState;
        this.analyzer = new CodeAnalyzer(null, 1, null);
        KbIndexerServiceImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KbIndexerServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.indexDirectory = this.baseDirectory.resolve("indexes");
        boolean bl = skipIndexing = isServiceInPluginXml && ApplicationManager.getApplication().isUnitTestMode();
        if (!skipIndexing && StudioBotFlags.Companion.getInstance().isKbEnabled()) {
            this.setUpIndex();
        }
        if (skipIndexing) {
            this._indexState.setValue((Object)KbIndexerService.State.READY);
        }
    }

    public /* synthetic */ KbIndexerServiceImpl(CoroutineScope coroutineScope, Path path2, boolean bl, NetworkCache networkCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            Path path3 = path2.resolve("kbzip");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path path4 = path3.resolve("cache");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            File file = KbIndexerUtilsKt.getBundledZipFile$default(null, 1, null);
            networkCache = new KBZipDownloader(path4, file != null ? file.getPath() : null, 0, 4, null);
        }
        this(coroutineScope, path2, bl, networkCache);
    }

    public KbIndexerServiceImpl(@NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Path path2 = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getSystemDir(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        path3 = path4;
        Path path5 = path3.resolve("gemini");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        path3 = path5;
        Path path6 = path3.resolve("kb");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this(scope2, path6, true, null, 8, null);
    }

    public KbIndexerServiceImpl(@NotNull CoroutineScope scope2, @NotNull Path baseDirectory, final @NotNull String overridingKBZipPath) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        Intrinsics.checkNotNullParameter((Object)overridingKBZipPath, (String)"overridingKBZipPath");
        Path path2 = baseDirectory.resolve("kbzip");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path path4 = path3;
        this(scope2, baseDirectory, false, new KBZipDownloader(path4){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Closeable closeable = new FileInputStream(overridingKBZipPath);
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl = false;
                    byArray = it.readAllBytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                boolean bl = true;
                byte[] byArray2 = byArray;
                return new NetworkCache.ReadUrlDataResult(byArray2, bl);
            }
        });
    }

    @Override
    @NotNull
    public StateFlow<KbIndexerService.State> getIndexState() {
        return this.indexState;
    }

    private final void setUpIndex() {
        this.indexerJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ KbIndexerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = KbIndexerServiceImpl.access$getLogger$p(this.this$0);
                        v1 = KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getIndexDirectory$p(...)");
                        v0.debug("Initializing indexer in " + v1.toAbsolutePath().toString() + "...");
                        readyFile = KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0).resolve("index_ready.json");
                        zipFileHash = new Ref.ObjectRef();
                        try {
                            v2 = KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"access$getIndexDirectory$p(...)");
                            var4_5 = v2;
                            var5_7 /* !! */  = new FileAttribute[]{};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(var4_5, Arrays.copyOf(var5_7 /* !! */ , var5_7 /* !! */ .length)), (String)"createDirectories(...)");
                            KbIndexerServiceImpl.access$setZipPath$p(this.this$0, KbIndexerServiceImpl.access$resolveKbZip(this.this$0));
                            zipFileHash.element = KbIndexerServiceImpl.access$getZipFileHash(this.this$0);
                            if (zipFileHash.element == null) {
                                KbIndexerServiceImpl.access$get_indexState$p(this.this$0).setValue((Object)KbIndexerService.State.ERROR);
                                return Unit.INSTANCE;
                            }
                            Intrinsics.checkNotNull((Object)readyFile);
                            v3 = new LinkOption[]{};
                            if (Files.exists(readyFile, Arrays.copyOf(v3, v3.length)) && Intrinsics.areEqual((Object)(sentinelFileContent = (SentinelFileContent)new Gson().fromJson(PathsKt.readText$default((Path)readyFile, null, (int)1, null), SentinelFileContent.class)).getZipHash(), (Object)zipFileHash.element)) {
                                KbIndexerServiceImpl.access$get_indexState$p(this.this$0).setValue((Object)(sentinelFileContent.getIndexError() != false ? KbIndexerService.State.ERROR : KbIndexerService.State.READY));
                                return Unit.INSTANCE;
                            }
                            Files.deleteIfExists(readyFile);
                            v4 = KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"access$getIndexDirectory$p(...)");
                            PathsKt.deleteRecursively((Path)v4);
                            sentinelFileContent = (Closeable)FSDirectory.open((Path)KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0));
                            var5_7 /* !! */  = this.this$0;
                            var6_8 = null;
                            try {
                                fsDir = (FSDirectory)sentinelFileContent;
                                $i$a$-use-KbIndexerServiceImpl$setUpIndex$1$1 = false;
                                try {
                                    Intrinsics.checkNotNull((Object)fsDir);
                                    this.L$0 = readyFile;
                                    this.L$1 = zipFileHash;
                                    this.L$2 = sentinelFileContent;
                                    this.L$3 = var5_7 /* !! */ ;
                                    this.label = 1;
                                    v5 = KbIndexerServiceImpl.access$indexAllDocs((KbIndexerServiceImpl)var5_7 /* !! */ , fsDir, (Continuation)this);
                                }
                                catch (LockObtainFailedException e) {
                                    KbIndexerServiceImpl.access$getLogger$p((KbIndexerServiceImpl)var5_7 /* !! */ ).debug("Could not obtain lock on index directory: " + e.getMessage() + ". Assuming another process is writing or has written.");
                                    Intrinsics.checkNotNull((Object)readyFile);
                                    hashInReadyFile = KbIndexerServiceImpl.access$waitForHashInReadyFile((KbIndexerServiceImpl)var5_7 /* !! */ , readyFile);
                                    if (hashInReadyFile != null && Intrinsics.areEqual((Object)hashInReadyFile, (Object)zipFileHash.element)) {
                                        KbIndexerServiceImpl.access$getLogger$p((KbIndexerServiceImpl)var5_7 /* !! */ ).debug("Ready file found. Index is ready for reading.");
                                        KbIndexerServiceImpl.access$get_indexState$p((KbIndexerServiceImpl)var5_7 /* !! */ ).setValue((Object)KbIndexerService.State.READY);
                                    } else {
                                        errorMessage = "Other process held the lock on the index directory, so we waited enough time, but\nit timed out, which means the other process had an issue on indexing.";
                                        KbIndexerServiceImpl.access$getLogger$p((KbIndexerServiceImpl)var5_7 /* !! */ ).warn(errorMessage);
                                        RagIndexerUtilsKt.reportKbRagIndexError$default(errorMessage, null, 2, null);
                                        KbIndexerServiceImpl.access$get_indexState$p((KbIndexerServiceImpl)var5_7 /* !! */ ).setValue((Object)KbIndexerService.State.ERROR);
                                        KbIndexerServiceImpl.access$updateSentinelFileForError((KbIndexerServiceImpl)var5_7 /* !! */ , readyFile, (String)zipFileHash.element);
                                        v6 = KbIndexerServiceImpl.access$getIndexDirectory$p((KbIndexerServiceImpl)var5_7 /* !! */ );
                                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"access$getIndexDirectory$p(...)");
                                        PathsKt.deleteRecursively((Path)v6);
                                    }
                                    ** GOTO lbl109
                                }
                            }
                            catch (Throwable var8_12) {
                                var6_8 = var8_12;
                                throw var8_12;
                            }
                            catch (Throwable var8_13) {
                                throw var8_13;
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof CancellationException != false) throw e;
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            KbIndexerServiceImpl.access$getLogger$p(this.this$0).warn("Error initializing indexer: " + e.getMessage());
                            KbIndexerServiceImpl.access$getLogger$p(this.this$0).warn(ExceptionsKt.stackTraceToString((Throwable)e));
                            RagIndexerUtilsKt.reportKbRagIndexError("Error initializing indexer: " + e.getMessage(), e);
                            KbIndexerServiceImpl.access$get_indexState$p(this.this$0).setValue((Object)KbIndexerService.State.ERROR);
                            Intrinsics.checkNotNull((Object)readyFile);
                            KbIndexerServiceImpl.access$updateSentinelFileForError(this.this$0, readyFile, (String)zipFileHash.element);
                            v7 = KbIndexerServiceImpl.access$getIndexDirectory$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"access$getIndexDirectory$p(...)");
                            PathsKt.deleteRecursively((Path)v7);
                            return Unit.INSTANCE;
                        }
                        v8 = v5;
                        if (v5 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl102
                    }
                    case 1: {
                        $i$a$-use-KbIndexerServiceImpl$setUpIndex$1$1 = false;
                        var6_8 = null;
                        var5_7 /* !! */  = (FileAttribute[])this.L$3;
                        sentinelFileContent = (Closeable)this.L$2;
                        zipFileHash = (Ref.ObjectRef)this.L$1;
                        readyFile = (Path)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v8 = $result;
lbl102:
                            // 2 sources

                            Intrinsics.checkNotNull((Object)readyFile);
                            v9 = new Gson().toJson((Object)new SentinelFileContent(false, (String)zipFileHash.element));
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toJson(...)");
                            PathsKt.writeText$default((Path)readyFile, (CharSequence)v9, null, (OpenOption[])new OpenOption[0], (int)2, null);
                            var9_14 = new Object[]{readyFile};
                            KbIndexerServiceImpl.access$getLogger$p((KbIndexerServiceImpl)var5_7 /* !! */ ).debug("Ready file created: {}", var9_14);
                            KbIndexerServiceImpl.access$get_indexState$p((KbIndexerServiceImpl)var5_7 /* !! */ ).setValue((Object)KbIndexerService.State.READY);
                        }
lbl109:
                        // 3 sources

                        var7_9 = Unit.INSTANCE;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void updateSentinelFileForError(Path readyFile, String zipHash) {
        Files.deleteIfExists(readyFile);
        SentinelFileContent sentinelFileContent = new SentinelFileContent(true, zipHash);
        String string = new Gson().toJson((Object)sentinelFileContent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        PathsKt.writeText$default((Path)readyFile, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveKbZip() {
        Path path2;
        Path $this$resolveKbZip_u24lambda_u240 = path2 = this.baseDirectory.resolve("kbzip");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$resolveKbZip_u24lambda_u240);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$resolveKbZip_u24lambda_u240, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path kbZipBaseDir = path2;
        Path kbZipPath = kbZipBaseDir.resolve("dac_kb.zip");
        Closeable closeable = new FileOutputStream(kbZipPath.toFile());
        Throwable throwable = null;
        try {
            Long l2;
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl2 = false;
            InputStream inputStream = NetworkCache.findData$default((NetworkCache)this.kbZipDownloader, (String)"dac_kb.zip", (boolean)false, (int)2, null);
            if (inputStream == null) {
                this.logger.warn("Unable to download nor find bundled kb.zip");
                RagIndexerUtilsKt.reportKbRagIndexError$default("Unable to download nor find bundled kb.zip", null, 2, null);
                l2 = Unit.INSTANCE;
            } else {
                l2 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            Long l3 = l2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNull((Object)kbZipPath);
        return ((Object)kbZipPath).toString();
    }

    private final IndexWriter createIndexWriter(FSDirectory fsDir) {
        IndexWriterConfig indexWriterConfig;
        IndexWriterConfig config2 = indexWriterConfig = new IndexWriterConfig((Analyzer)this.analyzer);
        boolean bl = false;
        config2.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config2.setSimilarity((Similarity)this.createSimilarity());
        IndexWriterConfig iwc = indexWriterConfig;
        return new IndexWriter((Directory)fsDir, iwc);
    }

    private final BM25Similarity createSimilarity() {
        return new BM25Similarity(1.25f, 0.3f);
    }

    private final String getZipFileHash() {
        String string;
        String string2 = this.zipPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipPath");
            string2 = null;
        }
        FileInputStream fileInputStream = KbIndexerUtilsKt.getZipFileStream(string2, this.logger);
        if (fileInputStream != null) {
            FileInputStream it = fileInputStream;
            boolean bl = false;
            string = KbIndexerUtilsKt.getFileHash$default(it, 0, 2, null);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object indexAllDocs(FSDirectory var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof indexAllDocs.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ KbIndexerServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KbIndexerServiceImpl.access$indexAllDocs(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = (Closeable)this.createIndexWriter((FSDirectory)fsDir);
                var4_7 = null;
                indexWriter = (IndexWriter)var3_6;
                $i$a$-use-KbIndexerServiceImpl$indexAllDocs$2 = false;
                counter = new Ref.IntRef();
                v0 = this.zipPath;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"zipPath");
                    v0 = null;
                }
                if ((stream = KbIndexerUtilsKt.getZipFileStream(v0, this.logger)) == null) ** GOTO lbl45
                $continuation.L$0 = var3_6;
                $continuation.L$1 = indexWriter;
                $continuation.L$2 = counter;
                $continuation.label = 1;
                v1 = KbIndexerUtilsKt.processZipFile(stream, (Function1<? super KbDocFile, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, indexAllDocs$lambda$0$0(com.google.aiplugin.rag.doc.KbIndexerServiceImpl org.apache.lucene.index.IndexWriter kotlin.jvm.internal.Ref$IntRef com.google.aiplugin.rag.doc.KbDocFile ), (Lcom/google/aiplugin/rag/doc/KbDocFile;)Lkotlin/Unit;)((KbIndexerServiceImpl)this, (IndexWriter)indexWriter, (Ref.IntRef)counter), (Continuation<? super Unit>)$continuation);
                ** if (v1 != var11_5) goto lbl31
lbl30:
                // 1 sources

                return var11_5;
lbl31:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-use-KbIndexerServiceImpl$indexAllDocs$2 = false;
                counter = (Ref.IntRef)$continuation.L$2;
                indexWriter = (IndexWriter)$continuation.L$1;
                var4_7 = null;
                var3_6 = (Closeable)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 2 sources

                    if (counter.element > 0) {
                        indexWriter.commit();
                    }
lbl45:
                    // 4 sources

                    this.logger.debug("Index created with " + counter.element + " items and committed.");
                    var5_8 = Unit.INSTANCE;
                    ** GOTO lbl57
                }
                catch (Throwable var6_11) {
                    var4_7 = var6_11;
                    throw var6_11;
                }
            }
            catch (Throwable var6_12) {
                throw var6_12;
            }
            {
                finally {
                    CloseableKt.closeFinally((Closeable)var3_6, (Throwable)var4_7);
                }
lbl57:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final DocIndexStatus getDocIndexStatus(DirectoryReader directoryReader, String url, String content2) {
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
        TermQuery query = new TermQuery(new Term("relative_url", url));
        TopDocs topDocs = searcher.search((Query)query, 1);
        Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            Document doc = searcher.storedFields().document(scoreDoc.doc);
            if (!Intrinsics.areEqual((Object)doc.get("relative_url"), (Object)url)) continue;
            return Intrinsics.areEqual((Object)doc.get("contents"), (Object)content2) ? DocIndexStatus.upToDate : DocIndexStatus.outdated;
        }
        return DocIndexStatus.missing;
    }

    private final String waitForHashInReadyFile(Path readyFile) {
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(readyFile, this, null){
            int label;
            final /* synthetic */ Path $readyFile;
            final /* synthetic */ KbIndexerServiceImpl this$0;
            {
                this.$readyFile = $readyFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeoutOrNull((long)30000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$readyFile, this.this$0, null){
                            int label;
                            final /* synthetic */ Path $readyFile;
                            final /* synthetic */ KbIndexerServiceImpl this$0;
                            {
                                this.$readyFile = $readyFile;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 2 sources

                                        while (true) {
                                            v0 = new LinkOption[]{};
                                            if (Files.exists(this.$readyFile, Arrays.copyOf(v0, v0.length))) break block0;
                                            KbIndexerServiceImpl.access$getLogger$p(this.this$0).debug("Waiting for index_ready.json to appear...");
                                            this.label = 1;
                                            v1 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                                            if (v1 != var2_2) continue;
                                            return var2_2;
                                        }
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** continue;
                                    }
                                }
                                return ((SentinelFileContent)new Gson().fromJson(PathsKt.readText$default((Path)this.$readyFile, null, (int)1, null), SentinelFileContent.class)).getZipHash();
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void index(IndexWriter indexWriter, KbDocFile kbDocFile) {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("filepath", kbDocFile.getFilePath(), Field.Store.YES));
        doc.add((IndexableField)new TextField("summary", kbDocFile.getSummary(), Field.Store.NO));
        doc.add((IndexableField)new TextField("contents", kbDocFile.getContent(), Field.Store.NO));
        for (Map.Entry<String, String> entry : kbDocFile.getMetadata().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)"relative_url")) {
                doc.add((IndexableField)new StringField(key, value, Field.Store.YES));
                continue;
            }
            doc.add((IndexableField)new TextField(key, value, Field.Store.NO));
        }
        indexWriter.addDocument((Iterable)doc);
    }

    private final Query buildMultiFieldSearchQuery(String query) {
        String[] stringArray = new String[]{"contents", "title", "keywords"};
        String[] $this$buildMultiFieldSearchQuery_u24lambda_u240 = stringArray = new MultiFieldQueryParser(stringArray, (Analyzer)this.analyzer);
        boolean bl = false;
        $this$buildMultiFieldSearchQuery_u24lambda_u240.setAllowLeadingWildcard(false);
        $this$buildMultiFieldSearchQuery_u24lambda_u240.setEnablePositionIncrements(false);
        String[] queryParser = stringArray;
        Query query2 = queryParser.parse(query);
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"parse(...)");
        return query2;
    }

    private final Query buildCombinedSearchQuery(String query) {
        PhraseQuery.Builder builder;
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List terms = regex.split(charSequence, n);
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        PhraseQuery.Builder $this$buildCombinedSearchQuery_u24lambda_u240 = builder = new PhraseQuery.Builder().setSlop(2);
        boolean bl = false;
        for (String term : terms) {
            $this$buildCombinedSearchQuery_u24lambda_u240.add(new Term("title", term));
        }
        PhraseQuery titlePhraseQuery = builder.build();
        BoostQuery boostedTitlePhraseQuery = new BoostQuery((Query)titlePhraseQuery, 20.0f);
        combinedQueryBuilder.add((Query)boostedTitlePhraseQuery, BooleanClause.Occur.SHOULD);
        PhraseQuery.Builder $this$buildCombinedSearchQuery_u24lambda_u241 = bl = new PhraseQuery.Builder().setSlop(0);
        boolean bl2 = false;
        for (String term : terms) {
            $this$buildCombinedSearchQuery_u24lambda_u241.add(new Term("contents", term));
        }
        PhraseQuery contentsPhraseQuery = bl.build();
        combinedQueryBuilder.add((Query)new BoostQuery((Query)contentsPhraseQuery, 10.0f), BooleanClause.Occur.SHOULD);
        PhraseQuery.Builder $this$buildCombinedSearchQuery_u24lambda_u242 = $this$buildCombinedSearchQuery_u24lambda_u241 = new BooleanQuery.Builder();
        boolean bl3 = false;
        for (String term : terms) {
            TermQuery termQuery = new TermQuery(new Term("title", term));
            $this$buildCombinedSearchQuery_u24lambda_u242.add((Query)new BoostQuery((Query)termQuery, 10.0f), BooleanClause.Occur.SHOULD);
        }
        for (String term : terms) {
            $this$buildCombinedSearchQuery_u24lambda_u242.add((Query)new TermQuery(new Term("contents", term)), BooleanClause.Occur.SHOULD);
        }
        PhraseQuery.Builder booleanTermQueryBuilder = $this$buildCombinedSearchQuery_u24lambda_u241;
        int minMatches = MathKt.roundToInt((float)((float)terms.size() * 0.4f));
        if (minMatches > 0) {
            booleanTermQueryBuilder.setMinimumNumberShouldMatch(minMatches);
        }
        combinedQueryBuilder.add((Query)booleanTermQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        BooleanQuery booleanQuery = combinedQueryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"build(...)");
        return (Query)booleanQuery;
    }

    @Override
    @NotNull
    public List<Tool<?>> getKbTools() {
        List list;
        if (StudioBotFlags.Companion.getInstance().isKbEnabled() && this.getIndexState().getValue() == KbIndexerService.State.READY) {
            Object[] objectArray = new Tool[]{new KbSearchTool(), new KbArticleLookupTool()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KbSearchResult search(@NotNull String query, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (this.getIndexState().getValue() != KbIndexerService.State.READY) {
            return new KbSearchResult(CollectionsKt.emptyList());
        }
        String escapedQuery = QueryParser.escape((String)query);
        List results = new ArrayList();
        Closeable closeable = (Closeable)FSDirectory.open((Path)this.indexDirectory);
        Throwable throwable = null;
        try {
            FSDirectory fsDir = (FSDirectory)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)fsDir));
            Throwable throwable2 = null;
            try {
                IndexSearcher indexSearcher;
                DirectoryReader index = (DirectoryReader)closeable2;
                boolean bl2 = false;
                this.logger.debug("Searching index version " + index.getVersion() + ", #docs " + index.numDocs());
                IndexSearcher it = indexSearcher = new IndexSearcher((IndexReader)index);
                boolean bl3 = false;
                it.setSimilarity((Similarity)this.createSimilarity());
                IndexSearcher searcher = indexSearcher;
                Intrinsics.checkNotNull((Object)escapedQuery);
                Query searchQuery = this.buildMultiFieldSearchQuery(escapedQuery);
                StoredFields storedFields = searcher.storedFields();
                TopDocs topDocs = searcher.search(searchQuery, maxResults);
                Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    KbDocFile kbDoc;
                    this.logger.debug("Found doc #" + scoreDoc.doc);
                    Object[] objectArray = new String[]{"relative_url", "filepath"};
                    Document doc = storedFields.document(scoreDoc.doc, SetsKt.setOf((Object[])objectArray));
                    String url = doc.get("relative_url");
                    Intrinsics.checkNotNull((Object)doc);
                    Intrinsics.checkNotNull((Object)url);
                    if (this.readDoc(doc, url) == null) continue;
                    String string = kbDoc.getMetadata().get("title");
                    if (string == null) {
                        string = "";
                    }
                    String string2 = kbDoc.getSummary();
                    String string3 = kbDoc.getMetadata().get("keywords");
                    if (string3 == null) {
                        string3 = "";
                    }
                    results.add(new KbSearchResultDoc(url, string, string2, string3));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new KbSearchResult(results);
    }

    private final String trimFetchedDoc(String content2) {
        return content2.length() > 240000 ? StringsKt.take((String)content2, (int)240000) : content2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KbFetchResult fetchByRelativeUrls(@NotNull List<String> relativeUrls) {
        Intrinsics.checkNotNullParameter(relativeUrls, (String)"relativeUrls");
        List results = new ArrayList();
        if (relativeUrls.isEmpty() || this.getIndexState().getValue() != KbIndexerService.State.READY) {
            return new KbFetchResult(CollectionsKt.emptyList());
        }
        Set urls = CollectionsKt.toSet((Iterable)relativeUrls);
        Closeable closeable = (Closeable)FSDirectory.open((Path)this.indexDirectory);
        Throwable throwable = null;
        try {
            FSDirectory fsDir = (FSDirectory)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)fsDir));
            Throwable throwable2 = null;
            try {
                DirectoryReader index = (DirectoryReader)closeable2;
                boolean bl2 = false;
                this.logger.debug("Searching index version " + index.getVersion() + ", #docs " + index.numDocs());
                IndexSearcher searcher = new IndexSearcher((IndexReader)index);
                BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
                for (String url : urls) {
                    TermQuery termQuery = new TermQuery(new Term("relative_url", url));
                    booleanQueryBuilder.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                }
                BooleanQuery query = booleanQueryBuilder.build();
                TopDocs topDocs = searcher.search((Query)query, urls.size());
                Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    KbDocFile kbDoc;
                    this.logger.debug("Found doc #" + scoreDoc.doc);
                    Document doc = searcher.storedFields().document(scoreDoc.doc);
                    String url = doc.get("relative_url");
                    Intrinsics.checkNotNull((Object)doc);
                    Intrinsics.checkNotNull((Object)url);
                    if (this.readDoc(doc, url) == null) continue;
                    String string = kbDoc.getMetadata().get("title");
                    if (string == null) {
                        string = "";
                    }
                    String string2 = kbDoc.getSummary();
                    String string3 = kbDoc.getMetadata().get("keywords");
                    if (string3 == null) {
                        string3 = "";
                    }
                    results.add(new KbDoc(url, string, string2, string3, this.trimFetchedDoc(kbDoc.getContent())));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new KbFetchResult(results);
    }

    private final KbDocFile readDoc(Document doc, String url) {
        String string = this.zipPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipPath");
            string = null;
        }
        String string2 = doc.get("filepath");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        KbDocFile kbDocFile = KbIndexerUtilsKt.getDocInfo(string, string2, this.logger);
        if (kbDocFile == null) {
            return null;
        }
        KbDocFile kbDoc = kbDocFile;
        if (!Intrinsics.areEqual((Object)kbDoc.getMetadata().get("relative_url"), (Object)url)) {
            String errorMessage = "Doc " + doc.get("filepath") + " has URL " + kbDoc.getMetadata().get("relative_url") + " different from " + url;
            this.logger.warn(errorMessage);
            RagIndexerUtilsKt.reportKbRagIndexError$default(errorMessage, null, 2, null);
            return null;
        }
        return kbDoc;
    }

    public void dispose() {
        if (this.indexerJob != null) {
            Job job2 = this.indexerJob;
            if (job2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"indexerJob");
                job2 = null;
            }
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        if (this._indexState.getValue() != KbIndexerService.State.READY) {
            Path path2 = this.indexDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"indexDirectory");
            PathsKt.deleteRecursively((Path)path2);
        }
    }

    private static final Unit indexAllDocs$lambda$0$0(KbIndexerServiceImpl this$0, IndexWriter $indexWriter, Ref.IntRef $counter, KbDocFile kbDocFile) {
        Intrinsics.checkNotNullParameter((Object)kbDocFile, (String)"kbDocFile");
        this$0.index($indexWriter, kbDocFile);
        ++$counter.element;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p(KbIndexerServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Path access$getIndexDirectory$p(KbIndexerServiceImpl $this) {
        return $this.indexDirectory;
    }

    public static final /* synthetic */ void access$setZipPath$p(KbIndexerServiceImpl $this, String string) {
        $this.zipPath = string;
    }

    public static final /* synthetic */ String access$resolveKbZip(KbIndexerServiceImpl $this) {
        return $this.resolveKbZip();
    }

    public static final /* synthetic */ String access$getZipFileHash(KbIndexerServiceImpl $this) {
        return $this.getZipFileHash();
    }

    public static final /* synthetic */ MutableStateFlow access$get_indexState$p(KbIndexerServiceImpl $this) {
        return $this._indexState;
    }

    public static final /* synthetic */ void access$updateSentinelFileForError(KbIndexerServiceImpl $this, Path readyFile, String zipHash) {
        $this.updateSentinelFileForError(readyFile, zipHash);
    }

    public static final /* synthetic */ Object access$indexAllDocs(KbIndexerServiceImpl $this, FSDirectory fsDir, Continuation $completion) {
        return $this.indexAllDocs(fsDir, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ String access$waitForHashInReadyFile(KbIndexerServiceImpl $this, Path readyFile) {
        return $this.waitForHashInReadyFile(readyFile);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl$DocIndexStatus;", "", "<init>", "(Ljava/lang/String;I)V", "missing", "outdated", "upToDate", "Companion", "aiplugin.rag.kb"})
    private static final class DocIndexStatus
    extends Enum<DocIndexStatus> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final DocIndexStatus default;
        public static final /* enum */ DocIndexStatus missing;
        public static final /* enum */ DocIndexStatus outdated;
        public static final /* enum */ DocIndexStatus upToDate;
        private static final /* synthetic */ DocIndexStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DocIndexStatus[] values() {
            return (DocIndexStatus[])$VALUES.clone();
        }

        public static DocIndexStatus valueOf(String value) {
            return Enum.valueOf(DocIndexStatus.class, value);
        }

        @NotNull
        public static EnumEntries<DocIndexStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            missing = new DocIndexStatus();
            outdated = new DocIndexStatus();
            upToDate = new DocIndexStatus();
            $VALUES = docIndexStatusArray = new DocIndexStatus[]{DocIndexStatus.missing, DocIndexStatus.outdated, DocIndexStatus.upToDate};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            default = missing;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl$DocIndexStatus$Companion;", "", "<init>", "()V", "default", "Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl$DocIndexStatus;", "getDefault", "()Lcom/google/aiplugin/rag/doc/KbIndexerServiceImpl$DocIndexStatus;", "aiplugin.rag.kb"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DocIndexStatus getDefault() {
                return default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

