/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.codemap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\r*\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020%H\u0016J\f\u0010&\u001a\u00020\r*\u00020%H\u0002J\f\u0010'\u001a\u00020\r*\u00020%H\u0002J\u000f\u0010(\u001a\u0004\u0018\u00010)*\u00020*H\u0082\u0010J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020,H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020\r*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u0004\u0018\u000100*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u0004\u0018\u000104*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Lcom/google/aiplugin/rag/codemap/CodeMapUastVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "declarationsToRender", "", "Lorg/jetbrains/uast/UDeclaration;", "<init>", "(Ljava/util/Set;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "visitFile", "", "node", "Lorg/jetbrains/uast/UFile;", "callStack", "", "Lorg/jetbrains/uast/UCallExpression;", "afterVisitFile", "", "indent", "", "putIndent", "visitClass", "Lorg/jetbrains/uast/UClass;", "isCompanion", "renderClassKeyword", "afterVisitClass", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "afterVisitMethod", "visitCallExpression", "afterVisitCallExpression", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "isReceiver", "isSelector", "outermostQualifiedReferenceExpression", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "Lorg/jetbrains/uast/UElement;", "visitComment", "Lorg/jetbrains/uast/UComment;", "isSynthetic", "(Lorg/jetbrains/uast/UElement;)Z", "nameFromSource", "", "getNameFromSource", "(Lorg/jetbrains/uast/UElement;)Ljava/lang/String;", "typeFromPsi", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/uast/UVariable;", "getTypeFromPsi", "(Lorg/jetbrains/uast/UVariable;)Lcom/intellij/psi/PsiType;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nCodeMapUastVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeMapUastVisitor.kt\ncom/google/aiplugin/rag/codemap/CodeMapUastVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n774#2:350\n865#2,2:351\n1#3:353\n*S KotlinDebug\n*F\n+ 1 CodeMapUastVisitor.kt\ncom/google/aiplugin/rag/codemap/CodeMapUastVisitor\n*L\n82#1:350\n82#1:351,2\n*E\n"})
public final class CodeMapUastVisitor
extends AbstractUastVisitor {
    @Nullable
    private final Set<UDeclaration> declarationsToRender;
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final List<UCallExpression> callStack;
    private int indent;

    public CodeMapUastVisitor(@Nullable Set<? extends UDeclaration> declarationsToRender) {
        this.declarationsToRender = declarationsToRender;
        this.builder = new StringBuilder();
        this.callStack = new ArrayList();
    }

    public /* synthetic */ CodeMapUastVisitor(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = null;
        }
        this(set);
    }

    @NotNull
    public final StringBuilder getBuilder() {
        return this.builder;
    }

    public boolean visitFile(@NotNull UFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.builder.append("package ");
        this.builder.append(node.getPackageName());
        this.builder.append('\n');
        return super.visitFile(node);
    }

    public void afterVisitFile(@NotNull UFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.callStack.clear();
        super.afterVisitFile(node);
    }

    private final void putIndent() {
        if (this.indent <= 0) {
            return;
        }
        this.builder.append(StringsKt.repeat((CharSequence)" ", (int)this.indent));
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isSynthetic((UElement)node)) {
            return super.visitClass(node);
        }
        if (this.declarationsToRender != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getUastDeclarations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UDeclaration it = (UDeclaration)element$iv$iv;
                boolean bl = false;
                if (!this.declarationsToRender.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List membersToRender = (List)destination$iv$iv;
            if (!this.declarationsToRender.contains(node) && membersToRender.isEmpty()) {
                return true;
            }
            ImplementationUtilsKt.acceptList((List)node.getComments(), (UastVisitor)((UastVisitor)this));
            this.putIndent();
            this.renderClassKeyword(node);
            this.builder.append(" {");
            this.builder.append('\n');
            this.indent += 2;
            ImplementationUtilsKt.acceptList((List)membersToRender, (UastVisitor)((UastVisitor)this));
            this.indent -= 2;
            this.putIndent();
            this.builder.append("}");
            this.builder.append('\n');
            return true;
        }
        ImplementationUtilsKt.acceptList((List)node.getComments(), (UastVisitor)((UastVisitor)this));
        this.putIndent();
        this.renderClassKeyword(node);
        this.builder.append(" {");
        this.builder.append('\n');
        this.indent += 2;
        return super.visitClass(node);
    }

    private final boolean isCompanion(UClass $this$isCompanion) {
        PsiElement psiElement = $this$isCompanion.getSourcePsi();
        KtObjectDeclaration ktObjectDeclaration = psiElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement : null;
        return ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
    }

    private final void renderClassKeyword(UClass node) {
        if (node.isInterface()) {
            this.builder.append("interface ");
            v0 = this.builder.append(this.getNameFromSource((UElement)node));
        } else if (this.isCompanion(node)) {
            v0 = this.builder.append("companion object");
        } else {
            this.builder.append("class ");
            v0 = this.builder.append(this.getNameFromSource((UElement)node));
        }
    }

    public void afterVisitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.declarationsToRender != null) {
            return;
        }
        if (this.isSynthetic((UElement)node)) {
            return;
        }
        this.indent -= 2;
        this.putIndent();
        this.builder.append("}");
        this.builder.append('\n');
        super.afterVisitClass(node);
    }

    public boolean visitField(@NotNull UField node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isSynthetic((UElement)node)) {
            return super.visitField(node);
        }
        ImplementationUtilsKt.acceptList((List)node.getComments(), (UastVisitor)((UastVisitor)this));
        this.putIndent();
        this.builder.append("field ");
        this.builder.append(this.getNameFromSource((UElement)node));
        PsiType psiType = this.getTypeFromPsi((UVariable)node);
        if (psiType != null) {
            PsiType fieldType = psiType;
            boolean bl = false;
            this.builder.append(": " + fieldType.getPresentableText());
        }
        this.builder.append('\n');
        return super.visitField(node);
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Object object;
        String params;
        block7: {
            block6: {
                PsiType psiType;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.isSynthetic((UElement)node)) {
                    return super.visitMethod(node);
                }
                ImplementationUtilsKt.acceptList((List)node.getComments(), (UastVisitor)((UastVisitor)this));
                this.putIndent();
                if (!node.isConstructor()) {
                    this.builder.append("method ");
                }
                this.builder.append(node.getName());
                params = CollectionsKt.joinToString$default((Iterable)node.getUastParameters(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> CodeMapUastVisitor.visitMethod$lambda$0(this, arg_0), (int)30, null);
                object = node.getReturnType();
                if (object == null) break block6;
                PsiType it = psiType = object;
                boolean bl = false;
                object = !Intrinsics.areEqual((Object)it, (Object)PsiTypes.voidType()) ? psiType : null;
                if (object == null) break block6;
                Object it2 = object;
                boolean bl2 = false;
                String string = ": " + it2.getPresentableText();
                object = string;
                if (string != null) break block7;
            }
            object = "";
        }
        Object returnType = object;
        this.builder.append("(" + params + ")" + (String)returnType);
        if (node.getUastBody() != null) {
            this.builder.append(" {");
            this.indent += 2;
        }
        this.builder.append('\n');
        return super.visitMethod(node);
    }

    public void afterVisitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isSynthetic((UElement)node)) {
            return;
        }
        if (node.getUastBody() != null) {
            this.indent -= 2;
            this.putIndent();
            this.builder.append("}");
            this.builder.append('\n');
        }
        super.afterVisitMethod(node);
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        String methodName;
        UReferenceExpression uReferenceExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!((Collection)this.callStack).isEmpty()) {
            this.callStack.add(node);
            return super.visitCallExpression(node);
        }
        String string = UastExpressionUtils.isConstructorCall((UElement)((UElement)node)) ? ((uReferenceExpression = node.getClassReference()) != null && (uReferenceExpression = uReferenceExpression.getSourcePsi()) != null ? uReferenceExpression.getText() : null) : (methodName = node.getMethodName());
        if (methodName == null) {
            return super.visitCallExpression(node);
        }
        this.callStack.add(node);
        this.putIndent();
        Object object = node.getReceiver();
        if (object != null && (object = object.getSourcePsi()) != null && (object = object.getText()) != null) {
            Object it = object;
            boolean bl = false;
            this.builder.append((String)it);
            this.builder.append(".");
        }
        this.builder.append(methodName);
        boolean hasLambdaArgumentOnly = node.getValueArgumentCount() == 1 && CollectionsKt.single((List)node.getValueArguments()) instanceof ULambdaExpression;
        String prefix = hasLambdaArgumentOnly ? " " : "(";
        String postfix = hasLambdaArgumentOnly ? "" : ")";
        String args = CollectionsKt.joinToString$default((Iterable)node.getValueArguments(), (CharSequence)", ", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, CodeMapUastVisitor::visitCallExpression$lambda$1, (int)24, null);
        this.builder.append(args);
        this.builder.append('\n');
        return super.visitCallExpression(node);
    }

    public void afterVisitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!((Collection)this.callStack).isEmpty()) {
            UCallExpression last = this.callStack.removeLast();
            boolean bl = Intrinsics.areEqual((Object)last, (Object)node);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        super.afterVisitCallExpression(node);
    }

    public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!((Collection)this.callStack).isEmpty()) {
            return super.visitSimpleNameReferenceExpression(node);
        }
        if (this.isReceiver(node)) {
            return super.visitSimpleNameReferenceExpression(node);
        }
        PsiElement psiElement = node.resolve();
        if (psiElement == null) {
            return super.visitSimpleNameReferenceExpression(node);
        }
        PsiElement resolved = psiElement;
        if (this.isSelector(node)) {
            UElement uElement = node.getUastParent();
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
            UQualifiedReferenceExpression parent = (UQualifiedReferenceExpression)uElement;
            UQualifiedReferenceExpression outermost = this.outermostQualifiedReferenceExpression((UElement)node);
            if (Intrinsics.areEqual((Object)outermost, (Object)parent)) {
                this.putIndent();
                Object object = outermost.getSourcePsi();
                if (object == null || (object = object.getText()) == null) {
                    object = resolved.getText();
                }
                this.builder.append((String)object);
                this.builder.append('\n');
                return super.visitSimpleNameReferenceExpression(node);
            }
            return super.visitSimpleNameReferenceExpression(node);
        }
        this.putIndent();
        Object object = node.getSourcePsi();
        if (object == null || (object = object.getText()) == null) {
            object = resolved.getText();
        }
        this.builder.append((String)object);
        this.builder.append('\n');
        return super.visitSimpleNameReferenceExpression(node);
    }

    private final boolean isReceiver(USimpleNameReferenceExpression $this$isReceiver) {
        UElement uElement = $this$isReceiver.getUastParent();
        UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
        if (uQualifiedReferenceExpression == null) {
            return false;
        }
        UQualifiedReferenceExpression parent = uQualifiedReferenceExpression;
        return Intrinsics.areEqual((Object)parent.getReceiver(), (Object)$this$isReceiver);
    }

    private final boolean isSelector(USimpleNameReferenceExpression $this$isSelector) {
        UElement uElement = $this$isSelector.getUastParent();
        UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
        if (uQualifiedReferenceExpression == null) {
            return false;
        }
        UQualifiedReferenceExpression parent = uQualifiedReferenceExpression;
        return Intrinsics.areEqual((Object)parent.getSelector(), (Object)$this$isSelector);
    }

    private final UQualifiedReferenceExpression outermostQualifiedReferenceExpression(UElement $this$outermostQualifiedReferenceExpression) {
        CodeMapUastVisitor codeMapUastVisitor = this;
        while (true) {
            Object object;
            UQualifiedReferenceExpression parent;
            UQualifiedReferenceExpression uQualifiedReferenceExpression = parent = (object = $this$outermostQualifiedReferenceExpression.getUastParent()) instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)object : null;
            if (parent == null) break;
            object = codeMapUastVisitor;
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = parent;
            codeMapUastVisitor = object;
            $this$outermostQualifiedReferenceExpression = (UElement)uQualifiedReferenceExpression2;
        }
        return $this$outermostQualifiedReferenceExpression instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)$this$outermostQualifiedReferenceExpression : null;
    }

    public boolean visitComment(@NotNull UComment node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.putIndent();
        this.builder.append(node.getText());
        this.builder.append('\n');
        return super.visitComment(node);
    }

    private final boolean isSynthetic(UElement $this$isSynthetic) {
        return $this$isSynthetic.getSourcePsi() == null;
    }

    private final String getNameFromSource(UElement $this$nameFromSource) {
        PsiElement psiElement = $this$nameFromSource.getSourcePsi();
        Object object = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        if (object == null || (object = object.getName()) == null) {
            PsiElement psiElement2 = $this$nameFromSource.getJavaPsi();
            PsiNamedElement psiNamedElement = psiElement2 instanceof PsiNamedElement ? (PsiNamedElement)psiElement2 : null;
            object = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        return object;
    }

    private final PsiType getTypeFromPsi(UVariable $this$typeFromPsi) {
        Object object;
        if ($this$typeFromPsi instanceof UField) {
            object = ((UField)$this$typeFromPsi).getType();
        } else {
            PsiElement psiElement = $this$typeFromPsi.getJavaPsi();
            PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
            object = psiVariable != null ? psiVariable.getType() : null;
        }
        return object;
    }

    private static final CharSequence visitMethod$lambda$0(CodeMapUastVisitor this$0, UParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.getTypeFromPsi((UVariable)it);
        if (object == null || (object = object.getPresentableText()) == null) {
            object = "<error type>";
        }
        Object parameterType = object;
        return this$0.getNameFromSource((UElement)it) + ": " + (String)parameterType;
    }

    private static final CharSequence visitCallExpression$lambda$1(UExpression arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Object object = arg.getSourcePsi();
        return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
    }

    public CodeMapUastVisitor() {
        this(null, 1, null);
    }
}

