/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.android.studio.ml.bot.StudioBotFlags;
import com.google.aiplugin.rag.bm25.Bm25Indexer;
import com.google.aiplugin.rag.bm25.Bm25SearchTool;
import com.google.aiplugin.rag.bm25.Bm25UtilsKt;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.bm25.CrawlerBm25Indexer;
import com.google.aiplugin.rag.internal.CrawlerBasedRagIndexer;
import com.google.aiplugin.rag.internal.IndexRebuilder;
import com.google.aiplugin.rag.internal.IndexableFilesCrawlerKt;
import com.google.aiplugin.rag.internal.RagIndexerFactory;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.google.aiplugin.rag.lucene.LuceneIndexUtilsKt;
import com.google.aiplugin.rag.lucene.LuceneIndexWriterManagerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import org.HdrHistogram.Histogram;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 X2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002WXB3\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u0010J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010=\u001a\u00020'*\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u00020'*\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010>J\b\u0010@\u001a\u00020'H\u0002J\b\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020'2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020'2\u0006\u0010L\u001a\u00020\u001fH\u0016J\u0010\u0010M\u001a\u00020'2\u0006\u0010L\u001a\u00020\u001fH\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020'H\u0016J\b\u0010S\u001a\u00020'H\u0016J\b\u0010T\u001a\u00020'H\u0002J\n\u0010U\u001a\u0004\u0018\u00010VH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f00X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\u0002028\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020709X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/google/aiplugin/rag/bm25/CrawlerBm25Indexer;", "Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "Lcom/google/aiplugin/rag/internal/CrawlerBasedRagIndexer;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "indexDirectory", "Ljava/nio/file/Path;", "indexCommitInterval", "Lkotlin/time/Duration;", "searchTool", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Ljava/nio/file/Path;JLcom/google/aiplugin/rag/bm25/Bm25SearchTool;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "J", "getSearchTool", "()Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "analyzer", "Lcom/google/aiplugin/rag/bm25/CodeAnalyzer;", "getAnalyzer", "()Lcom/google/aiplugin/rag/bm25/CodeAnalyzer;", "similarity", "Lorg/apache/lucene/search/similarities/BM25Similarity;", "getSimilarity", "()Lorg/apache/lucene/search/similarities/BM25Similarity;", "numberOfIndexedDocs", "", "getNumberOfIndexedDocs", "createIndexWriterConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "releaseIndexWriter", "Lkotlin/Function0;", "", "indexingDurationInMillisHistogram", "Lorg/HdrHistogram/Histogram;", "histogramLock", "", "indexCommitter", "Lkotlinx/coroutines/Job;", "unindexCommitter", "unindexChannel", "Lkotlinx/coroutines/channels/Channel;", "hasUncommittedChanges", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHasUncommittedChanges", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "metricsLock", "metrics", "Lcom/google/aiplugin/rag/bm25/CrawlerBm25Indexer$Metrics;", "metricsQueue", "", "createIndexWriter", "fsDir", "Lorg/apache/lucene/store/FSDirectory;", "runIndexCommitter", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runUnindexCommitter", "reportMetrics", "openIndexReader", "Lorg/apache/lucene/index/IndexReader;", "updateMetrics", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "millis", "", "index", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "unindex", "fileId", "deleteIndex", "isIndexed", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "requestIndexRebuild", "rebuildCrawlerIndex", "getStatus", "", "Metrics", "Companion", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nCrawlerBm25Indexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrawlerBm25Indexer.kt\ncom/google/aiplugin/rag/bm25/CrawlerBm25Indexer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n24#2:420\n29#3,3:421\n1#4:424\n*S KotlinDebug\n*F\n+ 1 CrawlerBm25Indexer.kt\ncom/google/aiplugin/rag/bm25/CrawlerBm25Indexer\n*L\n93#1:420\n269#1:421,3\n*E\n"})
public final class CrawlerBm25Indexer
implements Bm25Indexer,
CrawlerBasedRagIndexer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final Path indexDirectory;
    private final long indexCommitInterval;
    @NotNull
    private final Bm25SearchTool searchTool;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CodeAnalyzer analyzer;
    @NotNull
    private final BM25Similarity similarity;
    private int numberOfIndexedDocs;
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final Function0<Unit> releaseIndexWriter;
    @NotNull
    private final Histogram indexingDurationInMillisHistogram;
    @NotNull
    private final Object histogramLock;
    @NotNull
    private final Job indexCommitter;
    @NotNull
    private final Job unindexCommitter;
    @NotNull
    private final Channel<Integer> unindexChannel;
    @VisibleForTesting
    @NotNull
    private final AtomicBoolean hasUncommittedChanges;
    @NotNull
    private final Object metricsLock;
    @NotNull
    private Metrics metrics;
    @NotNull
    private List<Metrics> metricsQueue;
    @Nullable
    private static Throwable creationTrace;
    @NotNull
    private static final Object creationTraceLock;
    private static final long INDEX_COMMIT_INTERVAL;
    private static final long MAX_MEASURED_LATENCY_MS = 10000L;

    private CrawlerBm25Indexer(CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval, Bm25SearchTool searchTool) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)indexDirectory, (String)"indexDirectory");
        Intrinsics.checkNotNullParameter((Object)searchTool, (String)"searchTool");
        this.scope = scope2;
        this.ioDispatcher = ioDispatcher;
        this.indexDirectory = indexDirectory;
        this.indexCommitInterval = indexCommitInterval;
        this.searchTool = searchTool;
        CrawlerBm25Indexer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CrawlerBm25Indexer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.analyzer = new CodeAnalyzer(null, 1, null);
        this.similarity = new BM25Similarity();
        if (StudioBotFlags.Companion.getInstance().useLucindexForRag()) {
            this.indexWriter = LuceneIndexWriterManagerService.Companion.getInstance().getIndexWriter(this.indexDirectory, this.createIndexWriterConfig());
            this.releaseIndexWriter = () -> CrawlerBm25Indexer._init_$lambda$0(this);
        } else {
            FSDirectory fsDir = FSDirectory.open((Path)this.indexDirectory);
            Intrinsics.checkNotNull((Object)fsDir);
            this.indexWriter = this.createIndexWriter(fsDir);
            this.releaseIndexWriter = () -> CrawlerBm25Indexer._init_$lambda$1(this, fsDir);
        }
        this.indexingDurationInMillisHistogram = new Histogram(10000L, 1);
        this.histogramLock = new Object();
        this.indexCommitter = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CrawlerBm25Indexer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.runIndexCommitter($this$launch, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.unindexCommitter = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CrawlerBm25Indexer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.runUnindexCommitter($this$launch, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.unindexChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.hasUncommittedChanges = new AtomicBoolean();
        this.metricsLock = new Object();
        this.metrics = new Metrics(0, 0, 0, 0, 0L, 31, null);
        this.metricsQueue = new ArrayList();
    }

    public /* synthetic */ CrawlerBm25Indexer(CoroutineScope coroutineScope, CoroutineDispatcher coroutineDispatcher, Path path2, long l2, Bm25SearchTool bm25SearchTool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bm25SearchTool = new Bm25SearchTool(false, 1, null);
        }
        this(coroutineScope, coroutineDispatcher, path2, l2, bm25SearchTool, null);
    }

    @NotNull
    public Bm25SearchTool getSearchTool() {
        return this.searchTool;
    }

    private CrawlerBm25Indexer(CoroutineScope scope2) {
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        Path path2 = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getSystemDir(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        path3 = path4;
        Path path5 = path3.resolve("gemini");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        path3 = path5;
        Path path6 = path3.resolve("bm25");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this(scope2, coroutineDispatcher, path6, INDEX_COMMIT_INTERVAL, null, 16, null);
    }

    @Override
    @NotNull
    public CodeAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @NotNull
    public BM25Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public int getNumberOfIndexedDocs() {
        return this.numberOfIndexedDocs;
    }

    private final IndexWriterConfig createIndexWriterConfig() {
        IndexWriterConfig indexWriterConfig;
        IndexWriterConfig $this$createIndexWriterConfig_u24lambda_u240 = indexWriterConfig = new IndexWriterConfig((Analyzer)this.getAnalyzer());
        boolean bl = false;
        $this$createIndexWriterConfig_u24lambda_u240.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        $this$createIndexWriterConfig_u24lambda_u240.setSimilarity((Similarity)this.getSimilarity());
        $this$createIndexWriterConfig_u24lambda_u240.setParentField("@internal:parent");
        return indexWriterConfig;
    }

    @NotNull
    public final AtomicBoolean getHasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    private final IndexWriter createIndexWriter(FSDirectory fsDir) {
        IndexWriter indexWriter;
        try {
            indexWriter = new IndexWriter((Directory)fsDir, this.createIndexWriterConfig());
        }
        catch (LockObtainFailedException e) {
            this.logger.warn("Could not obtain lock on index directory: " + e.getMessage());
            Path path2 = fsDir.getDirectory().resolve("write.lock");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            boolean deleted = Files.deleteIfExists(path2);
            this.logger.info("Deleting write.lock, status: " + deleted);
            indexWriter = new IndexWriter((Directory)fsDir, this.createIndexWriterConfig());
        }
        catch (Exception e) {
            if (e instanceof CancellationException || e instanceof ControlFlowException) {
                throw e;
            }
            RagIndexerUtilsKt.reportRagIndexError("Non-lock error creating IndexWriter - rebuilding index", e, this);
            FileUtil.deleteWithRenamingIfExists((Path)fsDir.getDirectory());
            this.rebuildCrawlerIndex();
            indexWriter = new IndexWriter((Directory)fsDir, this.createIndexWriterConfig());
        }
        return indexWriter;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object runIndexCommitter(@NotNull CoroutineScope var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof runIndexCommitter.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CrawlerBm25Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runIndexCommitter(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                }
                catch (Exception e) {
                    if (e instanceof CancellationException || e instanceof ControlFlowException) {
                        throw e;
                    }
                    RagIndexerUtilsKt.reportRagIndexError$default("In indexCommitter", e, null, 4, null);
                    return Unit.INSTANCE;
                }
lbl20:
                // 3 sources

                while (CoroutineScopeKt.isActive((CoroutineScope)$this$runIndexCommitter)) {
                    needsToCommit = this.indexWriter.hasUncommittedChanges();
                    this.hasUncommittedChanges.set(needsToCommit != false);
                    if (needsToCommit) {
                        this.indexWriter.commit();
                    }
                    this.reportMetrics();
                    this.numberOfIndexedDocs = this.indexWriter.getDocStats().numDocs;
                    $continuation.L$0 = $this$runIndexCommitter;
                    $continuation.label = 1;
                    v0 = DelayKt.delay-VtjQ1oo((long)this.indexCommitInterval, (Continuation)$continuation);
                    if (v0 != var6_5) continue;
                    return var6_5;
                }
                return Unit.INSTANCE;
            }
            case 1: {
                $this$runIndexCommitter = (CoroutineScope)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl20
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object runUnindexCommitter(@NotNull CoroutineScope var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof runUnindexCommitter.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CrawlerBm25Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runUnindexCommitter(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl14:
                // 2 sources

                while (CoroutineScopeKt.isActive((CoroutineScope)$this$runUnindexCommitter)) {
                    $continuation.L$0 = $this$runUnindexCommitter;
                    $continuation.label = 1;
                    v0 = v1 = this.unindexChannel.receive((Continuation)$continuation);
                }
                {
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl32
                    break;
                }
            }
            case 1: {
                $this$runUnindexCommitter = (CoroutineScope)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    var4_8 = ((Number)v1).intValue();
                    {
                        catch (ClosedReceiveChannelException e) {
                            this.logger.warn("Unindex channel closed", (Throwable)e);
                        }
                    }
                    fileIdToUnindex = var4_8;
                    this.deleteIndex(fileIdToUnindex);
                    ** GOTO lbl14
                }
                catch (Exception e) {
                    if (e instanceof CancellationException || e instanceof ControlFlowException) {
                        throw e;
                    }
                    RagIndexerUtilsKt.reportRagIndexError$default("In unindexCommitter", e, null, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportMetrics() {
        List metricsToSend = new ArrayList();
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            if (this.metrics.getIndexedFiles() > 0) {
                this.metricsQueue.add(this.metrics);
                this.metrics = new Metrics(0, 0, 0, 0, 0L, 31, null);
            }
            metricsToSend.addAll((Collection)this.metricsQueue);
            this.metricsQueue = new ArrayList();
            Unit unit = Unit.INSTANCE;
        }
        for (Metrics m : metricsToSend) {
            RagIndexerUtilsKt.reportRagIndexMetrics(m.getIndexedFiles(), m.getIndexedKtFiles(), m.getIndexedJavaFiles(), m.getIndexedGeneratedFiles(), m.getIndexingTimeMs() / (long)m.getIndexedFiles());
        }
    }

    @Override
    @NotNull
    public IndexReader openIndexReader() {
        DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)this.indexWriter);
        Intrinsics.checkNotNullExpressionValue((Object)directoryReader, (String)"open(...)");
        return (IndexReader)directoryReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateMetrics(FileType fileType, long millis2) {
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            Metrics metrics = this.metrics;
            int n = metrics.getIndexedFiles();
            metrics.setIndexedFiles(n + 1);
            if (Intrinsics.areEqual((Object)fileType.getDefaultExtension(), (Object)"kt")) {
                metrics = this.metrics;
                n = metrics.getIndexedKtFiles();
                metrics.setIndexedKtFiles(n + 1);
            } else if (Intrinsics.areEqual((Object)fileType.getDefaultExtension(), (Object)"java")) {
                metrics = this.metrics;
                n = metrics.getIndexedJavaFiles();
                metrics.setIndexedJavaFiles(n + 1);
            } else if (fileType.isBinary()) {
                metrics = this.metrics;
                n = metrics.getIndexedGeneratedFiles();
                metrics.setIndexedGeneratedFiles(n + 1);
            }
            metrics = this.metrics;
            metrics.setIndexingTimeMs(metrics.getIndexingTimeMs() + millis2);
            if (this.metrics.getIndexedFiles() >= 10000) {
                this.metricsQueue.add(this.metrics);
                this.metrics = new Metrics(0, 0, 0, 0, 0L, 31, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(@NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        Integer n = VirtualFileUtilsKt.id(virtualFile2);
        if (n == null) {
            return;
        }
        int fileId = n;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        try {
            this.deleteIndex(fileId);
            this.indexWriter.addDocuments(Bm25UtilsKt.toBm25Documents(fileContent, true));
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            RagIndexerUtilsKt.reportRagIndexError$default("In index", e, null, 4, null);
        }
        long millis2 = System.currentTimeMillis() - start$iv;
        if (!this.indexCommitter.isActive()) {
            this.logger.warn("The thread handling indexing is not active. We use pooled thread instead.");
            RagIndexerUtilsKt.reportRagIndexError$default("indexCommitter is not active in index", null, null, 6, null);
            ApplicationManager.getApplication().executeOnPooledThread(() -> CrawlerBm25Indexer.index$lambda$1(this));
            return;
        }
        FileType fileType = fileContent.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        this.updateMetrics(fileType, millis2);
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl2 = false;
            this.indexingDurationInMillisHistogram.recordValue(Math.min(millis2, 10000L));
            Unit unit = Unit.INSTANCE;
        }
        if (millis2 > 2000L) {
            String indexTimeWarning = "Took " + millis2 + " ms to index " + fileContent.getFile().getPath();
            this.logger.info(indexTimeWarning);
            RagIndexerUtilsKt.reportRagIndexError$default(indexTimeWarning, null, null, 6, null);
        }
    }

    @Override
    public void unindex(int fileId) {
        if (!this.unindexCommitter.isActive()) {
            this.logger.warn("The thread handling unindexing is not active. We use pooled thread instead.");
            RagIndexerUtilsKt.reportRagIndexError$default("unindexCommitter is not active in unindex", null, null, 6, null);
            ApplicationManager.getApplication().executeOnPooledThread(() -> CrawlerBm25Indexer.unindex$lambda$0(this, fileId));
            return;
        }
        this.unindexChannel.trySend-JP2dKIU((Object)fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteIndex(int fileId) {
        try {
            Object object = new Query[]{LuceneIndexUtilsKt.getVirtualFileIdQuery(fileId)};
            this.indexWriter.deleteDocuments(object);
            object = (Closeable)this.openIndexReader();
            Throwable throwable = null;
            try {
                IndexReader it = (IndexReader)object;
                boolean bl = false;
                this.numberOfIndexedDocs = it.numDocs();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            String warning = "deleteIndex had an exception";
            this.logger.warn(warning, (Throwable)e);
            RagIndexerUtilsKt.reportRagIndexError$default(warning, e, null, 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexed(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = VirtualFileUtilsKt.id(file);
        if (n == null) {
            return false;
        }
        int fileId = n;
        Query query = LuceneIndexUtilsKt.getVirtualFileIdQuery(fileId);
        try {
            Closeable closeable = (Closeable)this.openIndexReader();
            Throwable throwable = null;
            try {
                IndexReader reader = (IndexReader)closeable;
                boolean bl = false;
                IndexSearcher searcher = new IndexSearcher(reader);
                int matchCount = searcher.count(query);
                boolean bl2 = matchCount > 0;
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            String indexNotFoundWarning = "BM25 index is not found in " + this.indexDirectory;
            this.logger.warn(indexNotFoundWarning, (Throwable)e);
            RagIndexerUtilsKt.reportRagIndexError$default(indexNotFoundWarning, e, null, 4, null);
            return false;
        }
    }

    public void dispose() {
        try {
            Job.DefaultImpls.cancel$default((Job)this.indexCommitter, null, (int)1, null);
            Job.DefaultImpls.cancel$default((Job)this.unindexCommitter, null, (int)1, null);
            if (this.indexWriter.hasUncommittedChanges()) {
                this.indexWriter.commit();
            }
            this.releaseIndexWriter.invoke();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.logger.warn("Error closing index writer", (Throwable)e);
            RagIndexerUtilsKt.reportRagIndexError$default("Error closing index writer", e, null, 4, null);
        }
    }

    @Override
    public void requestIndexRebuild() {
        this.indexWriter.deleteAll();
        this.indexWriter.commit();
        this.rebuildCrawlerIndex();
    }

    private final void rebuildCrawlerIndex() {
        IndexRebuilder.Companion.getInstance().startRebuild(IndexableFilesCrawlerKt.getCRAWLER_NAME(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getStatus() {
        StringBuilder stringBuilder;
        StringBuilder $this$getStatus_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getStatus_u24lambda_u240.append("<html><body>").append('\n');
        $this$getStatus_u24lambda_u240.append("<p>Total # of docs: " + this.indexWriter.getDocStats().numDocs + "</p>").append('\n');
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl2 = false;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                PrintStream it = (PrintStream)closeable;
                boolean bl3 = false;
                this.indexingDurationInMillisHistogram.outputPercentileDistribution(it, Double.valueOf(1.0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$getStatus_u24lambda_u240.append("<p>Indexing time histogram:</p>").append('\n');
            $this$getStatus_u24lambda_u240.append("<pre>").append('\n');
            $this$getStatus_u24lambda_u240.append(outputStream.toString(StandardCharsets.UTF_8)).append('\n');
            StringBuilder stringBuilder2 = $this$getStatus_u24lambda_u240.append("</pre>").append('\n');
        }
        $this$getStatus_u24lambda_u240.append("</body></html>").append('\n');
        return stringBuilder.toString();
    }

    private static final Unit _init_$lambda$0(CrawlerBm25Indexer this$0) {
        LuceneIndexWriterManagerService.Companion.getInstance().releaseIndexWriter(this$0.indexDirectory, this$0.indexWriter);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CrawlerBm25Indexer this$0, FSDirectory $fsDir) {
        this$0.indexWriter.close();
        $fsDir.close();
        return Unit.INSTANCE;
    }

    private static final void index$lambda$1(CrawlerBm25Indexer this$0) {
        this$0.indexWriter.commit();
    }

    private static final void unindex$lambda$0(CrawlerBm25Indexer this$0, int $fileId) {
        this$0.deleteIndex($fileId);
    }

    @VisibleForTesting
    public /* synthetic */ CrawlerBm25Indexer(CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval, Bm25SearchTool searchTool, DefaultConstructorMarker $constructor_marker) {
        this(scope2, ioDispatcher, indexDirectory, indexCommitInterval, searchTool);
    }

    public /* synthetic */ CrawlerBm25Indexer(CoroutineScope scope2, DefaultConstructorMarker $constructor_marker) {
        this(scope2);
    }

    static {
        creationTraceLock = new Object();
        INDEX_COMMIT_INTERVAL = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/aiplugin/rag/bm25/CrawlerBm25Indexer$Companion;", "Lcom/google/aiplugin/rag/internal/RagIndexerFactory;", "<init>", "()V", "creationTrace", "", "creationTraceLock", "", "createIndexer", "Lcom/google/aiplugin/rag/bm25/CrawlerBm25Indexer;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "INDEX_COMMIT_INTERVAL", "Lkotlin/time/Duration;", "J", "MAX_MEASURED_LATENCY_MS", "", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nCrawlerBm25Indexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrawlerBm25Indexer.kt\ncom/google/aiplugin/rag/bm25/CrawlerBm25Indexer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1#2:420\n*E\n"})
    public static final class Companion
    implements RagIndexerFactory {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public CrawlerBm25Indexer createIndexer(@NotNull CoroutineScope scope2) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Object object = creationTraceLock;
            synchronized (object) {
                boolean bl = false;
                Throwable throwable = creationTrace;
                if (throwable != null) {
                    Throwable oldTrace = throwable;
                    boolean bl2 = false;
                    throw new AssertionError("Bm25Indexer already created - cannot recreate", oldTrace);
                }
                CrawlerBm25Indexer indexer2 = new CrawlerBm25Indexer(scope2, null);
                creationTrace = new Throwable("Previous Bm25Indexer created here");
                Disposer.register((Disposable)indexer2, Companion::createIndexer$lambda$0$1);
                CrawlerBm25Indexer crawlerBm25Indexer = indexer2;
                return crawlerBm25Indexer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void createIndexer$lambda$0$1() {
            Object object = creationTraceLock;
            synchronized (object) {
                boolean bl = false;
                creationTrace = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/google/aiplugin/rag/bm25/CrawlerBm25Indexer$Metrics;", "", "indexedKtFiles", "", "indexedJavaFiles", "indexedGeneratedFiles", "indexedFiles", "indexingTimeMs", "", "<init>", "(IIIIJ)V", "getIndexedKtFiles", "()I", "setIndexedKtFiles", "(I)V", "getIndexedJavaFiles", "setIndexedJavaFiles", "getIndexedGeneratedFiles", "setIndexedGeneratedFiles", "getIndexedFiles", "setIndexedFiles", "getIndexingTimeMs", "()J", "setIndexingTimeMs", "(J)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "aiplugin.rag.indexer"})
    private static final class Metrics {
        private int indexedKtFiles;
        private int indexedJavaFiles;
        private int indexedGeneratedFiles;
        private int indexedFiles;
        private long indexingTimeMs;

        public Metrics(int indexedKtFiles, int indexedJavaFiles, int indexedGeneratedFiles, int indexedFiles, long indexingTimeMs) {
            this.indexedKtFiles = indexedKtFiles;
            this.indexedJavaFiles = indexedJavaFiles;
            this.indexedGeneratedFiles = indexedGeneratedFiles;
            this.indexedFiles = indexedFiles;
            this.indexingTimeMs = indexingTimeMs;
        }

        public /* synthetic */ Metrics(int n, int n2, int n3, int n4, long l2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            if ((n5 & 0x10) != 0) {
                l2 = 0L;
            }
            this(n, n2, n3, n4, l2);
        }

        public final int getIndexedKtFiles() {
            return this.indexedKtFiles;
        }

        public final void setIndexedKtFiles(int n) {
            this.indexedKtFiles = n;
        }

        public final int getIndexedJavaFiles() {
            return this.indexedJavaFiles;
        }

        public final void setIndexedJavaFiles(int n) {
            this.indexedJavaFiles = n;
        }

        public final int getIndexedGeneratedFiles() {
            return this.indexedGeneratedFiles;
        }

        public final void setIndexedGeneratedFiles(int n) {
            this.indexedGeneratedFiles = n;
        }

        public final int getIndexedFiles() {
            return this.indexedFiles;
        }

        public final void setIndexedFiles(int n) {
            this.indexedFiles = n;
        }

        public final long getIndexingTimeMs() {
            return this.indexingTimeMs;
        }

        public final void setIndexingTimeMs(long l2) {
            this.indexingTimeMs = l2;
        }

        public final int component1() {
            return this.indexedKtFiles;
        }

        public final int component2() {
            return this.indexedJavaFiles;
        }

        public final int component3() {
            return this.indexedGeneratedFiles;
        }

        public final int component4() {
            return this.indexedFiles;
        }

        public final long component5() {
            return this.indexingTimeMs;
        }

        @NotNull
        public final Metrics copy(int indexedKtFiles, int indexedJavaFiles, int indexedGeneratedFiles, int indexedFiles, long indexingTimeMs) {
            return new Metrics(indexedKtFiles, indexedJavaFiles, indexedGeneratedFiles, indexedFiles, indexingTimeMs);
        }

        public static /* synthetic */ Metrics copy$default(Metrics metrics, int n, int n2, int n3, int n4, long l2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = metrics.indexedKtFiles;
            }
            if ((n5 & 2) != 0) {
                n2 = metrics.indexedJavaFiles;
            }
            if ((n5 & 4) != 0) {
                n3 = metrics.indexedGeneratedFiles;
            }
            if ((n5 & 8) != 0) {
                n4 = metrics.indexedFiles;
            }
            if ((n5 & 0x10) != 0) {
                l2 = metrics.indexingTimeMs;
            }
            return metrics.copy(n, n2, n3, n4, l2);
        }

        @NotNull
        public String toString() {
            return "Metrics(indexedKtFiles=" + this.indexedKtFiles + ", indexedJavaFiles=" + this.indexedJavaFiles + ", indexedGeneratedFiles=" + this.indexedGeneratedFiles + ", indexedFiles=" + this.indexedFiles + ", indexingTimeMs=" + this.indexingTimeMs + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.indexedKtFiles);
            result2 = result2 * 31 + Integer.hashCode(this.indexedJavaFiles);
            result2 = result2 * 31 + Integer.hashCode(this.indexedGeneratedFiles);
            result2 = result2 * 31 + Integer.hashCode(this.indexedFiles);
            result2 = result2 * 31 + Long.hashCode(this.indexingTimeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metrics)) {
                return false;
            }
            Metrics metrics = (Metrics)other;
            if (this.indexedKtFiles != metrics.indexedKtFiles) {
                return false;
            }
            if (this.indexedJavaFiles != metrics.indexedJavaFiles) {
                return false;
            }
            if (this.indexedGeneratedFiles != metrics.indexedGeneratedFiles) {
                return false;
            }
            if (this.indexedFiles != metrics.indexedFiles) {
                return false;
            }
            return this.indexingTimeMs == metrics.indexingTimeMs;
        }

        public Metrics() {
            this(0, 0, 0, 0, 0L, 31, null);
        }
    }
}

