/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.android.tools.idea.studiobot.Blob;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolCallMetadata;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.bm25.Bm25Indexer;
import com.google.aiplugin.rag.bm25.Bm25SearchTool$Args$;
import com.google.aiplugin.rag.internal.MatchingFile;
import com.google.aiplugin.rag.internal.OldRagSearchToolResult;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.aiplugin.rag.internal.RagSearchToolResult;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.google.aiplugin.rag.lucene.LuceneIndexUtilsKt;
import com.google.aiplugin.rag.processing.FileResolveUtilsKt;
import com.google.aiplugin.rag.processing.RagReranker;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches an index of the user's code base", description="The index is created by Lucene, and contains a field for the file name and one for its contents.", instructions="Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.", examples={})
@ToolResult(description="Returns up to 50 file paths that match the given query.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001e\u001f B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "withMatchingText", "", "<init>", "(Z)V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "restoreHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "metadata", "Lcom/google/aiplugin/agents/ToolCallMetadata;", "Args", "Handler", "Companion", "aiplugin.rag.indexer"})
public class Bm25SearchTool
implements Tool<Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean withMatchingText;
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon;

    public Bm25SearchTool(boolean withMatchingText) {
        this.withMatchingText = withMatchingText;
        this.name = "code_search";
        this.icon = BasicToolIcon.SEARCH;
    }

    public /* synthetic */ Bm25SearchTool(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching the codebase";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched the codebase";
    }

    @NotNull
    public Handler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args, this.withMatchingText);
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2, @NotNull ToolCallMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return null;
    }

    public Bm25SearchTool() {
        this(false, 1, null);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0017\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "", "terms", "", "", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTerms", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_rag_indexer", "$serializer", "Companion", "aiplugin.rag.indexer"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> terms;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Args(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            this.terms = terms;
        }

        @NotNull
        public final List<String> getTerms() {
            return this.terms;
        }

        @NotNull
        public final List<String> component1() {
            return this.terms;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            return new Args(terms);
        }

        public static /* synthetic */ Args copy$default(Args args, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = args.terms;
            }
            return args.copy(list);
        }

        @NotNull
        public String toString() {
            return "Args(terms=" + this.terms + ")";
        }

        public int hashCode() {
            return ((Object)this.terms).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual(this.terms, args.terms);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_rag_indexer(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.terms);
        }

        public /* synthetic */ Args(int seen0, List terms, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.terms = terms;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "aiplugin.rag.indexer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J;\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0012*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion;", "", "<init>", "()V", "buildSearchQuery", "Lorg/apache/lucene/search/Query;", "Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "terms", "", "", "reportMetrics", "", "resultCount", "", "millis", "", "totalIndexedDocs", "bm25Search", "", "query", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "withMatchingText", "", "bm25Search$aiplugin_rag_indexer", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25SearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1#2:245\n1#2:256\n11546#3,9:246\n13472#3:255\n13473#3:257\n11555#3:258\n1193#4,2:259\n1267#4,4:261\n*S KotlinDebug\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion\n*L\n228#1:256\n228#1:246,9\n228#1:255\n228#1:257\n228#1:258\n229#1:259,2\n229#1:261,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Query buildSearchQuery(Bm25Indexer $this$buildSearchQuery, List<String> terms) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            String query = CollectionsKt.joinToString$default((Iterable)terms, (CharSequence)" OR ", null, null, (int)0, null, Companion::buildSearchQuery$lambda$0, (int)30, null);
            Query filePathQuery = new QueryParser("vfile.path", $this$buildSearchQuery.getAnalyzer()).parse(query);
            booleanQuery.add(filePathQuery, BooleanClause.Occur.SHOULD);
            Query contentQuery = new QueryParser("vfile.contents", $this$buildSearchQuery.getAnalyzer()).parse(query);
            booleanQuery.add(contentQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery booleanQuery2 = booleanQuery.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery2, (String)"build(...)");
            return (Query)booleanQuery2;
        }

        private final void reportMetrics(int resultCount, long millis2, int totalIndexedDocs) {
            RagIndexerUtilsKt.reportRagToolMetrics(resultCount, 0, 0, millis2, totalIndexedDocs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Integer, String> bm25Search$aiplugin_rag_indexer(@NotNull Bm25Indexer $this$bm25Search, @NotNull Query query, @Nullable Logger logger, boolean withMatchingText) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$bm25Search, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            try {
                Object index;
                object = (Closeable)$this$bm25Search.openIndexReader();
                Throwable throwable = null;
                try {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Highlighter highlighter2;
                    Highlighter highlighter3;
                    IndexSearcher indexSearcher;
                    index = (IndexReader)object;
                    boolean bl = false;
                    Logger logger2 = logger;
                    if (logger2 != null) {
                        logger2.debug("Searching index version " + LuceneIndexUtilsKt.getVersion(index) + ", #docs " + index.numDocs());
                    }
                    IndexSearcher it = indexSearcher = new IndexSearcher(index);
                    boolean bl2 = false;
                    it.setSimilarity($this$bm25Search.getSimilarity());
                    IndexSearcher searcher = indexSearcher;
                    int maxHits = 200;
                    if (withMatchingText) {
                        QueryScorer queryScorer = new QueryScorer(query, index, "vfile.contents");
                        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("", "");
                        Highlighter $this$bm25Search_u24lambda_u240_u241 = highlighter3 = new Highlighter((Formatter)formatter, (Scorer)queryScorer);
                        boolean bl3 = false;
                        $this$bm25Search_u24lambda_u240_u241.setTextFragmenter((Fragmenter)new NullFragmenter());
                        highlighter2 = highlighter3;
                    } else {
                        highlighter2 = null;
                    }
                    Highlighter highlighter4 = highlighter2;
                    Intrinsics.checkNotNullExpressionValue((Object)searcher.search((Query)query, (int)maxHits).scoreDocs, (String)"scoreDocs");
                    Object[] queryScorer = searcher.search((Query)query, (int)maxHits).scoreDocs;
                    boolean $i$f$mapNotNull = false;
                    highlighter3 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        Integer it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl4 = false;
                        ScoreDoc scoreDoc = (ScoreDoc)element$iv$iv;
                        boolean bl5 = false;
                        StoredFields storedFields = searcher.storedFields();
                        Intrinsics.checkNotNullExpressionValue((Object)storedFields, (String)"storedFields(...)");
                        if (LuceneIndexUtilsKt.getVirtualFileIdForDoc(storedFields, scoreDoc.doc) == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    destination$iv$iv = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv2;
                        int it2 = ((Number)element$iv$iv).intValue();
                        boolean bl7 = false;
                        Pair pair = TuplesKt.to((Object)it2, (Object)com.google.aiplugin.rag.bm25.Bm25SearchTool$Companion.bm25Search$lambda$0$findContext(highlighter4, logger, $this$bm25Search, it2));
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    index = destination$iv$iv2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = index;
            }
            catch (Exception e) {
                block17: {
                    Object object2;
                    block19: {
                        block18: {
                            if (e instanceof ControlFlowException) break block17;
                            Logger logger3 = logger;
                            if (logger3 != null) {
                                logger3.warn("Error opening lucene index", (Throwable)e);
                            }
                            if ((object2 = RagIndexer.Companion.getInstance()) == null) break block18;
                            RagIndexer indexer2 = object2;
                            boolean bl = false;
                            String string = indexer2.getClass().getSimpleName() + " " + indexer2.getVersion();
                            object2 = string;
                            if (string != null) break block19;
                        }
                        object2 = "no indexer info";
                    }
                    Object indexerInfo = object2;
                    RagIndexerUtilsKt.reportRagToolError((String)indexerInfo + "\nError opening lucene index", e);
                }
                object = MapsKt.emptyMap();
            }
            return object;
        }

        public static /* synthetic */ Map bm25Search$aiplugin_rag_indexer$default(Companion companion, Bm25Indexer bm25Indexer, Query query, Logger logger, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                logger = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.bm25Search$aiplugin_rag_indexer(bm25Indexer, query, logger, bl);
        }

        private static final CharSequence buildSearchQuery$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = QueryParser.escape((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escape(...)");
            return string;
        }

        private static final String bm25Search$lambda$0$findContext(Highlighter highlighter2, Logger $logger, Bm25Indexer $this_bm25Search, int vfId) {
            if (highlighter2 == null) {
                return "";
            }
            VirtualFile virtualFile2 = FileResolveUtilsKt.findVirtualFileById(vfId, $logger);
            if (virtualFile2 == null) {
                return "";
            }
            VirtualFile virtualFile3 = virtualFile2;
            List relaventLines = new ArrayList();
            for (String line : StringsKt.lines((CharSequence)VirtualFileUtil.readText((VirtualFile)virtualFile3))) {
                String fragment;
                if (StringsKt.isBlank((CharSequence)line) || (fragment = highlighter2.getBestFragment($this_bm25Search.getAnalyzer(), "vfile.contents", line)) == null) continue;
                relaventLines.add(((Object)StringsKt.trim((CharSequence)fragment)).toString());
            }
            return StringsKt.take((String)CollectionsKt.joinToString$default((Iterable)relaventLines, (CharSequence)" ... ", null, null, (int)0, null, null, (int)62, null), (int)200);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "withMatchingText", "", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;Z)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25SearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n24#2:245\n29#3,2:246\n31#3:252\n1563#4:248\n1634#4,3:249\n1563#4:253\n1634#4,3:254\n*S KotlinDebug\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n*L\n100#1:245\n112#1:246,2\n112#1:252\n125#1:248\n125#1:249,3\n140#1:253\n140#1:254,3\n*E\n"})
    public static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final Args args;
        private final boolean withMatchingText;
        @NotNull
        private final Logger logger;

        public Handler(@NotNull ToolContext context2, @NotNull Args args, boolean withMatchingText) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
            this.withMatchingText = withMatchingText;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final Args getArgs() {
            return this.args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            RagIndexer indexer2 = RagIndexer.Companion.getInstance();
            if (!(indexer2 instanceof Bm25Indexer)) {
                this.logger.warn("Bm25 Indexer is not active");
                RagIndexerUtilsKt.reportRagToolError$default("Bm25 Indexer is not active in code_search", null, 2, null);
                return new Response(null, "code search is disabled", null, null, null, 29, null);
            }
            return com.intellij.openapi.application.CoroutinesKt.readAction(() -> Handler.handle$lambda$0(this, indexer2), $completion);
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$0(Handler this$0, RagIndexer $indexer) {
            Response response2;
            void $this$mapTo$iv$iv;
            RagSearchToolResult result2 = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl4 = false;
            Query query = Companion.buildSearchQuery((Bm25Indexer)$indexer, this$0.args.getTerms());
            Map<Integer, String> docIds = Companion.bm25Search$aiplugin_rag_indexer((Bm25Indexer)$indexer, query, this$0.logger, this$0.withMatchingText);
            Cancellation.checkCancelled();
            List projectFiles2 = (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends VirtualFile>>, Object>(this$0, docIds, null){
                int label;
                final /* synthetic */ Handler this$0;
                final /* synthetic */ Map<Integer, String> $docIds;
                {
                    this.this$0 = $receiver;
                    this.$docIds = $docIds;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = RagReranker.Companion.rerank(this.this$0.getContext().getProject(), FileResolveUtilsKt.findOrUnindexVirtualFilesById((Collection<Integer>)this.$docIds.keySet(), Handler.access$getLogger$p(this.this$0)), (Continuation<? super List<? extends VirtualFile>>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends VirtualFile>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Cancellation.checkCancelled();
            Iterable $this$map$iv = CollectionsKt.take((Iterable)projectFiles2, (int)50);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                collection.add(new MatchingFile(string, docIds.getOrDefault(VirtualFileUtilsKt.id((VirtualFile)it), "")));
            }
            List list = (List)destination$iv$iv;
            result2 = new RagSearchToolResult(list);
            long millis2 = System.currentTimeMillis() - start$iv2;
            RagSearchToolResult $this$handle_u24lambda_u240_u241 = bl4 = result2;
            boolean bl3 = false;
            Companion.reportMetrics($this$handle_u24lambda_u240_u241.getMatchingFiles().size(), millis2, ((Bm25Indexer)$indexer).getNumberOfIndexedDocs());
            RagSearchToolResult resultNonNull = bl4;
            if (this$0.withMatchingText) {
                response2 = new Response(new Gson().toJson((Object)resultNonNull), null, null, null, null, 30, null);
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable start$iv2 = resultNonNull.getMatchingFiles();
                Gson gson = new Gson();
                boolean $i$f$map2 = false;
                RagSearchToolResult bl4 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    MatchingFile matchingFile = (MatchingFile)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it.getPath());
                }
                List list2 = (List)destination$iv$iv2;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 30;
                Response.ToolExecutionStatus toolExecutionStatus = null;
                List list3 = null;
                Blob blob = null;
                String string = null;
                String string2 = gson.toJson((Object)new OldRagSearchToolResult(list2));
                response2 = new Response(string2, string, blob, list3, toolExecutionStatus, n, defaultConstructorMarker);
            }
            return response2;
        }

        public static final /* synthetic */ Logger access$getLogger$p(Handler $this) {
            return $this.logger;
        }
    }
}

