/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.bm25.Bm25FindFilesTool;
import com.google.aiplugin.rag.bm25.Bm25Indexer;
import com.google.aiplugin.rag.bm25.Bm25SearchTool;
import com.google.aiplugin.rag.bm25.FindFilesArgs;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.aiplugin.rag.processing.FileResolveUtilsKt;
import com.google.aiplugin.rag.processing.RagReranker;
import com.google.gson.Gson;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Looks up the absolute path to files given only the file name or a part of the file path.", description="Searches for all files in the project whose names contain the specified tokens (case-insensitive).", instructions="The maximum number of results is 100. Attempt a more specific query if this limit is reached. Note: Only searches through files within the project, excluding libraries and external dependencies.", examples={})
@ToolResult(description="Returns a JSON array of objects containing the full paths that match the query.\n- path: Absolute path\n- type: Optional field, set to \"directory\" if the path corresponds to a directory.\nReturns an empty array ([]) if no matching files are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/bm25/FindFilesArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "HandlerWithoutBm25Search", "Handler", "Companion", "aiplugin.rag.indexer"})
public final class Bm25FindFilesTool
implements Tool<FindFilesArgs> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.SEARCH;
    public static final int MAX_RESULTS = 100;

    public Bm25FindFilesTool() {
        this.name = "find_files";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched for files matching " + args.getQuery();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched for files matching " + args.getQuery();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        RagIndexer indexer2 = RagIndexer.Companion.getInstance();
        return indexer2 instanceof Bm25Indexer ? (ToolHandler)new Handler(context2, args.getQuery(), (Bm25Indexer)indexer2) : (ToolHandler)new HandlerWithoutBm25Search(context2, args.getQuery());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\t*\u0001\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion;", "", "<init>", "()V", "MAX_RESULTS", "", "buildSearchQuery", "Lorg/apache/lucene/search/Query;", "Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "query", "", "findFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "maxResults", "getFileNameCollector", "com/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion$getFileNameCollector$1", "baseNamePart", "(Ljava/lang/String;)Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion$getFileNameCollector$1;", "mergeSearchResults", "resultsWithHigherRank", "resultsWithLowerRank", "toJson", "files", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25FindFilesTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25FindFilesTool.kt\ncom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n774#2:232\n865#2,2:233\n774#2:235\n865#2,2:236\n774#2:238\n865#2,2:239\n1563#2:241\n1634#2,3:242\n1374#2:245\n1460#2,5:246\n774#2:251\n865#2,2:252\n774#2:254\n865#2,2:255\n1056#2:257\n*S KotlinDebug\n*F\n+ 1 Bm25FindFilesTool.kt\ncom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion\n*L\n213#1:232\n213#1:233,2\n216#1:235\n216#1:236,2\n221#1:238\n221#1:239,2\n227#1:241\n227#1:242,3\n179#1:245\n179#1:246,5\n180#1:251\n180#1:252,2\n181#1:254\n181#1:255,2\n182#1:257\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Query buildSearchQuery(Bm25Indexer $this$buildSearchQuery, String query) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            String escapedQuery = QueryParser.escape((String)query);
            Query fileNameQuery = new QueryParser("vfile.path", $this$buildSearchQuery.getAnalyzer()).parse(escapedQuery);
            booleanQuery.add(fileNameQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery booleanQuery2 = booleanQuery.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery2, (String)"build(...)");
            return (Query)booleanQuery2;
        }

        private final List<VirtualFile> findFiles(String query, Project project2, int maxResults) {
            String string = query;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String pathQuery = string2;
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(project2);
            return (List)ActionsKt.runReadAction(() -> Companion.findFiles$lambda$0(project2, pathQuery, maxResults, aiExcludeService2));
        }

        private final getFileNameCollector.1 getFileNameCollector(String baseNamePart) {
            return new Processor<String>(baseNamePart){
                private final Set<String> fileNames;
                final /* synthetic */ String $baseNamePart;
                {
                    this.$baseNamePart = $baseNamePart;
                    this.fileNames = new LinkedHashSet<E>();
                }

                public final Set<String> getFileNames() {
                    return this.fileNames;
                }

                public boolean process(String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    if (StringsKt.contains((CharSequence)name, (CharSequence)this.$baseNamePart, (boolean)true)) {
                        this.fileNames.add(name);
                    }
                    return true;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> mergeSearchResults(List<? extends VirtualFile> resultsWithHigherRank, List<? extends VirtualFile> resultsWithLowerRank) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filterTo$iv$iv3;
            Set higherRankSet = CollectionsKt.toSet((Iterable)resultsWithHigherRank);
            Set lowerRankSet = CollectionsKt.toSet((Iterable)resultsWithLowerRank);
            Iterable $this$filter$iv = resultsWithHigherRank;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!lowerRankSet.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inBoth = (List)destination$iv$iv;
            if (inBoth.size() >= 100) {
                return CollectionsKt.take((Iterable)inBoth, (int)100);
            }
            Iterable $this$filter$iv2 = resultsWithHigherRank;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!lowerRankSet.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List onlyInHigherRank = (List)destination$iv$iv2;
            if (inBoth.size() + onlyInHigherRank.size() >= 100) {
                return CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)inBoth, (Iterable)onlyInHigherRank), (int)100);
            }
            Iterable $this$filter$iv3 = resultsWithLowerRank;
            boolean $i$f$filter3 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!higherRankSet.contains(it))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List onlyInLowerRank = (List)destination$iv$iv3;
            return CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)inBoth, (Iterable)onlyInHigherRank), (Iterable)onlyInLowerRank), (int)100);
        }

        /*
         * WARNING - void declaration
         */
        private final String toJson(List<? extends VirtualFile> files2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = files2;
            Gson gson = new Gson();
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0015"}, d2={"com/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion$toJson$FilePath", "", "path", "", "isDirectory", "", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "getPath", "()Ljava/lang/String;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Companion$toJson$FilePath;", "equals", "other", "hashCode", "", "toString", "aiplugin.rag.indexer"})
                public final class FilePath {
                    private final String path;
                    private final Boolean isDirectory;

                    public FilePath(String path2, Boolean isDirectory) {
                        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                        this.path = path2;
                        this.isDirectory = isDirectory;
                    }

                    public final String getPath() {
                        return this.path;
                    }

                    public final Boolean isDirectory() {
                        return this.isDirectory;
                    }

                    public final String component1() {
                        return this.path;
                    }

                    public final Boolean component2() {
                        return this.isDirectory;
                    }

                    public final FilePath copy(String path2, Boolean isDirectory) {
                        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                        return new FilePath(path2, isDirectory);
                    }

                    public static /* synthetic */ FilePath copy$default(FilePath filePath, String string, Boolean bl, int n, Object object) {
                        if ((n & 1) != 0) {
                            string = filePath.path;
                        }
                        if ((n & 2) != 0) {
                            bl = filePath.isDirectory;
                        }
                        return filePath.copy(string, bl);
                    }

                    public String toString() {
                        return "FilePath(path=" + this.path + ", isDirectory=" + this.isDirectory + ")";
                    }

                    public int hashCode() {
                        int result2 = this.path.hashCode();
                        result2 = result2 * 31 + (this.isDirectory == null ? 0 : ((Object)this.isDirectory).hashCode());
                        return result2;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof FilePath)) {
                            return false;
                        }
                        FilePath filePath = (FilePath)other;
                        if (!Intrinsics.areEqual((Object)this.path, (Object)filePath.path)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.isDirectory, (Object)filePath.isDirectory);
                    }
                }
                collection.add(new FilePath(string, it.isDirectory() ? Boolean.valueOf(true) : null));
            }
            String string = gson.toJson((Object)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private static final List findFiles$lambda$0(Project $project, String $pathQuery, int $maxResults, AiExcludeService $aiExcludeService) {
            void $this$sortedBy$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope scope2 = globalSearchScope;
            Path path2 = Paths.get($pathQuery, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            var fileNameCollector = Companion.getFileNameCollector(PathsKt.getName((Path)path2));
            FilenameIndex.processAllFileNames((Processor)fileNameCollector, (GlobalSearchScope)scope2, null);
            Iterable iterable = fileNameCollector.getFileNames();
            boolean $i$f$flatMap = false;
            void var8_8 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Collection collection = FilenameIndex.getVirtualFilesByName((String)it, (GlobalSearchScope)scope2);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains((CharSequence)string, (CharSequence)$pathQuery, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!$aiExcludeService.isFileExcluded((VirtualFile)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.take((Iterable)CollectionsKt.toSet((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                }
            })), (int)$maxResults);
        }

        public static final /* synthetic */ List access$mergeSearchResults(Companion $this, List resultsWithHigherRank, List resultsWithLowerRank) {
            return $this.mergeSearchResults(resultsWithHigherRank, resultsWithLowerRank);
        }

        public static final /* synthetic */ Query access$buildSearchQuery(Companion $this, Bm25Indexer $receiver, String query) {
            return $this.buildSearchQuery($receiver, query);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "query", "", "indexer", "Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Ljava/lang/String;Lcom/google/aiplugin/rag/bm25/Bm25Indexer;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getQuery", "()Ljava/lang/String;", "getIndexer", "()Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchByBm25", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25FindFilesTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25FindFilesTool.kt\ncom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,231:1\n24#2:232\n*S KotlinDebug\n*F\n+ 1 Bm25FindFilesTool.kt\ncom/google/aiplugin/rag/bm25/Bm25FindFilesTool$Handler\n*L\n107#1:232\n*E\n"})
    public static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final String query;
        @NotNull
        private final Bm25Indexer indexer;
        @NotNull
        private final Logger logger;

        public Handler(@NotNull ToolContext context2, @NotNull String query, @NotNull Bm25Indexer indexer2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)indexer2, (String)"indexer");
            this.context = context2;
            this.query = query;
            this.indexer = indexer2;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @NotNull
        public final Bm25Indexer getIndexer() {
            return this.indexer;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var6_2 = $completion;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    foundFiles = com.google.aiplugin.rag.bm25.Bm25FindFilesTool$Companion.access$findFiles(Bm25FindFilesTool.Companion, this.query, this.context.getProject(), 100);
                    $continuation.L$0 = foundFiles;
                    $continuation.label = 1;
                    v0 = this.searchByBm25((Continuation<? super List<? extends VirtualFile>>)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    foundFiles = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    filesSearchedByBm25 = (List)v0;
                    merged = com.google.aiplugin.rag.bm25.Bm25FindFilesTool$Companion.access$mergeSearchResults(Bm25FindFilesTool.Companion, filesSearchedByBm25, foundFiles);
                    RagIndexerUtilsKt.reportBm25FindFilesToolMetrics(merged.size(), filesSearchedByBm25.size(), foundFiles.size(), this.indexer.getNumberOfIndexedDocs());
                    return new Response(com.google.aiplugin.rag.bm25.Bm25FindFilesTool$Companion.access$toJson(Bm25FindFilesTool.Companion, merged), null, null, null, null, 30, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object searchByBm25(Continuation<? super List<? extends VirtualFile>> $completion) {
            if (!($completion instanceof searchByBm25.1)) ** GOTO lbl-1000
            var5_2 = $completion;
            if ((var5_2.label & -2147483648) != 0) {
                var5_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Handler.access$searchByBm25(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    searchQuery = com.google.aiplugin.rag.bm25.Bm25FindFilesTool$Companion.access$buildSearchQuery(Bm25FindFilesTool.Companion, this.indexer, this.query);
                    docIds = Bm25SearchTool.Companion.bm25Search$aiplugin_rag_indexer(this.indexer, searchQuery, this.logger, false).keySet();
                    $continuation.label = 1;
                    v0 = RagReranker.Companion.rerank(this.context.getProject(), FileResolveUtilsKt.findOrUnindexVirtualFilesById((Collection<Integer>)docIds, this.logger), (Continuation<? super List<? extends VirtualFile>>)$continuation);
                    ** if (v0 != var6_4) goto lbl20
lbl19:
                    // 1 sources

                    return var6_4;
lbl20:
                    // 1 sources

                    ** GOTO lbl26
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        var2_5 = (List)v0;
                    }
                    catch (Exception e) {
                        this.logger.warn("Error file search part with BM25", (Throwable)e);
                        RagIndexerUtilsKt.reportFindFilesToolError("Error file search part with BM25", e);
                        var2_5 = CollectionsKt.emptyList();
                    }
                    return var2_5;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$searchByBm25(Handler $this, Continuation $completion) {
            return $this.searchByBm25((Continuation<? super List<? extends VirtualFile>>)$completion);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25FindFilesTool$HandlerWithoutBm25Search;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "query", "", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Ljava/lang/String;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getQuery", "()Ljava/lang/String;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    public static final class HandlerWithoutBm25Search
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final String query;

        public HandlerWithoutBm25Search(@NotNull ToolContext context2, @NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.context = context2;
            this.query = query;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            List foundFiles = Companion.findFiles(this.query, this.context.getProject(), 100);
            return new Response(Companion.toJson(foundFiles), null, null, null, null, 30, null);
        }
    }
}

