/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.auth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.auth.McpSecretStore;
import com.intellij.codeWithMe.ClientId;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/mcp/auth/McpSecretStoreImpl;", "Lcom/google/aiplugin/mcp/auth/McpSecretStore;", "<init>", "()V", "save", "", "key", "", "secret", "clear", "retrieve", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nMcpSecretStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpSecretStore.kt\ncom/google/aiplugin/mcp/auth/McpSecretStoreImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n40#2,3:73\n24#3:76\n*S KotlinDebug\n*F\n+ 1 McpSecretStore.kt\ncom/google/aiplugin/mcp/auth/McpSecretStoreImpl\n*L\n59#1:73,3\n63#1:76\n*E\n"})
public final class McpSecretStoreImpl
implements McpSecretStore {
    public static final int $stable;

    @Override
    public void save(@NotNull String key, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        CredentialAttributes attributes = this.createCredentialAttributes(key);
        PasswordSafe.Companion.getInstance().set(attributes, new Credentials(key, secret));
    }

    @Override
    public void clear(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CredentialAttributes attributes = this.createCredentialAttributes(key);
        PasswordSafe.Companion.getInstance().set(attributes, null);
    }

    @Override
    @Nullable
    public String retrieve(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CredentialAttributes attributes = this.createCredentialAttributes(key);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        if (credentials == null) {
            return null;
        }
        Credentials credential = credentials;
        if (Intrinsics.areEqual((Object)credential, (Object)CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED()) || Intrinsics.areEqual((Object)credential, (Object)CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN())) {
            String errorMsg = "Unable to access the system keyring. Your login state will not be restored.";
            boolean $i$f$service = false;
            Class<NotificationGroupManager> serviceClass$iv = NotificationGroupManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((NotificationGroupManager)object).getNotificationGroup("MCP Login").createNotification(errorMsg, NotificationType.WARNING).notify(null);
            McpSecretStoreImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(McpSecretStoreImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(errorMsg);
            string = null;
        } else {
            string = credential.getPasswordAsString();
        }
        return string;
    }

    private final CredentialAttributes createCredentialAttributes(String key) {
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"McpCredentialStorage", (String)key));
    }
}

