/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.vcs;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.vcs.GitTool$Args$;
import com.google.aiplugin.agents.tools.vcs.GitToolKt;
import com.google.aiplugin.agents.tools.vcs.VcsTool;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Runs a Git CLI command and returns the exit code, stdout, and stderr", instructions="The Git command will always be executed from the root of the Git repository. If you do not know the Git repo root, you can pass a context file instead, and this tool will find the Git repo root automatically.\n\nIf you need to pass a file path as an argument to the Git command, prefer adding it after the pathspec delimiter (--) and prefer absolute file paths when possible (to avoid ambiguity)\n\nSome Git commands may be slow when running in large projects. Use well-known Git flags to optimize queries when possible. For example, when looking for recent commits, consider passing -5 or -10 to limit the commit history to a small handful of commits.", examples={"git(\n  repoRoot = '/path/to/project',\n  args = ['log', '-10', '--', '/path/to/project/file.kt']\n)"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0013\u0014B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/GitTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/vcs/GitTool$Args;", "Lcom/google/aiplugin/agents/tools/vcs/VcsTool;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Args", "Result", "aiplugin.agents.agents-core"})
public final class GitTool
implements Tool<Args>,
VcsTool<Args> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;

    public GitTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "git";
    }

    public /* synthetic */ GitTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return args.getArgs().isEmpty() ? "Running git" : "Running git " + CollectionsKt.first(args.getArgs());
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return args.getArgs().isEmpty() ? "Ran git" : "Ran git " + CollectionsKt.first(args.getArgs());
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2, this, args){
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ GitTool this$0;
            final /* synthetic */ Args $args;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                this.$args = $args;
            }

            public Object handle(Continuation<? super Response> $completion) {
                return GitToolKt.access$handleGitRequest(this.$context, GitTool.access$getFileSystem$p(this.this$0), this.$args, $completion);
            }
        };
    }

    public GitTool() {
        this(null, 1, null);
    }

    public static final /* synthetic */ VirtualFileSystem access$getFileSystem$p(GitTool $this) {
        return $this.fileSystem;
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B5\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/GitTool$Args;", "", "repoRoot", "", "args", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getRepoRoot", "()Ljava/lang/String;", "getArgs", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_agents_agents_core", "$serializer", "Companion", "aiplugin.agents.agents-core"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String repoRoot;
        @NotNull
        private final List<String> args;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Args(@ToolArgument(description="Absolute path to the Git repository root directory (containing the .git directory), or any context file located inside the repository") @NotNull String repoRoot, @ToolArgument(description="Git command arguments (see below for allowed subcommands). The first Git command argument *must* be one of the following subcommands: blame,diff,help,log,shortlog,show,status,ls-files,ls-tree,merge-tree,rev-list,rev-parse,grep") @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter((Object)repoRoot, (String)"repoRoot");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.repoRoot = repoRoot;
            this.args = args;
        }

        @NotNull
        public final String getRepoRoot() {
            return this.repoRoot;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        @NotNull
        public final String component1() {
            return this.repoRoot;
        }

        @NotNull
        public final List<String> component2() {
            return this.args;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="Absolute path to the Git repository root directory (containing the .git directory), or any context file located inside the repository") @NotNull String repoRoot, @ToolArgument(description="Git command arguments (see below for allowed subcommands). The first Git command argument *must* be one of the following subcommands: blame,diff,help,log,shortlog,show,status,ls-files,ls-tree,merge-tree,rev-list,rev-parse,grep") @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter((Object)repoRoot, (String)"repoRoot");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new Args(repoRoot, args);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.repoRoot;
            }
            if ((n & 2) != 0) {
                list = args.args;
            }
            return args.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "Args(repoRoot=" + this.repoRoot + ", args=" + this.args + ")";
        }

        public int hashCode() {
            int result2 = this.repoRoot.hashCode();
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.repoRoot, (Object)args.repoRoot)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, args.args);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_agents_agents_core(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.repoRoot);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.args);
        }

        public /* synthetic */ Args(int seen0, String repoRoot, List args, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.repoRoot = repoRoot;
            this.args = args;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/GitTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/agents/tools/vcs/GitTool$Args;", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/GitTool$Result;", "", "exitCode", "", "stdout", "", "stderr", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getExitCode", "()I", "getStdout", "()Ljava/lang/String;", "getStderr", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "aiplugin.agents.agents-core"})
    public static final class Result {
        private final int exitCode;
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Result(int exitCode, @NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public final int getExitCode() {
            return this.exitCode;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        public final int component1() {
            return this.exitCode;
        }

        @NotNull
        public final String component2() {
            return this.stdout;
        }

        @NotNull
        public final String component3() {
            return this.stderr;
        }

        @NotNull
        public final Result copy(int exitCode, @NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Result(exitCode, stdout, stderr);
        }

        public static /* synthetic */ Result copy$default(Result result2, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = result2.exitCode;
            }
            if ((n2 & 2) != 0) {
                string = result2.stdout;
            }
            if ((n2 & 4) != 0) {
                string2 = result2.stderr;
            }
            return result2.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "Result(exitCode=" + this.exitCode + ", stdout=" + this.stdout + ", stderr=" + this.stderr + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.exitCode);
            result2 = result2 * 31 + this.stdout.hashCode();
            result2 = result2 * 31 + this.stderr.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (this.exitCode != result2.exitCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)result2.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)result2.stderr);
        }
    }
}

